/*  File: wcscom.c
 *  Author: Richard Durbin (rd@mrc-lmba.cam.ac.uk)
 *  Copyright (C) J Thierry-Mieg and R Durbin, 1991
 *-------------------------------------------------------------------
 * This file is part of the ACEDB genome database package, written by
 * 	Richard Durbin (MRC LMB, UK) rd@mrc-lmba.cam.ac.uk, and
 *	Jean Thierry-Mieg (CRBM du CNRS, France) mieg@frmop11.bitnet
 *
 * Description:
   File to support communication with the Worm Community System of
   Bruce Schatz et al.
 * Exported functions:
 * HISTORY:
 * Last edited: Apr  7 01:54 1992 (mieg)
 * Created: Fri Nov  1 01:04:57 1991 (rd)
 *-------------------------------------------------------------------
 */

#ifdef WCS

#include "acedb.h"
#include "classes.wrm"
#include "tags.wrm"
#include "lex.h"
#include "display.h"
#include "wcomm.h"
#include "bs.h"
#include "pick.h"

static void wcsAccept (WMsgType request, int count, WHandle *hbuf, WCommLink whoFrom) ;

static WHandle handle ;
static Stack text1 = 0, text2 = 0 ; /* used as text buffers */

/****** first the two routines needed by graphxt.c *****/


void wcommInit (void* display, void* window)
{
  WInitComm ("ACE", display, (Window) window, (WCommType) readwrite, (GraphFunc) wcsAccept) ;
  wcsLink = WOpenCommLink ("WCS", readwrite, wcsAccept) ;
}

void wcommFinish (void)
{
  WEndComm (wcsLink) ;
  WCleanup () ;
}

/*************/

static void textSet (KEY key)
{
  extern char* expandText (KEY key) ; /* in treedisp.c */
  char *expansion ;

  text1 = stackReCreate(text1, 32) ;
  text1 = stackReCreate(text1, 64) ;
  catText (text1, className(key)) ;
  catText (text1, ":") ;
  catText (text1, name(key)) ;
  catText (text2, stackText(text1,0)) ;

  if (expansion = expandText (key))
    { catText (text2, " - ") ;
      catText (text2, expansion) ;
    }

  handle.obj = stackText (text1,0) ;
  handle.note = stackText (text2,0) ;
}

/**************************************/

void wcsAnnotateKey (KEY key)
{ textSet (key) ;
  WSendMsg (wcsLink, MakeAnnotation, 1, &handle) ; 
}

void wcsAnnotate (void)
{ displayBlock (wcsAnnotateKey,
		"You will then be prompted for a WCS annotation.") ;
}

/**************************************/

void wcsShowKey (KEY key)
{ textSet (key) ;
  WSendMsg (wcsLink, ShowAnnotation, 1, &handle) ; 
}

void wcsShow (void)
{ displayBlock (wcsShowKey,
		"You will be shown the corresponding WCS annotations.") ;
}

/************************************/

void wcsSearchKey (KEY key)
{ handle.note = handle.obj = name(key) ;
  WSendMsg (wcsLink, SearchString, 1, &handle) ; 
}


void wcsSearch (void)
{ displayBlock (wcsSearchKey,
		"WCS will then search for that object.") ;		
}

/**********************************************/
extern void pickPopMain(void) ;

static void wcsAccept (WMsgType request, int count, WHandle *hbuf, WCommLink whoFrom)
{
  KEY key, clone ;
  OBJ obj ;
 
  pickPopMain() ;
  switch (request)
    {
    case ShowGenMap:
      if (!lexword2key (hbuf->note, &key, _VGene)
	  && !lexword2key (hbuf->note, &key, _VRearrangement)
	  && !lexword2key (hbuf->note, &key, _VChromosome))
	goto unknown_obj ;
      display (0, key, GMAP) ;
      break ;
    case ShowPhysMap:
      if (!lexword2key (hbuf->note, &clone, _VClone))
	{ if (!lexword2key (hbuf->note, &key, _VGene)
	      || !(obj = bsCreate (key)))
	    goto unknown_obj ;
	  clone = 0 ;
	  bsGetKey (obj, _Clone, &clone) ;
	  bsDestroy (obj) ;
	  if (!clone)
	    { messout ("Gene %s not placed on physical map", 
		       name(key)) ;
	      display (key, 0, 0) ;
	      return ;
	    }
	}
      display (clone, 0, PMAP) ;
      break ;
    case ShowObject:
    case ShowSummary:
      if (lexClassKey(hbuf->obj,&key))
	display (key, 0, 0) ;
      else
	{ char *tmp = hbuf->obj ; /* switch for clean freeing */
	  hbuf->note = hbuf->obj ;
	  hbuf->obj = tmp ;
	  goto unknown_obj ;
	}
      break ;
    default:
      messerror ("Unknown request %d from WCS",request) ;
      break ;
    }
  return ;

unknown_obj:
  if (!hbuf->note)
    hbuf->note = "" ;
  messout ("Unknown ACEDB object %s requested from WCS",hbuf->note) ;
}


#endif /* WCS */

/************ end of file *************/
