/*  File: fredxprop.c
 *  Author: Richard Durbin (rd@mrc-lmba.cam.ac.uk)
 *  Copyright (C) J Thierry-Mieg and R Durbin, 1992
 *-------------------------------------------------------------------
 * This file is part of the ACEDB genome database package, written by
 * 	Richard Durbin (MRC LMB, UK) rd@mrc-lmba.cam.ac.uk, and
 *	Jean Thierry-Mieg (CRBM du CNRS, France) mieg@frmop11.bitnet
 *
 * Description: preliminary version of fredsubs.c using X properties
 	(tzf's wcomm system).  Load this package in place of wcscom.c.
	I use handle->obj to hold header info, handle->note to hold the
	buffer.
 * Exported functions:
 * HISTORY:
 * Last edited: Mar 20 00:48 1992 (rd)
 * Created: Thu Mar 19 22:36:17 1992 (rd)
 *-------------------------------------------------------------------
 */

/* to do: wcommInit must assign the correct names and open ports correctly
   what is the good way to do this?  I think we must predefine who we accept
   things from.
*/

#include "regular.h"
#include "array.h"
#include "fred.h"
#include "wcomm.h"

WCommLink commLink ;		/* set in graphxt.c */

typedef struct LocalTypeStruct
  { FredEvent *event ;
    struct LocalTypeStruct *next ;
  } LocalType ;

static void fredAccept (WMsgType r, int count, WHandle *hbuf, WCommLink whoFrom) ;
static int fredId = 0 ;
static LocalType *eventList ;

/*********************/

void   fredInit (void) {}	/* handled via graphxt.c */

void   fredFinish (void) {}	/* handled via graphxt.c */

void wcommInit (void* display, void* window) /* called by graphStart() */
{
  WInitComm ("ACE", display, window, readwrite, fredAccept) ;
  commLink = WOpenCommLink ("WCS", readwrite, fredAccept) ;
}

void wcommFinish (void)		/* called by graphDevFinish() */
{
  WEndComm (commLink) ;
  WCleanup () ;
}

/*******************/

static void fredQueueEvent (FredEventType type, FredId self, 
			    FredId replyTo, char* buffer)
{
  FredEvent *ev ;
  LocalType *new, *p ;

  ev = (FredEvent *) messalloc (sizeof (FredEvent)) ;
  ev->type = type ;
  ev->replyTo = replyTo ;
  ev->self = self ;
  ev->buffer = (char*) messalloc (1+sizeof(buffer)) ;
  strcpy (ev->buffer, buffer) ;
      
  new = (LocalType *) messalloc (sizeof (LocalEvent)) ;
  new->event = fe ;
  if (eventList)
    { for (p = eventList ; p->next ; p = p->next) ;
      p->next = new ;
    }
  else
    eventList = new ;
}

BOOL fredGetEvent (FredEvent *fe)
{
  LocalType old ;

  if (eventList)
    { *fe = eventList->event ;
      old = eventList ;
      eventList = eventList->next ;
      messfree (old) ;
      return TRUE ;
    }
  else
    return FALSE ;
}

void fredKillEvent (FredEvent *fe)
{
  if (fe->buffer)
    messfree (fe->buffer) ;

  messfree (fe) ;
}

/*********** two routines that actively communicate with wcomm *********/

FredId fredSendEvent (FredEvent *fe)
{
  WHandle handle ;

  ++fredId ;			/* ALWAYS assign an ID */
  fe->self = fredId ;

  if (fe->type < 0 || fe->type >= MAX_FRED_EVENT_TYPE)
    { fredQueueEvent (ERROR_MESSAGE, fredId+1, fredId, 
		      messprintf ("FredEventType %d out of range 0 - %d",
				  fe->type, MAX_FRED_EVENT_TYPE - 1)) ;
      ++fredId ;		/* since created a new message */
    }
  else
    { handle.obj = messprintf ("%d %d %d", fe->type, fe->self, fe->replyTo) ;
      handle.note = fe->buffer ;
      WSendMsg (commLink, FredMessage, 1, &handle) ;
    }

  return fe->self ;
}

static void fredAccept (WMsgType request, int count, WHandle *hbuf, WCommLink whoFrom)
{
  int type, self, replyTo ;

  if (request == FredMessage)
    if (sscanf (hbuf->obj, "%d %d %d", &type, &self, &replyTo) != 3)
      { ++fredId ;
	fredQueueEvent (ERROR_MESSAGE, fredId, 0, 
			messprintf ("Received bad message header: %s",
				    hbuf->obj)) ;
      }
    else
      fredQueueEvent (type, self, replyTo, hbuf->note) ;
}

/*************** end of file ****************/
