/*  File: xtsubs.c
 *  Author: Richard Durbin (rd@mrc-lmba.cam.ac.uk)
 *  Copyright (C) J Thierry-Mieg and R Durbin, 1992
 *-------------------------------------------------------------------
 * This file is part of the ACEDB genome database package, written by
 * 	Richard Durbin (MRC LMB, UK) rd@mrc-lmba.cam.ac.uk, and
 *	Jean Thierry-Mieg (CRBM du CNRS, France) mieg@frmop11.bitnet
 *      with help from Christopher Lee in this module.
 *
 * Description: popUp's for X version of graph package
 * Exported functions: graphOut, Query, Prompt, Menu and FreeMenu
 * HISTORY:
 * Last edited: Mar 31 19:01 1992 (mieg)
 * * Mar 31 19:00 1992 (mieg): added castings to please IBM
 * Created: Thu Jan  2 02:11:04 1992 (rd)
 *-------------------------------------------------------------------
 */

#include "regular.h"
#include "array.h"
#include "graphxt_.h"
#include<X11/Xaw/Dialog.h>
#include<X11/Xaw/Command.h>
#include<X11/Xaw/SimpleMenu.h>
#include<X11/Xaw/SmeBSB.h>
#include<X11/Xaw/SmeLine.h>

static Arg args[10];		/* convenience variable */

static Widget popshell, dialog ;
	/* I tried keeping these constant and mapping/unmapping
	   components, but the calls are too variable, so the
	   geometry got into a tangle.  Domage */

static isLocalLoop = FALSE ;
static BOOL result ;

/****** basic dialog box for everything but menus ******/

static void makeDialog (char *text)
{
  Position x,y ;
  int n ;

  if (gDev)
    { XtTranslateCoords (gDev->viewport, 
			 (Position) 25, (Position) 20,
			 &x, &y) ;
      if (x < 25) x = 25 ;
      if (x > 900) x = 900 ;
      if (y < 20) y = 20 ;
      if (y > 700) y = 700 ;
    }
  else
    { x = 500 ; y = 400 ; }
  n = 0;
  XtSetArg (args[n], XtNx, x) ;	n++ ;
  XtSetArg (args[n], XtNy, y) ;	n++ ;
  popshell = XtCreatePopupShell ("devsubs", transientShellWidgetClass,
				 root_widget, args, n) ;
  dialog = XtCreateManagedWidget ("dialog", dialogWidgetClass,
				  popshell, args, 0) ;
  XtVaSetValues (dialog, XtNlabel, uBrokenText (text, 40), NULL) ;
  XBell (XtDisplay(popshell), 0) ;
}

static void endAction (Widget w, XtPointer client_data, XtPointer call_data)
{
  XtPopdown (popshell) ;
  isLocalLoop = FALSE ;
  result = (BOOL) client_data ;
}

static void localLoop (void)
{
  XEvent ev ;

  XtPopup (popshell, XtGrabExclusive) ;
  isLocalLoop = TRUE ;
  while (isLocalLoop)
    {
      XtAppNextEvent (app_con, &ev) ;
      XtDispatchEvent (&ev) ;
    }
  XtDestroyWidget (popshell) ;
}

void graphOut (char *text)
{
  Widget button ;

  makeDialog (text) ;
  
  button = XtCreateManagedWidget ("Continue", commandWidgetClass, 
				  dialog, args, 0) ;
  XtAddCallback (button, XtNcallback, endAction, (XtPointer) FALSE) ;

  localLoop () ;
}

BOOL graphQuery (char *text)
{
  Widget yes, no ;

  makeDialog (text) ;

  yes = XtCreateManagedWidget ("Yes", commandWidgetClass, dialog, args, 0) ;
  XtAddCallback (yes, XtNcallback, endAction, (XtPointer) TRUE) ;

  no = XtCreateManagedWidget ("No", commandWidgetClass, dialog, args, 0) ;
  XtAddCallback (no, XtNcallback, endAction, (XtPointer) FALSE) ;

  localLoop () ;
  return result ;
}

void promptReturn (Widget w, XEvent* ev, String *params, Cardinal *num_params)
{
  isLocalLoop = FALSE ;
  result = TRUE ;
}

BOOL graphBadPrompt (char *prompt, char *dfault, char *fmt)
{
  Widget ok, cancel ;

  makeDialog (prompt) ;

  ok = XtCreateManagedWidget ("OK", commandWidgetClass, dialog, args, 0) ;
  XtAddCallback (ok, XtNcallback, endAction, (XtPointer) TRUE) ;

  cancel = XtCreateManagedWidget ("Cancel", commandWidgetClass, dialog, args, 0) ;
  XtAddCallback (cancel, XtNcallback, endAction, (XtPointer) FALSE) ;

  while (TRUE)	/* iterate on format mismatch */
    {
      XtVaSetValues (dialog, XtNvalue, dfault, NULL) ;
      
      localLoop () ;
      
      if (!result)
	return FALSE ;
      freeforcecard (dfault = XawDialogGetValueString (dialog)) ;
      if (freecheck (fmt))
	return TRUE ;
      XtVaSetValues (dialog, XtNlabel,
       "Sorry, invalid response. Try again or cancel", NULL) ;
    }
}

BOOL graphSelect (KEY *kpt, FREEOPT *options)
{	/* slightly wrong - assumes that no option->key == 0 */
  Widget button ;
 int i ;

  makeDialog (options->text) ;
  XtVaSetValues (dialog, XtNmaxWidth, 300, NULL) ;

  for (i = 1 ; i <= options->key ; ++i)
    {
      button = XtCreateManagedWidget (options[i].text, commandWidgetClass, 
				      dialog, args, 0) ;
      XtAddCallback (button, XtNcallback, endAction, (XtPointer) options[i].key) ;
    }
  button = XtCreateManagedWidget ("Cancel", commandWidgetClass, dialog, args, 0) ;
  XtAddCallback (button, XtNcallback, endAction, (XtPointer)  FALSE) ;

  localLoop () ;

  if (result)
    { *kpt = result ;
      return TRUE ;
    }
  else
    return FALSE ;
}

/*** another version of graphPrompt based on graph package ***/

static void okReturn (void) { graphUnBlock(TRUE) ; }
static void cancelReturn (void) { graphUnBlock (FALSE) ;}
static void entryProcess (char *text) { graphUnBlock (TRUE) ; }

BOOL graphPrompt (char *prompt, char *dfault, char *fmt)
     /* version written in graph package because X doesn't work! */
{
  char buf[41], *cp ;
  float line = 0.5 ;
  Graph gsave = gActive ? gActive->id : 0 ;
  static MENUOPT buttons[] = { okReturn, "OK",
			       cancelReturn, "Cancel",
			       0, 0
			     } ;

  graphCreate (TEXT_SCROLL, "Please Answer This",
			 0.5,0.4,0.45,0.25) ;

  uLinesText (prompt, 40) ;
  while (cp = uNextLine (prompt))
    graphText (cp, 1, line++) ;
  
  memset(buf,0,41) ;/* JTM otherwise by typing in you collect garbage */
  strncpy (buf, dfault, 40) ;
  line += 0.5 ;
  graphTextEntry (buf, 40, 2, line++, entryProcess) ;

  line += 0.5 ;
  graphButtons (buttons, 4, line++, 40) ;
  line += 0.5 ;

  graphRedraw() ;

  while (result = graphBlock())	/* iterate on format mismatch */
    {
      if (!result)
	{ graphActivate (gsave) ; return FALSE ; }
      freeforcecard (buf) ;
      if (freecheck (fmt))
	break ;
      graphText ("Sorry, invalid response. Try again or cancel", 1, line) ;
    }

  graphDestroy () ;
  graphActivate (gsave) ;
  return result ;
}

/******* menus ********/


static void freeMenuSelect (Widget w, XtPointer data, XtPointer junk)
{
  if (gDev && gDev->menuProc)
    (*gDev->menuProc)((KEY) data) ;
}

void graphFreeMenu (MenuRoutine proc, FREEOPT *options)
{
  int i = 0 ;
  Widget entry ;

  if (!gDev)
    return ;

  if (gDev->menuWidget)
    XtDestroyWidget (gDev->menuWidget) ;

/*  XtSetArg(args[i], XtNlabel, options->text) ; ++i ; */
  gDev->menuWidget = XtCreatePopupShell ("menu", 
					 simpleMenuWidgetClass,
					 gDev->simple, args, i) ;
	/* horizontal line below title */
/*  XtCreateManagedWidget ("", smeLineObjectClass,
			 gDev->menuWidget, NULL, 0) ; */

  for (i = 1 ; i <= options->key ; ++i)
    { entry = XtCreateManagedWidget (options[i].text, 
				     smeBSBObjectClass,
				     gDev->menuWidget, NULL, 0) ;
      XtAddCallback (entry, XtNcallback, 
		     freeMenuSelect, (XtPointer) options[i].key) ;
    }
  gDev->menuProc = proc ;
}

void devMenuDestroy(void) {}

/*******************/

static void optMenuSelect (Widget w, XtPointer data, XtPointer junk)
{
  (*(VoidRoutine)data)() ;
}

void graphMenu (MENUOPT *options)
{
  Widget entry ;

  if (!gDev)
    return ;

  if (gDev->menuWidget) 
    XtDestroyWidget(gDev->menuWidget) ;

  gDev->menuWidget = XtCreatePopupShell ("menu", 
					 simpleMenuWidgetClass,
					 gDev->simple, args, 0) ;
  while (options->f)
    { entry = XtCreateManagedWidget (options->text,
				     smeBSBObjectClass,
				     gDev->menuWidget, NULL, 0) ;
      XtAddCallback (entry, XtNcallback, 
		     optMenuSelect, (XtPointer) options->f) ;
      ++options ;
    }
}

/************ end of file *************/
