/*  Last edited: Mar  3 18:22 1992 (mieg) */

#include "regular.h"
#include "array.h"
#include "key.h"
#include "graphsun_.h"
#include <suntool/alert.h>
#include <suntool/panel.h>
#include <suntool/scrollbar.h>

/*******************************/

void wcsShow(void)
{
  messout("Sorry the WCS program has not been ported under Sunview") ;
}
void wcsAnnotate(void)
{
  messout("Sorry the WCS program has not been ported under Sunview") ;
}
void wcsSearch(void)
{
  messout("Sorry the WCS program has not been ported under Sunview") ;
}

/*******************************/

extern Window gButtonWin ;

static void waitButtonUp (void)
{
  Event ev ;

  if (!gButtonWin)
    return ;
  notify_dispatch () ;
  if (window_get(gButtonWin, WIN_EVENT_STATE, MS_LEFT))
    while (TRUE)
    { window_read_event (gButtonWin,&ev) ;
      if (event_id(&ev) == MS_LEFT && event_is_up(&ev))
        break ;
    }
}

/******************************/

void graphOut (char *text)
{
  int k ;

  if (!gDev)
    printf ("Message: %s\n",text) ;
  else
    { waitButtonUp () ;
      k = alert_prompt (gDev?gDev->frame:0, (Event*) NULL,
                        ALERT_MESSAGE_STRINGS_ARRAY_PTR, uBrokenLines(text,40),
                        ALERT_BUTTON_YES, "Continue",
                        ALERT_BUTTON_NO, "Crash",
                        0) ;
      if (k == ALERT_NO)
        messcrash ("Forced Crash") ;
    }
}

/**********************/

BOOL graphQuery (char *text)
{
  int answer ;

  waitButtonUp () ;
  answer= alert_prompt (gDev?gDev->frame:0, (Event*) NULL,
                        ALERT_MESSAGE_STRINGS_ARRAY_PTR, uBrokenLines(text,40),
                        ALERT_BUTTON_YES, "Yes",
                        ALERT_BUTTON_NO, "No",
                        0) ;
  switch (answer)
    {
    case ALERT_YES : return TRUE ;
    case ALERT_NO : return FALSE ;
    default : messcrash ("Bizarre return %d in graphQuery",answer) ;
    }
 return FALSE ;      /* for compiler happiness */
}

/******************/

static Associator assm2g,assg2m ;

static caddr_t menuAction (Menu menu, Menu_item item)
{
  Graph_ g ;
  KEY k ;
  MenuRoutine proc ;

  if (!assFind (assm2g,menu,&g))
    messcrash ("Can't find graph for menu") ;
  graphActivate (g->id) ;

  k = (KEY) menu_get (item, MENU_VALUE) ;

  proc = (MenuRoutine) menu_get (menu, MENU_CLIENT_DATA) ;
  (*proc)(k) ;

  return (caddr_t) k ;
}

static caddr_t menuPullAction (Menu menu, Menu_item item)
{
  Graph_ g ;
  int i,k ;
  MENUOPT * opt;

  if (!assFind (assm2g,menu,&g))
    messcrash ("Can't find graph for menu") ;
  graphActivate (g->id) ;

  k = (int) menu_get (item, MENU_VALUE) ;
  opt = (MENUOPT *) menu_get (menu, MENU_CLIENT_DATA) ;

  for (i = k ; opt->f && i-- ; opt++) ;

  if (i == -1)
    opt->f() ;

  return (caddr_t) k ;
}

void graphMenu (MENUOPT *options)
{
  int i;
  Menu menu,frameMenu ;
  Window win ;

  if (!gDev || !(win = gDev->frame))
    messcrash ("devMenu called without valid base window") ;

  menu = menu_create (0) ;
  menu_set (menu, /* MENU_TITLE_ITEM, title, */
                  MENU_CLIENT_DATA, options,
                  MENU_ACTION_PROC, menuPullAction,
            0) ;
  for (i = 0 ; options[i].f ; ++i)
    menu_set (menu, MENU_STRING_ITEM, options[i].text, i,
              0) ;

  frameMenu = (Menu) window_get (win,WIN_MENU) ;
  menu_set (menu, MENU_PULLRIGHT_ITEM, "Frame", frameMenu, 0) ;
  window_set (win, WIN_MENU, menu, 0) ;

  if (!assm2g)
    { assm2g = assCreate () ;
      assg2m = assCreate () ;
    }
  assInsert (assm2g,menu,gActive) ;
  assInsert (assg2m,gActive,menu) ;     /* needed to remove assm2g entry! */
}

void graphFreeMenu (MenuRoutine proc, FREEOPT *options)
{
  int i, nopt = (int) options[0].key ;
  Menu menu,frameMenu ;
  Window win ;

  if (!gDev || !(win = gDev->frame))
    messcrash ("graphFreeMenu called without valid base window") ;

  menu = menu_create (0) ;
  menu_set (menu, MENU_TITLE_ITEM, options[0].text,
                  MENU_CLIENT_DATA, proc,
                  MENU_ACTION_PROC, menuAction,
            0) ;
  for (i = 1 ; i <= nopt ; ++i)
    menu_set (menu, MENU_STRING_ITEM, options[i].text, options[i].key,
              0) ;

  frameMenu = (Menu) window_get (win,WIN_MENU) ;
  menu_set (menu, MENU_PULLRIGHT_ITEM, "Frame", frameMenu, 0) ;
  window_set (win, WIN_MENU, menu, 0) ;

  if (!assm2g)
    { assm2g = assCreate () ;
      assg2m = assCreate () ;
    }
  assInsert (assm2g,menu,gActive) ;
  assInsert (assg2m,gActive,menu) ;     /* needed to remove assm2g entry! */
}

void devMenuDestroy (void)
{
  Menu m ;

  if (assFind (assg2m,gActive,&m))
    { assRemove (assm2g,m) ;
      assRemove (assg2m,gActive) ;
    }
}

/************* select () *********************************/

#include <sunwindow/notify.h>
#include <sys/time.h>
static struct itimerval itimer = { {30,0}, {30,0} } ;

static Notify_value timeout (Notify_client me, int which)
{ window_return (FALSE) ; return NOTIFY_DONE ; }

static void panelCancel (void)
{ window_return (FALSE) ;}

/********************************/

static int currpage ;
static FREEOPT *selopts ;
static int nopt ;
static Panel panel ;

static Panel_item choice, upButton, downButton ;
#define ncols 3
#define nrows 20
static int pagesize = ncols*nrows ;

static void selectChoice (Panel_item item, int value, Event *event)
{
  static int last = -1 ;

  value += currpage*pagesize ;

  if (value == last)
    { last = -1 ;
      window_return (value+1) ;
    }
  else
    last = value ;
}

static void selectPage (int k)
{
  int i, offset ;

  if (k*pagesize > nopt)
    k = nopt/pagesize ;
  else if (k < 0)
    k = 0 ;
  if (choice && k == currpage)   /* choice = 0 first time round */
    return ;
  offset = k*pagesize ;

  if (choice)
    { panel_set (choice, PANEL_SHOW_ITEM, FALSE, 0) ;
      panel_destroy_item (choice) ;
    }
  choice = panel_create_item (panel, PANEL_CHOICE,
                              PANEL_FEEDBACK, PANEL_INVERTED,
                              PANEL_NOTIFY_PROC, selectChoice,
                              0) ;
  for (i = 0 ; i < pagesize && i+offset < nopt ; i++)
    panel_set (choice,
               PANEL_CHOICE_STRING, i, selopts[offset+i+1].text,
               PANEL_CHOICE_X, i, ATTR_COL(i/nrows),
               PANEL_CHOICE_Y, i, ATTR_ROW(3 + i%nrows),
               0) ;
  currpage = k ;
}

static void selectPageDown (void)
{ selectPage (currpage+1) ;}

static void selectPageUp (void)
{ selectPage (currpage-1) ;}

/*****************/

BOOL graphSelect (KEY *kpt, FREEOPT *options)
{
  Frame subframe = window_create (gDev?gDev->frame:0, FRAME,
                                  FRAME_NO_CONFIRM, TRUE,
                                  FRAME_SHOW_SHADOW, TRUE,
                                  0) ;
  int i, retval, w, opwidth = 0 ;
  char *trunc ;
static int charwidth ;
static int isFirst = TRUE ;
static Pixfont *bold ;

  if (isFirst)
    { isFirst = FALSE ;
      bold = pf_open ("/usr/lib/fonts/fixedwidthfonts/screen.b.12") ;
      charwidth = bold->pf_defaultsize.x ;
    }

  nopt = options[0].key ;
  if (!(trunc = (char *) calloc (nopt+1,1)))
    messcrash ("calloc failure in graphSelect - nopt was %d",nopt) ;
  for (i = 1 ; i <= nopt ; i++)
    if ((w = strlen (options[i].text)) > opwidth)
      if (w > 25)
        { opwidth = 25 ;
          trunc[i] = options[i].text[24] ;
          options[i].text[24] = 0 ;
        }
      else
        opwidth = w ;

  panel = window_create (subframe, PANEL,
                         WIN_COLUMN_WIDTH, charwidth*(opwidth+1),
                         WIN_COLUMNS, 3,
                         0) ;
  notify_set_itimer_func (panel, timeout, ITIMER_REAL, &itimer, 0) ;
  panel_create_item (panel, PANEL_MESSAGE,
                     PANEL_LABEL_STRING, options[0].text,
                     PANEL_LABEL_FONT, bold,
                     0) ;
  panel_create_item (panel, PANEL_MESSAGE,
                     PANEL_LABEL_STRING, messprintf ("%d options  ", nopt),
                     PANEL_ITEM_X, ATTR_COL(0),
                      PANEL_ITEM_Y, ATTR_ROW(1),
                     0) ;
  panel_create_item (panel, PANEL_BUTTON,
                     PANEL_NOTIFY_PROC, panelCancel,
                     PANEL_LABEL_IMAGE,
                       panel_button_image (panel,"Cancel",6,bold),
                     0) ;
  selopts = options ;
  choice = 0 ;            /* prevents destroying old choice item */
  selectPage (0) ;

  if (nopt > pagesize)
    { upButton = panel_create_item (panel, PANEL_BUTTON,
                        PANEL_NOTIFY_PROC, selectPageUp,
                        PANEL_LABEL_IMAGE,
                          panel_button_image (panel,"Page Up",8,bold),
                        PANEL_ITEM_X, ATTR_COL(0),
                        PANEL_ITEM_Y, ATTR_ROW(nrows+2),
                        0) ;
      downButton = panel_create_item (panel, PANEL_BUTTON,
                        PANEL_NOTIFY_PROC, selectPageDown,
                        PANEL_LABEL_IMAGE,
                          panel_button_image (panel,"Page Down",4,bold),
                        0) ;
    }

  window_fit_height(panel) ;
  window_fit(subframe) ;
/*
  window_set (subframe, WIN_SHOW, TRUE, 0) ;
  retval = 0 ;
*/
  notify_dispatch () ;
  retval = (int) window_loop (subframe) ;
  window_destroy (panel) ;
  window_destroy (subframe) ;

  for (i = 1 ; i <= nopt ; i++) if (trunc[i])
    options[i].text[24] = trunc[i] ;
  free (trunc) ;

  if (!retval)
    return FALSE ;
  else
    { *kpt = options[retval].key ;
      return TRUE ;
    }
}

/************* prompt () *********************************/

static Panel_item invalid ;

Panel_setting text_notify_proc(Panel_item item, Event *event)
{
  char *fmt = (char *) panel_get (item, PANEL_CLIENT_DATA) ;

  switch (event_action(event))
    {
    case ESCAPE_KEY :
      window_return (FALSE) ;
    case RETURN_KEY :
      freeforcecard ((char *) panel_get_value (item)) ;
      if (freecheck (fmt))
        window_return (TRUE) ;
      else
        { panel_set (invalid, PANEL_SHOW_ITEM, TRUE, 0) ;
          return PANEL_NONE ;
        }
    }
  return panel_text_notify(item,event) ;
}

BOOL graphPrompt (char *prompt, char *dfault, char *fmt)
{
  Frame subframe = window_create (gDev?gDev->frame:0, FRAME,
                                  FRAME_SHOW_SHADOW, TRUE,
                                  FRAME_NO_CONFIRM, TRUE,
                                  0) ;
  Panel panel = window_create (subframe, PANEL, 0) ;
  Panel_item text_item ;
  int max = freefmtlength (fmt) ;
  int plen = strlen (prompt) ;
  int row = 0 ;
  int retval ;
  char *cp ;
  Graph gsave = gActive ? gActive->id : 0 ;
  static int isFirst = TRUE ;
  static Pixfont *bold ;

  if (isFirst)
    { isFirst = FALSE ;

      bold = pf_open ("/usr/lib/fonts/fixedwidthfonts/screen.b.12") ;
    }

  if (plen + max > 70)
    { uLinesText (prompt,60) ;
      while (cp = uNextLine (prompt))
        panel_create_item (panel, PANEL_MESSAGE,
                           PANEL_LABEL_STRING, cp,
                           PANEL_ITEM_X, ATTR_COL(0),
                           PANEL_ITEM_Y, ATTR_ROW(row++),
                           0) ;
    }
  text_item = panel_create_item (panel, PANEL_TEXT,
                     PANEL_VALUE, dfault,
                     PANEL_VALUE_DISPLAY_LENGTH, max,
                     PANEL_VALUE_STORED_LENGTH, max,
                     PANEL_NOTIFY_PROC, text_notify_proc,
                     PANEL_CLIENT_DATA, fmt,
                     PANEL_ITEM_Y, ATTR_ROW(row++),
                     PANEL_BLINK_CARET, TRUE,
                     0) ;
  if (plen + max <= 70)
    panel_set (text_item, PANEL_LABEL_STRING, prompt, 0) ;

  invalid = panel_create_item (panel, PANEL_MESSAGE,
                               PANEL_SHOW_ITEM, FALSE,
                               PANEL_LABEL_STRING, "Invalid Response",
                               PANEL_ITEM_Y, ATTR_ROW(row++),
                               PANEL_LABEL_FONT, bold,
                               0) ;
  panel_create_item (panel, PANEL_BUTTON,
                     PANEL_NOTIFY_PROC, panelCancel,
                     PANEL_LABEL_IMAGE, panel_button_image
		     				(panel,"Cancel",6,bold),
                     0) ;
  window_fit(panel) ;
  window_fit(subframe) ;

  notify_dispatch () ;
  retval = (int) window_loop (subframe) ;
  window_destroy (panel) ;
  window_destroy (subframe) ;
  graphActivate (gsave) ;
  return retval ;
}

/* RMD  Jean added an OK button, but I think there are problems
   because the card is not set up correctly then.
   source for addition:

static void panelOK
{ window_return (TRUE) ;}

  panel_create_item (panel, PANEL_BUTTON,
                     PANEL_NOTIFY_PROC, panelOK,
                     PANEL_LABEL_IMAGE, panel_button_image
		     				(panel,"OK",6,bold),
                     0) ;
*/


/************* code for blocking/unblocking **************/

static Graph_ blockGraph ;
BOOL isBlockedFirst = FALSE ;

int graphBlock (void)
{
  int result ;

  if (blockGraph && !graphExists(blockGraph))
    blockGraph = 0 ;

  if (!gDev || blockGraph)
    return 0 ;

  blockGraph = gActive ;

  window_set (gDev->frame, WIN_SHOW, FALSE, 0) ;
  isBlockedFirst = TRUE ;
  result = (int) window_loop (gDev->frame) ;
  window_set (gDev->frame, WIN_SHOW, TRUE, 0) ;

  return result ;
}

void graphUnBlock (int retval)
{
  if (blockGraph != gActive)
    messcrash ("graphUnblock called on the wrong graph") ;

  blockGraph = 0 ;

  window_return (retval) ;
}

/***********************************************************/
/***********************************************************/
