/*  Last edited: Jan 22 17:13 1992 (mieg) */

#include "regular.h"
#include "array.h"
#include "graph_.h"

static float colours[] =           /* must correspond to enum Colours */
  { 1.0, 0.0, 0.7,0.4,  
    0.4,0.4,0.4, 
    0.7,0.7,0.7, 
    0.85,0.85,0.850, 
    0.2, 0.2, 0.2 } ;

static FILE *fil ;
static float psize,psize2 ;

/*****************************************/

static void fontSet (float height)
{
  if (height == 1.0 || height == 0.0)
    fprintf (fil, "defaultFont setfont\n") ;
  else
    fprintf (fil, "%.4f scaledFont setfont\n", height) ;
}

/***********************************************/

static void fillBox (Box box)   /* does background */

{ 
  if (box->x1 > 999999.0)
    return ;                    /* box still empty */

  fprintf (fil, "%.2f setgray\n", colours[box->bcol]) ;
  fprintf (fil, "%.4f %.4f %.4f %.4f rectangle fill\n",
	   box->x1,box->y1,box->x2,box->y2) ;
  fprintf (fil, "%.2f setgray\n",colours[box->fcol]) ;
}

/***********************************************/

static void drawBox (Box box)
{
  int    i1 ;
  float  x1,x2,y1,y2 ;
  int    action ;
  Box	 nextbox ;
  float  colour ;

  colour = colours[box->fcol] ;
  stackCursor (gStk,box->mark) ;

  while (!stackAtEnd (gStk))
    switch (action = stackNext (gStk, int))
      {
      case BOX_END :
        return ;                        /* exit point */
      case BOX_START :
        i1 = stackNext (gStk, int) ;
	nextbox = gBoxGet (i1) ;
	if (nextbox->bcol != box->bcol)
	  fillBox (nextbox) ;
        drawBox (nextbox) ;                  /* recursion */
	fprintf (fil, "%.2f setgray\n",colour) ;
        break ;
      case COLOR :
        i1 = stackNext (gStk,int) ;
	colour = colours[i1] ;
	fprintf (fil, "%.2f setgray\n", colour) ;
        break ;
      case LINE_WIDTH :
        fprintf (fil,"%f setlinewidth\n",stackNext (gStk,float)) ;
        break ;
      case TEXT_HEIGHT :
        fontSet (stackNext (gStk,float)) ;
        break ;
      case POINT_SIZE :
        psize = stackNext (gStk,float) ; psize2 = psize/2 ;
        break ;
      case LINE : case RECTANGLE : case FILL_RECTANGLE :
        x1 = stackNext (gStk,float) ;
        y1 = stackNext (gStk,float) ;
        x2 = stackNext (gStk,float) ;
        y2 = stackNext (gStk,float) ;
        switch (action)
          {
          case LINE :
            fprintf (fil,
                "newpath  %.4f %.4f moveto  %.4f %.4f lineto  stroke\n",
                     x1,y1,x2,y2) ;
            break ;
          case RECTANGLE :
            fprintf (fil,"%.4f %.4f %.4f %.4f rectangle stroke\n",
                     x1,y1,x2,y2) ;
            break ;
          case FILL_RECTANGLE :
            fprintf (fil,"%.4f %.4f %.4f %.4f rectangle fill\n",
                     x1,y1,x2,y2) ;
            break ;
          }
	break ;
      case CIRCLE : case POINT : case TEXT : case TEXT_PTR :
        x1 = stackNext (gStk,float) ;
        y1 = stackNext (gStk,float) ;
        switch (action)

          {
          case CIRCLE :
            fprintf (fil,"%.4f %.4f %.4f 0 360 arc stroke\n",
                     x1,y1,stackNext (gStk,float)) ;
            break ;
          case POINT :
            fprintf (fil,"%.4f %.4f %.4f %.4f rectangle fill\n",
                     x1-psize2,y1-psize2,x1+psize2,y1+psize2) ;
            break ;
          case TEXT :
         
	    fprintf (fil,"%.4f %.4f moveto (",
		     x1,y1) ;
            { char *cp = stackNextText(gStk) ;
	      if (cp) while(*cp)
		{ switch (*cp)
		    { case '(': 
		      case ')': 
		      case '\\':
			fputc('\\',fil) ;
			break ;
		      }
		  fputc(*cp++,fil) ;
		}
	    }
            fprintf (fil,") show\n") ;
		     
            break ;
	  case TEXT_PTR :
	    fprintf (fil,"%.4f %.4f moveto (",
		     x1,y1) ;
            { char *cp = stackNext(gStk,char*) ;
	      while(*cp)
		{ switch (*cp)
		    { case '(': 
		      case ')': 
		      case '\\':
			fputc('\\',fil) ;
			break ;
		      }
		  fputc(*cp++,fil) ;
		}
	    }
            fprintf (fil,") show\n") ;
	    break ;
          }
	break ;
      default :
	messout ("Invalid action %d received in drawPSBox",action) ;
	break ;
      }
}

static void graphPSBox (int k, int fcol, int bcol)
{
  Box box = gBoxGet (k) ;

  fontSet (uToYrel(box->textheight)) ;
  psize = gActive->pointsize ;
  psize2 = psize/2 ;

  if (fcol >= 0)
    box->fcol = fcol ;
  if (bcol >= 0)
    box->bcol = bcol ;

  fillBox (box) ;	/* does background */
  drawBox (box) ;
}

void graphPrint(void)  /* JTM, to simplify the application codes */
{
  graphPS(graphHelp(0)) ;
}

void graphPS (char *namebase)
{
  static int ident = 0 ;
  char  name[128], *print_command ;
#define pageWidth 558.0
#define pageHeight 756.0
  float aspect = gActive->aspect ;
  float wid12pt = aspect * pageWidth / 12. ;

  float wid10pt = aspect * pageWidth / 10. ;
  float xfac,yfac,fac ;
  int i,pages ;
  int isRotate ;

  if (!namebase || !*namebase)
    namebase = "acedbxx" ; 
    /* %.6s means  at most six char printed */
  strcpy (name, messprintf ("%s/PS/%.6s.%d",
			    filsetdir(0), namebase, ++ident)) ;
  if (!(fil = fopen (name,"w")))
    { messout ("Couldn't open postscript file %s", name) ;
      return ;
    }

  fprintf (fil,"%%!PS-Adobe-1.0\n\n") ;
  fprintf (fil,"/rectangle    %% x1 y1 x2 y2 ==> _\n") ;
  fprintf (fil," {/y2 exch def  /x2 exch def /y1 exch def /x1 exch def\n") ;
  fprintf (fil,"  newpath\n") ;
  fprintf (fil,"    x1 y1 moveto x2 y1 lineto x2 y2 lineto x1 y2 lineto\n") ;
  fprintf (fil,"  closepath\n") ;
  fprintf (fil," } def\n\n") ;
  fprintf (fil,"/defaultFont	%% --\n") ;
  fprintf (fil,"  /Helvetica findfont 0 -0.7 matrix translate makefont\n") ;
  fprintf (fil,"  %f -1 matrix scale makefont def\n",aspect) ;
  fprintf (fil,"/scaledFont	%% scale ==> _\n") ;
  fprintf (fil,"  { defaultFont exch scalefont } def\n\n") ;

  switch (gActive->type)
    { 
    case TEXT_SCROLL : 
      isRotate = FALSE ;
      if (gActive->uw < wid12pt)
	fac = 12.0 ;
      else if (gActive->uw < wid10pt)
	fac = 10.0 ;
      else
	fac = aspect * pageWidth / gActive->uw ;
      pages = 1 + gActive->uh*fac / pageHeight ;
      break ;
    case MAP_SCROLL :
      isRotate = TRUE ;
      fac = 0.6 * pageWidth / gActive->uh ;
      pages = 1 + gActive->uw * fac / (aspect * pageHeight) ;
      break ;
    case PLAIN : case TEXT_FIT :
      if (gActive->uw <= gActive->uh*aspect)
	{ isRotate = FALSE ;
	  xfac = aspect * pageWidth / gActive->uw ;
	  yfac = pageHeight / gActive->uh ;
	  fac = (xfac < yfac) ? xfac : yfac ;
	}
      else
	{ isRotate = TRUE ;
	  xfac = aspect * pageHeight / gActive->uw ;
	  yfac = pageWidth / gActive->uh ;
	  fac = (xfac < yfac) ? xfac : yfac ;
	}
      pages = 1 ;
      break ;
    default:
      messout ("Unknown graph type in graphPS") ;
      fclose (fil) ;
      return ;
    }
  if (isRotate)
    fprintf (fil,"gsave\n%f %f translate -90 rotate  ",pageWidth,pageHeight) ;
  else
    fprintf (fil,"gsave\n18 %f translate  ",pageHeight) ;
  fprintf (fil,"%.4f %.4f scale  ",fac/aspect,-fac) ;
  fprintf (fil,"%.4f %.4f translate\n",-gActive->ux,-gActive->uy) ;
  fprintf (fil,"%.6f setlinewidth\n",1.0/fac) ;	       /* default 1/72 inch */

  for (i = 0 ; i < pages ; i++)
    { graphPSBox (0,-1,-1) ;
      fprintf (fil,"\ngsave showpage grestore\n\n") ;
      if (isRotate)
	fprintf (fil,"%f 0 translate\n",-aspect*pageHeight/fac) ;
      else
	fprintf (fil,"0 %f translate\n",-pageHeight/fac) ;
    }

  fprintf (fil,"grestore\n") ;
  fprintf (fil,"%%%%trailer\n") ;
  fclose (fil) ;

  if (!(print_command = getenv ("ACEDB_LPR")))
    print_command = "lpr" ;
  if (*print_command)
    { if (!system (messprintf ("%s %s", print_command ,name)))
	messout ("Written %d pages to %s and printed them using %s", 
		 pages, name, print_command ) ;
      else
	messout ("Written %d pages to %s \n  lpr print command (%s) failed",
		 pages,name, print_command) ;
    }
  else
    messout ("Written %d pages to %s", pages, name) ;
 }

/****************************/

void graphPScommand (char *command)	/* not much use here - put on stack */

 {if (fil)
    fprintf (fil,"%s\n",command) ;
 }
















