/*  Last edited: Jan  8 01:54 1992 (mieg) */


      /***************************************************************/
      /**  File dialog.c :                                          **/
      /**  Dialog  of the ACeDB program.                            **/
      /***************************************************************/
      /***************************************************************/
      /*                                                             */
      /*  Two   routines are public :                                */
      /*                                                             */
      /*  dialogOut, dialogQuery                                     */
      /*                                                             */
      /*         R.Durbin & J.Thierry-Mieg.                          */
      /*                    last modified 25/3/91 by JTM.            */
      /*                                                             */
      /***************************************************************/

/* This used to be the corresponding help page
#################################################################

**Dialog

  Messages and questions issued by the system are presented in
  a special window. They scroll automatically but a complete 
  journal is kept in file acedb.log in the directory you started
  from. Rename this file if you wish to keep it. If you have
  write access, a second copy of the error messages is appended
  in the permanent file $ACEDB/logbook.wrm
	
  	If the system needs an answer, the window turns RED and
  you have to reply before you can do anything else.
	When the dialog window is full, you must click it to
  allow it to scroll
Menu:

Clear: 
	Clears the dialog window.
Crash:
	Allows to stop the program whenever you want;
#################################################################
*/

#include "acedb.h"
#include "graph.h"
#include "display.h"

/******************************************************************/

static Graph dialogGraph = 0;
static void dialogDestroy(void);
static void dialogClear(void);
static void dialogCrash(void);
static void dialogPick(int k) ;
static int box = 0, line = 0 ; /* Current line and box */
static int boxQ, boxY, boxN ;  /* Question, Yes, No boxes */
static FILE* f = 0 ;
static BlockFunc answer ;

static MENUOPT dialogMenu[]={
        dialogDestroy,"Quit",
        help,"Help",
        dialogClear,"Clear",
        dialogCrash,"Crash",
        0,0 };

static int dx, dy ;

/**********************************************************/

static void dialogSize(void)
{
  graphFitBounds(&dx, &dy) ;
  graphRedraw() ;
}

/**********************************************************/

static void dialogPop(void)
{
  if (!f)
    f = fopen("./acedb.log","w") ;
  if (dialogGraph == graphExists(dialogGraph))
    { graphActivate(dialogGraph);
      graphPop() ;
    }
  else
    { dialogGraph =  graphCreate (TEXT_FIT,"Messages",
				  0.0001,.75,0.65,0.22) ;
      graphRegister (PICK,(GraphFunc)dialogPick) ;
      graphRegister(RESIZE,(GraphFunc)dialogSize) ;
      graphMenu (dialogMenu) ;
      graphColor (BLACK) ;
      line = 0 ; box = 0 ;
      graphHelp ("Dialog") ; 
      dialogSize() ;
    }
}
 
/******************************************/

static void dialogClear(void)
{
  graphClear () ;
  line = 0 ;
  box = 0 ;
  graphRedraw () ;
}

/******************************************/

static void dialogCrash(void)
{
  messcrash("User-required Forced Crash") ;
}

/******************************************/

static void dialogDestroy(void)
{
  dialogGraph = 0 ;
  graphDestroy() ;
}

/******************************************/

static void dialogPick(int k)
{
  if(k == boxY)
    { graphBoxDraw( boxQ,BLACK, WHITE) ;
      graphBoxDraw( boxY,BLACK, WHITE) ;
      graphBoxDraw( boxN,WHITE, WHITE) ;
      if(f)
	fprintf(f,"Yes\n") ;
      answer(TRUE) ;
    }
  if(k == boxN)
    { graphBoxDraw( boxQ,BLACK, WHITE) ;
      graphBoxDraw( boxN,BLACK, WHITE) ;
      graphBoxDraw( boxY,WHITE, WHITE) ;
      if(f)
	fprintf(f,"No\n") ;
      answer(FALSE) ;
    }
}

/**********************************************************/
/**************** public routines *************************/


void dialogOut(char *text)
{ char ** cpp ;
  Graph g = graphActive() ;

  dialogPop() ;
  if(f)
    fprintf(f,"%s\n",text) ;
  if(line + strlen(text)/ dx > dy)
    dialogClear() ;

  if(box)
    graphBoxDraw( box,BLACK, WHITE) ;
  box = graphBoxStart() ;
  cpp = uBrokenLines (text, dx) ;
  while(*cpp)
    graphText(*cpp++, 1, line++) ;
  graphBoxEnd() ;
  graphBoxDraw(box,YELLOW,BLUE) ;
  graphActivate(g) ;
}
 
/*********************************************/

void dialogQuery(char *text, BlockFunc func)
{ 
  answer = func ;
  dialogOut(text) ;
  boxQ = box ;
  graphBoxDraw(boxQ,RED,WHITE) ;
  boxY = graphBoxStart() ;
  graphText("  YES  ", 12, line) ;
  graphBoxEnd() ;
  graphBoxDraw(boxY,WHITE,GREEN) ;
  boxN = graphBoxStart() ;
  graphText("  NO  ", 18, line++) ;
  graphBoxEnd() ;
  graphBoxDraw(boxN,WHITE,RED) ;
}
 
/*********************************************/
/*********************************************/

