/*  File: newkey.c
 *  Author: Jean Thierry-Mieg (mieg@mrc-lmba.cam.ac.uk)
 *  Copyright (C) J Thierry-Mieg and R Durbin, 1991
 *-------------------------------------------------------------------
 * This file is part of the ACEDB genome database package, written by
 * 	Richard Durbin (MRC LMB, UK) rd@mrc-lmba.cam.ac.uk, and
 *	Jean Thierry-Mieg (CRBM du CNRS, France) mieg@frmop11.bitnet
 *
 * Description: user interface to edit operations at level of whole objects:
 	new object, alias/fuse (separate these ?), rename, delete.
 * Exported functions:
       addKeys() .
 * HISTORY:
 * Last edited: Apr  2 18:34 1992 (mieg)
 * * Feb  8 00:04 1992 (rd): added rename, delete and changed alias
 * * Jan 13 02:31 1992 (mieg): alias.
 * * Dec  2 19:02 1991 (mieg): graphClassEntry
 * Created: Mon Dec  2 19:01:40 1991 (mieg)
 *-------------------------------------------------------------------
 */


#include "acedb.h"
#include "graph.h"
#include "lex.h"
#include "display.h"
#include "pick.h"
#include "disptype.wrm"
#include "session.h"
#include "bs.h"
#include "systags.wrm"
#include "a.h"

static Graph addGraph = 0 ;
static int currClassBox = 0 ;
static int currClass = 0 , nameBox = 0 ;
static char nameText[128] ;
static Array box2class ;

/******************* action functions ******************/

static void displayKey (void)
{
  KEY key ;

  if (!currClass)
    { messout ("You must pick a class first") ; return ; }
  if (!*nameText)
    { messout ("The name can not be empty") ; return ; }

  if (!lexword2key (nameText, &key, currClass))
    messout ("Object doesn't exist - use menu entry Create"
	     "to make it.") ;

  display (key, 0, TREE) ;
}

static void makeNewKey (void)
{
  KEY key ;

  if (!isWriteAccess ())	/* may be lost after graph was created */
    { messout ("Sorry, you do not have Write Access") ; return ; }
  if (!currClass)
    { messout ("You must pick a class first") ; return ; }
  if (!*nameText)
    { messout ("The name can not be empty") ; return ; }

  if (!lexaddkey (nameText, &key, currClass))
    messout ("Object %s already exists.", name(key)) ;

  display (key, 0, TREE) ;
}

static void makeAlias (void)
{
  KEY key ;
  char *aliasName ;
  int class = currClass ; 
 
  if (!isWriteAccess())
    { messout("Sorry, you do not have Write Access"); return ; }
  if (!currClass)
    { messout ("You must pick a class first") ; return ; }
  if (!lexword2key (nameText, &key, class)) 
    { messout ("Old name %s is unkown", nameText) ; return ; }
  if (!graphPrompt ("Alias will result in both the old and new names being "
		    "recognized, but the name you type now will be the "
		    "one the database writes out (canonical name).  If it is "
		    "the name of an existing object then the two will be fused.  "
		    "Cancel and start again if you wish the name you "
		    "originally typed to be the canonical name."
		    "\n\nGive alias name:",
		    nameText, "t"))
    return ;

  aliasName = freeword () ;
  if (!*aliasName)
    { messout ("The name can not be empty") ; return ; }
  
  if (lexAlias (key, aliasName, TRUE, TRUE))
    display (key, 0, TREE) ;
  else
    messout ("Alias failed, sorry") ;
}


static void changeName (void)
{
  KEY key ;
  char *newName ;
  int class = currClass ; 
 
  if (!isWriteAccess())
    { messout("Sorry, you do not have Write Access"); return ; }
  if (!currClass)
    { messout ("You must pick a class first") ; return ; }
  if (!lexword2key (nameText, &key, class)) 
    { messout ("Old name %s is unkown", nameText) ; return ; }
  if (!graphPrompt ("Rename is a hard rename function.  Unless you are just "
		    "changing case, the old name will no "
		    "longer apply to this or any other current object (you can "
		    "reuse it for a new object).  If the new name belongs to "
		    "an existing object the two objects will be fused.  "
		    "For both names to apply, cancel "
		    "now and use the Alias menu entry.  "
		    "\n\nGive new name:",
		    nameText, "t"))
    return ;

  newName = freeword () ;
  if (!*newName)
    { messout ("The name cannot be empty") ; return ; }
  if (!lexAlias (key, newName, TRUE, FALSE))
    messout ("Rename failed, sorry") ;
}

static void deleteObject (void)
{
  KEY key ;
  int class = currClass ; 
  OBJ obj ;
 
  if (!isWriteAccess())
    { messout("Sorry, you do not have Write Access"); return ; }
  if (!currClass)
    { messout ("You must pick a class first") ; return ; }
  if (!lexword2key (nameText, &key, class)) 
    { messout ("Object %s is unkown", nameText) ; return ; }
  if (!graphQuery (messprintf ("Delete all data associated %s ?",
			       name(key))))
    return ;

  switch (pickType (key))
    {
    case 'A':
      arrayKill (key) ;		/* neat, heh! */
      break ;
    case 'B':
      if (obj = bsUpdate (key))
	{ while (bsGetKeyTags (obj, _bsRight, 0))
	    bsRemove (obj) ;
  /* can't delete the root so must do bit by bit - annoying */
	  bsSave (obj) ;
	}
      else
	messout ("Object %s is locked", name (key)) ;
      break ;
    }
}

/****************************************/

static void pick (int box, double x)
{ 
  if (!box)
    return ;

  if (box < arrayMax(box2class))
    {
      if (currClassBox)
	graphBoxDraw (currClassBox, BLACK, WHITE) ;

      currClassBox = box ;
      graphBoxDraw (currClassBox, WHITE, BLACK) ;
      currClass = arr(box2class,currClassBox,int) ;
    }
}

static void destroy (void)
{
  addGraph = 0 ;
  currClassBox = 0 ;
}

static MENUOPT newMenu[] =
  { graphDestroy, "Quit",
    help, "Help",
    makeNewKey, "Create",
/*    makeAlias, "Alias/Fuse", */
    changeName, "Rename/Fuse",
    deleteObject, "Delete",
    0, 0
  } ;

/*******************************************************/

extern int ksetClassComplete(char *text, int len, int class) ;
static void classComplete(char *cp, int len)
{
  static previousClass = -1 ;
  
  if (!currClass)
    return ;
  if (previousClass != currClass)
    ksetClassComplete(0,0,0) ;
  else  
    ksetClassComplete(cp, len , currClass) ;
  previousClass = currClass ;
}

/******************* main function ****************/

void addKeys (void)
{
  int i, x, y, ncol = 3 ;
  int sep = 0 ;
  int nclasses = pickVocList[0].key ;

  if(!isWriteAccess())
    { messout("Sorry, you do not have Write Access");
      return ;
    }

  if (graphActivate (addGraph))
    { graphPop () ;
      return ;
    }
  
  addGraph = displayCreate(DtAlias) ;
  graphRegister (DESTROY, destroy) ;
  graphRegister (PICK, (GraphFunc)pick) ;
  graphMenu (newMenu) ;
  
  if (box2class)
    arrayMax(box2class) = 0 ;
  else
    box2class = arrayCreate (16, int) ;

  for (i = 1 ; i <= nclasses ; ++i)
    if (strlen(pickVocList[i].text) > sep)
      sep = strlen (pickVocList[i].text) ;
  sep += 2 ;
  
  graphText ("Classes:", 0.5, 2.0) ;
  x = 0 ; y = 3.5 ;
  for (i = 1 ; i < nclasses ; ++i) 
    if (pickType(KEYMAKE(pickVocList[i].key,0)) == 'B')
      { array (box2class,graphBoxStart(),int) = pickVocList[i].key ;
	graphText (pickVocList[i].text, 2.0 + x*sep, y) ;
	graphBoxEnd () ;
	if (!(++x%ncol))
	  { x = 0 ; ++y ;
	  }
      }

  graphText ("Name: ", 0.5, 0.5) ;
  *nameText = 0 ;
  nameBox = graphCompletionEntry (classComplete, 
				  nameText, 127, 6.5, 0.5, (GraphFunc) displayKey) ;

  currClass = currClassBox = 0 ;
  graphRedraw () ;
}

/*******************************************************/
/*******************************************************/
