/*  Last edited: Mar 27 20:10 1992 (mieg) */
/***************************************************************/
/***************************************************************/
/**  File menu.c :                                            **/
/***************************************************************/
/*                                                             */
/*          menuInit(), menuSuppress, MenuRestore              */
/*                                                             */
/*         R.Durbin & J.Thierry-Mieg.                          */
/*                    last modified  5/1/91    by JTM.         */
/*                                                             */
/***************************************************************/
 
#include "acedb.h"
#include "array.h"
#include "graph.h"
#include "menu.h"

typedef struct holder
  { MENUOPT *full ;
    Graph   graph ;
  } *Holder ;

static Associator assHold = 0 ;

/**************************************************/

 /* suppresses everything from title to next blank line */
void menuSuppress (char *title, MENUOPT* local)
{
  MENUOPT *x, *y ;
  Holder hold ;
  Graph curr = graphActive () ;

  if (!assFind (assHold, local, &hold))
    return ;

  for (x = local ; x->text ; ++x)
    if (!strcmp (x->text, title))
      break ;

  y = x ;
  while (x->text && *x->text) 
    x++ ;			/* skip until blank line */
  if (x->text)			/* skip blank line */
    x++ ;
  while (x->text)
    *y++ = *x++ ;
  y->f = 0 ; y->text = 0 ;

  if (!graphActivate (hold->graph))
    return ;
  graphMenu (local) ;
  graphActivate (curr) ;
}

void menuRestore (char *title, MENUOPT* local)
{
  MENUOPT *x, *y ;
  Holder hold ;
  Graph curr = graphActive () ;

  if (!assFind (assHold, local, &hold))
    return ;

  for (x = local ; x->text ; ++x)
    if (!strcmp (x->text, title))
      return ;

  for (y = hold->full ; y->text ; ++y)
    if (!strcmp (y->text, title))
      break ;

  while (y->text && *y->text)
    *x++ = *y++ ;

  x->f = 0 ; x->text = 0 ;

  if (!graphActivate (hold->graph))
    return ;
  graphMenu (local) ;
  graphActivate (curr) ;
}

void menuInit (MENUOPT **local, MENUOPT *full, Graph graph)
{
  int size = sizeof(MENUOPT) ;
  MENUOPT *x ;
  Holder hold = (Holder) messalloc (sizeof (struct holder)) ;
  
  if (*local)
    return ;

  for (x = full ; x->f ; ++x)
    size += sizeof (MENUOPT) ;
  *local = (MENUOPT*) messalloc(size) ;
  memcpy (*local, full, size) ;
  hold->full = full ;
  hold->graph = graph ;
  if (!assHold)
    assHold = assCreate () ;
  assInsert (assHold, *local, hold) ;
}

void menuSpacer (void) { return ; }
