/*  File: help.c
 *  Author: Jean Thierry-Mieg (mieg@mrc-lmba.cam.ac.uk)
 *  Copyright (C) J Thierry-Mieg and R Durbin, 1992
 *-------------------------------------------------------------------
 * This file is part of the ACEDB genome database package, written by
 * 	Richard Durbin (MRC LMB, UK) rd@mrc-lmba.cam.ac.uk, and
 *	Jean Thierry-Mieg (CRBM du CNRS, France) mieg@frmop11.bitnet
 *
 * Description:
 * Exported functions:
 * HISTORY:
 * Last edited: Apr  2 18:34 1992 (mieg)
 * Created: Thu Feb 20 14:49:50 1992 (mieg)
 *-------------------------------------------------------------------
 */

      /***************************************************************/
      /***************************************************************/
      /**  File help.c :                                            **/
      /**  Provides an online help for the ACeDB program.           **/
      /***************************************************************/
      /***************************************************************/
      /*                                                             */
      /*  2   routines are public :                                  */
      /*     help(void), helpOn(char* entry).                        */
      /*                                                             */
      /*  This program reads the ascii file $ACEDB/wmake/help.wrm    */
      /*  Parses it for section recognized by their titleline        */
      /*  **section_title                                            */
      /*  and graphs out the corresponding section.                  */
      /*                                                             */
      /*         R.Durbin & J.Thierry-Mieg.                          */
      /*                    last modified  15/1/91  by JTM.          */
      /*                                                             */
      /***************************************************************/

#include "../wnongraphic/helpnongraphic.c"
#include "graph.h"
#include "display.h"

static Array sortedEntries = 0 ;
static int currentEntry = 0 ;
static Graph helpGraph = 0 ;
static void helpDraw(int n) ;
#define MAXLINE 90

/********************************************************************/

static int alphabetic (void *a, void *b)
{
  return strcasecmp((char *)a, (char *)b) ;
}

/**********************************************************************/

static void helpPageUp(void)
{
  helpDraw(-1) ;
}

/**********************************************************************/

static void helpPageDown(void)
{
  helpDraw(-2) ;
}

/**********************************************************************/

static void helpPop(void)
{ int n = arrayMax(helpRing) ;
  
  if(n <= 1)
    return ;
  ring = (n + ring -1) % n ;
  helpDraw (arr(helpRing,ring,int)) ;
}

/**********************************************************************/

static void helpPush(void)
{ ring  = arrayMax(helpRing) ;
  array(helpRing,ring,int) = currentEntry ;
}

/**********************************************************************/
static Array box2index = 0 ;
static void helpPick(int n)
{ int i = arrayMax(box2index) ;
  while(i--)
    if(array(box2index,i,int) == n)
      break ;
  if(i == -1)
    messout("Confusion in help Pick, sorry") ;
  else
    helpOn(array(sortedEntries,i,char *)) ;
}

/**********************************************************************/

static void helpIndex(void)
{ int n = arrayMax(entries) , i ;

  if(!n)
    return ;
  graphClear() ;
  graphPop() ;
  graphText("Choose an Item", 2,2) ;
  if(!sortedEntries)
    {
      sortedEntries = arrayCreate(arrayMax(entries),char *) ;
      box2index = arrayCreate(n,int) ;
      for(i=0 ; i<n ; i++)
	array(sortedEntries,i + 1,char *) = stackText(helpText, arr(entries,i,int)) ;
      
      arraySort(sortedEntries, alphabetic) ;
    }
  for(i=0 ; i<n ; i++)
    { array(box2index,i,int) = graphBoxStart() ;
      graphText(array(sortedEntries,i,char *), 3, i + 4) ;
      graphBoxEnd() ;
    }
  graphRegister(PICK,(GraphFunc) helpPick) ;
  graphTextBounds(i+5,80) ;
  graphRedraw() ;
}

/**********************************************************************/

static void helpDestroy(void)
{
  stackDestroy(helpText) ;  /* implicitly resets helpText = 0 */
  arrayDestroy(entries) ;
  arrayDestroy(sortedEntries) ;
  arrayDestroy(helpRing) ;
  arrayDestroy(box2index) ;
  helpGraph = 0 ;
}

/**********************************************************************/
/**********************************************************************/

static MENUOPT helpMenu[] =
  { graphDestroy, "Quit",
    help, "Help",
    graphPrint, "Print" ,
    helpIndex,   "Menu",
    helpPageUp, "Page Up",
    helpPageDown, "Page Down",
    helpPush, "Push",
    helpPop,  "Pop",
    0, 0
  } ;

/**********************************************************************/

static void helpDraw(int n)
{
  register char *cp ;
  int line = 3 ;
  
  if(n == -1)     /* page up */
    n = currentEntry - 1 ;
  if(n == -2)     /* page down */
    n = currentEntry + 1 ;
  graphClear() ;
  graphPop() ;
  graphButtons(helpMenu,4.5,1.5,75) ;
  if(n >= arrayMax(entries) )
    graphText("End of the help file", 3, 3) ;
  else if (n<0)
    graphText("Top of the help file", 3, 3) ;
  else
    {
      stackCursor(helpText, array(entries,n,int)) ;
      currentEntry = n ;
      cp = stackNextText(helpText) ;
      graphRetitle(messprintf("Help on %s", cp ? cp : "" )) ;
       
      graphText(cp,1,line++) ;
       while(cp = stackNextText(helpText))
	 {
	   if( *cp == '*' && *(cp+1) == '*')
	     break ;
	   graphText(cp,1,line++) ;
	 }
     }
  graphTextBounds(80,++line) ;
  graphRedraw() ;
}

static BOOL helpGraphInit (void)
{
  if (!helpInit ())
    return FALSE ;
  helpGraph = displayCreate(DtHelp) ;
  graphRegister(DESTROY, helpDestroy) ;
  graphMenu(helpMenu) ;
  graphTextBounds(80,MAXLINE) ;
  return TRUE ;
}

/**********************************************************************/
/********************************Public Routines***********************/

void helpOn(char *text)
{ Graph oldGraph = graphActive() ;
  if(graphActivate(helpGraph))
      graphPop() ;
  else
    if(!helpGraphInit()) 
      return ;
  
  if(!text || !*text)
    text = "acedb" ;
  
  helpDraw(locateHelp(text)) ;
  graphActivate(oldGraph) ;
}

/**********************************************************************/
/* This function has the correct prototype for a MENUOPT */
void help(void)
{
  helpOn(graphHelp(0)) ;
}

/**********************************************************************/
/**********************************************************************/
