/*  Last edited: Apr  2 18:34 1992 (mieg) */

      /***************************************************************/
      /***************************************************************/
      /**  File chrono.c :                                          **/
      /**  General Time statistics                                  **/
      /***************************************************************/
      /***************************************************************/
      /*                                                             */
      /*  3 routines are public :                                    */
      /*     chrono, chronoReturn and  chronoShow                    */
      /*                                                             */
      /*     chrono("procedure") switches the timing to "procedure"  */
      /*     chronoReturn ends it.                                   */
      /*     chrono.h defines chrono = chronoSwitch or void          */
      /*              and     chronoReturn = chronoDoReturn or void  */
      /*     If you compile without flag CHRONO all calls to the     */
      /*     chrono package just disappear out of the code.          */
      /*   This package is self contained since any function         */
      /*   called from here cannot be timed                          */
      /*                                                             */
      /*         R.Durbin & J.Thierry-Mieg.                          */
      /*                    last modified   3/8/90  by JTM.          */
      /*                                                             */
      /***************************************************************/

#include "acedb.h"  

#ifdef CHRONO

#include <sys/time.h>
#include <sys/resource.h>
#include "chrono.h"
#include "graph.h"   /* for chronoShow */ 
#include "array.h"

extern void getrusage (int, struct rusage *p) ;

/* subroutines to return info about system and real time */

#define MAXPROC 300
#define HALFMAXCHRONOSTACK 6
#define MAXCHRONOSTACK 2*HALFMAXCHRONOSTACK

typedef struct rusage *Timer_ ;
static struct rusage previous[1], current[1] ;
static char *proc[MAXPROC];
static double tSys[MAXPROC], tUser[MAXPROC] ;
static int chMax = 0, call[MAXPROC];
static int  chronoIsRunning = FALSE ;
static int chronoStackIndex = 0;
static int chronoStack[MAXCHRONOSTACK] ;

static void
  chronoStart(void),
  chronoStop(void),
  chronoShow(void) ;


static MENUOPT chronoMenu[]={
        graphDestroy,"Quit",
        help,"Help",
	graphPrint,"Print",
        chronoStart,"Start",
        chronoStop,"Stop",
        chronoShow,"Show",
        0,0 };


/**********************************************/

static double MICRO = .000001 ;

static double convert (struct timeval *tval) /* conversion to seconds */
{
  return (double) (tval->tv_sec + MICRO*tval->tv_usec) ;
}

/*****************************************/
   /* This is a shifting stack with partial memory */
static void chronoPush(int i)
{
 chronoStack[chronoStackIndex++] = i ;
 if (chronoStackIndex == MAXCHRONOSTACK)
  {
   register int i ;
   for(i = 0; i< HALFMAXCHRONOSTACK; i++)
     chronoStack[i] = chronoStack[i+ HALFMAXCHRONOSTACK] ;
   chronoStackIndex = i ;
 }
}
/*****************************************/
static int chronoPop(void)
{
 if (chronoStackIndex)
   return chronoStack[--chronoStackIndex] ;
 else return -1;
}
/******************************************/

static void chronoGo(int i)
{

 tSys[i] +=  convert (&current->ru_stime) 
           - convert (&previous->ru_stime) ;
 tUser[i] += convert (&current->ru_utime) 
           - convert (&previous->ru_utime) ;
 
 call[0] ++ ;
 getrusage (RUSAGE_SELF,previous) ;

 tSys[0] += - convert (&current->ru_stime) 
            + convert (&previous->ru_stime) ;
 tUser[0] += - convert (&current->ru_utime) 
            +convert (&previous->ru_utime) ;
 
 }

/******************************************/

static void chronoStart(void)
{
 register int i = MAXPROC;

 chMax = 1;
 while (i--)
   {
    proc[i] = NULL;
    call[i] = 0;
    tSys[i] = tUser[i] = (double) 0;
  }
 proc[0] = "Chrono" ;
 getrusage (RUSAGE_SELF,previous) ;

 chronoIsRunning = TRUE ;
}
 
/******************************************/

static void chronoStop(void)
{
 chronoIsRunning = FALSE ;
}
 
/******************************************/

static int alphabetic(void *a,void *b)
{
 return strcmp(proc[*(int*)a], proc[*(int*)b] ) ;
}

/******************************************/
 static Graph chronoGraph = 0;
  static Array line = 0 ;
static void localDestroy(void)
{
  chronoStop() ;
  chronoGraph = 0 ;
  arrayDestroy(line);
  line = 0 ;
}

/******************************************/
/*********** Pubic Routines ***************/
/******************************************/
 
  /* aliased to chrono in chrono.h */
void chronoSwitch(char *cp)
{
 register int i = chMax;

 if (!chronoIsRunning) 
   return ;
 getrusage (RUSAGE_SELF,current) ;
  while(--i)
   if (proc[i] == cp) break;
 if (!i)
     proc[i = chMax++] = cp;

 if (chMax >= MAXPROC ) 
   messcrash("overflow in chrono(), increase MAXPROC");

 call[i] ++;
 chronoPush(i) ;
 chronoGo(i) ;
}

/*****************************************/

  /* aliased to chronoReturn in chrono.h */
void chronoDoReturn(void)
{
 register int i;
 if (!chronoIsRunning) 
   return ;
 getrusage (RUSAGE_SELF,current) ;
 i = chronoPop();
 if (i>=0) 
   chronoGo(i);
}

/******************************************/
void chronoShow(void)
{


 register  int i, j ;
 double tSysTotal = 0, tUserTotal = 0;

 if (!line)
   line = arrayCreate(chMax,int);
 else
   arrayMax(line) = 0 ;

 chronoStop() ;
 if(! graphActivate(chronoGraph))
   { chronoGraph =  displayCreate(DtChrono) ;
     graphRegister(DESTROY, localDestroy) ;
   }
 else
   graphPop() ;
 graphClear();
 graphTextBounds (100,chMax+6) ;
 graphColor (BLACK) ;

 if(!chMax)
   graphText("Start the chronometer from the pull down menu of this window",4,4) ;
 else
   {
     for (i=0; i<chMax; i++)
       {
         array(line,i,int) = i;
	 tSysTotal += tSys[i] ;
	 tUserTotal += tUser[i] ;
       }
     graphText(messprintf(
      "Total time : %.2f s  system,  %.2f user", tSysTotal, tUserTotal), 20,2);

     graphText ("# of calls",17,4) ;
     graphText ("System  %%",32,4) ;
     graphText ("User    %%",50,4) ;

     arraySort(line,alphabetic);
     for (j=0; j<chMax; j++)
       {
         i = arr(line, j,int);
	 graphText(proc[i], 8, j + 6);
	 graphText(messprintf("%6d",call[i]),22,j+6) ;
	 graphText (messprintf("%8.2f  %5d",tSys[i], 
			       (int)(100 * tSys[i]/tSysTotal)),30,j+6) ;
	 graphText(messprintf("%8.2f %5d  ",
			      tUser[i],(int)( 100 * tUser[i]/tUserTotal)),
		   46, j + 6);
       }
   }
 graphLine (29,5,29,6+chMax) ;
 graphLine (47,5,47,6+chMax) ;

 graphRedraw() ;
 graphMenu (chronoMenu);
}
 
/*****************************************/

#else

  /* The only public routine need if noCHRONO 
     is a tiny chronoShow from the main menu
     */

void chronoShow(void)
{
  messout("To gain access to the Chronometer,\n recompile with the option -DCHRONO");
}

#endif

/*****************************************/
/*****************************************/


