untrusted comment: signature from openbsd 6.3 base secret key
RWRxzbLwAd76ZRqyMFEWTbREzsmivirLFMKDgzHbf7QqP6aCOr+6Ms0WjYdQfGsjuVL1rrtxASos5Du0Uqjt6ErRLPPaciBdggM=

OpenBSD 6.3 errata 009, June 13, 2018:

DSA and ECDSA signature generation can potentially leak secret information
to a timing side-channel attack.

Apply by doing:
    signify -Vep /etc/signify/openbsd-63-base.pub -x 009_libcryto.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libcrypto:
	cd /usr/src/lib/libcrypto
	make obj
	make
	make install

Index: lib/libcrypto/dsa/dsa_ossl.c
===================================================================
RCS file: /cvs/src/lib/libcrypto/dsa/dsa_ossl.c,v
diff -u -p -r1.30 -r1.30.2.1
--- lib/libcrypto/dsa/dsa_ossl.c	29 Jan 2017 17:49:22 -0000	1.30
+++ lib/libcrypto/dsa/dsa_ossl.c	13 Jun 2018 15:08:08 -0000	1.30.2.1
@@ -142,11 +142,8 @@ redo:
 	/* Compute  s = inv(k) (m + xr) mod q */
 	if (!BN_mod_mul(&xr, dsa->priv_key, r, dsa->q, ctx))	/* s = xr */
 		goto err;
-	if (!BN_add(s, &xr, &m))				/* s = m + xr */
+	if (!BN_mod_add(s, &xr, &m, dsa->q, ctx))		/* s = m + xr */
 		goto err;
-	if (BN_cmp(s, dsa->q) > 0)
-		if (!BN_sub(s, s, dsa->q))
-			goto err;
 	if (!BN_mod_mul(s, s, kinv, dsa->q, ctx))
 		goto err;
 
Index: lib/libcrypto/ecdsa/ecs_ossl.c
===================================================================
RCS file: /cvs/src/lib/libcrypto/ecdsa/ecs_ossl.c,v
diff -u -p -r1.9 -r1.9.2.1
--- lib/libcrypto/ecdsa/ecs_ossl.c	29 Jan 2017 17:49:23 -0000	1.9
+++ lib/libcrypto/ecdsa/ecs_ossl.c	13 Jun 2018 15:08:08 -0000	1.9.2.1
@@ -273,7 +273,7 @@ ecdsa_do_sign(const unsigned char *dgst,
 			ECDSAerror(ERR_R_BN_LIB);
 			goto err;
 		}
-		if (!BN_mod_add_quick(s, tmp, m, order)) {
+		if (!BN_mod_add(s, tmp, m, order, ctx)) {
 			ECDSAerror(ERR_R_BN_LIB);
 			goto err;
 		}
