/* --------------------------------- drivers.c ------------------------------ */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* User defined lists of drivers.
 *
 * Associated with the player we have one of each:
 *  Graphics Driver (output)
 *  Sound Driver (output)
 *  Keyboard Driver (input)
 *  Pointer Driver (input)
 *  Network Drivers (i/o)
 *
 *  Windows support by Michael Taylor miket@canb.auug.org.au
*/

#include "fly.h"

extern struct GrDriver NEAR GrMSWinS;
extern struct GrDriver NEAR GrMSWinB;
#ifdef USEWING	
extern struct GrDriver NEAR GrWing;
extern struct GrDriver NEAR GrvWing;
#endif

struct GrDriver NEAR * FAR GrDrivers[] = {
	&GrMSWinS,		/* flicker - single buffered		 */
	&GrMSWinB,		/* uses a bitmap to stop flicker- Slow!! */
#ifdef USEWING	
	&GrWing,		/* uses the MS Wing library */
	&GrvWing,		/* uses the MS Wing library */
#endif
0};


extern struct SndDriver NEAR PlsMMSound;

struct SndDriver NEAR * FAR SndDrivers[] = {
	&PlsMMSound,
0};


extern struct PtrDriver NEAR PtrMouse;
extern struct PtrDriver NEAR PtrKeypad;
extern struct PtrDriver NEAR PtrAstick;
extern struct PtrDriver NEAR PtrBstick;
extern struct PtrDriver NEAR PtrRandom;

struct PtrDriver NEAR * FAR PtrDrivers[] = {
	&PtrKeypad,
	&PtrMouse,
	&PtrAstick,
	&PtrBstick,
	&PtrRandom,
0};


extern struct KbdDriver NEAR KbdConsole;

struct KbdDriver NEAR * FAR KbdDrivers[] = {
	&KbdConsole,
0};


struct NetDriver NEAR * FAR NetDrivers[] = {
0};
