/* --------------------------------- vgr.h ---------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* header for linear buffer graphics routines, vgr.c.
*/

/* vgr.c */
extern int	FAR vSetWriteMode (int mode);
extern int	FAR vSetActive (int page);
extern int	FAR vSetVisual (int page);
extern int	FAR vSetMem (Uchar *vmem);
extern int	FAR vSetSize (Uint width, Uint height, Uint xbytes);
extern void	FAR vInit (Uchar *vmem, Uint width, Uint height, Uint xbytes,
	void (FAR *setbank) (int bank),
	int  (FAR *setbase) (Ulong base));
extern void	FAR vMoveTo (Uint x1, Uint y1);
extern void	FAR vDrawTo (Uint x2, Uint y2, Uint c);
extern void	FAR vEllipse (Uint xc, Uint yc, Uint a, Uint b, Uint c);
extern Ulong	FAR vStats[2048];

/* grstat.c */
extern Ulong	FAR GrStats[2048];
extern void	FAR LogStats (void);
