/********************************************************************
 *                                                                  *
 *      CRISP - Custom Reduced Instruction Set Programmers Editor   *
 *                                                                  *
 *      (C) Paul Fox, 1989                                          *
 *                                                                  *
 *    Please See COPYRIGHT notice.                                  *
 *                                                                  *
/*   This  is  terminal  description file for the xterm window under  */
/*   X11 which is a VT-100 like emulator.			      */
/**********************************************************************/

# include	"tty.h"

void
main()
{

	/***********************************************/
	/*   Set   characters   used   for   extended  */
	/*   graphics support when drawing windows.    */
	/***********************************************/
	set_term_characters(
		"l",	/* Top left of window.			    */
		"k",	/* Top right of window.			    */
		"m",	/* Bottom left of window.		    */
		"j",	/* Bottom right of window.		    */
		"x",	/* Vertical bar for window sides.	    */
		"q",	/* Top and bottom horizontal bar for window.*/
		"w",	/* Top join.				    */
		"v",	/* Bottom join.				    */
		"n",	/* Window 4-way intersection.		    */
		"u",	/* Left hand join.      		    */
		"t"	/* Right hand join.      		    */
		);

	/***********************************************/
	/*   Define   escape   sequences   used   for  */
	/*   special optimisations on output.	       */
	/***********************************************/
	set_term_features(
		NULL,		/* Sequence to clear 'n' spaces.	  */
		NULL,		/* Sequence to print characters with top  */
		     		/* bit set.				  */
		NULL,		/* Insert-mode cursor.			  */
		NULL,		/* Overwrite-mode cursor.		  */
		NULL,		/* Insert-mode cursor (on virtual space). */
		NULL,		/* Overwrite-mode cursor (on virtual space).*/
		NULL,		/* Print ESCAPE character graphically.	    */
		NULL,		/* Escape sequence to repeat last character.*/
		FALSE,		/* ESC [0m resets color.		    */
		FALSE,		/* Terminal supports color.		    */
		"\x1B[%dC",	/* Sequence to move cursor on same line   */
		TRUE,		/* ESC[K gives us a black erased line.	  */
		FALSE,		/* Allow scrolling (ins/del)		  */
		"\x1B(0",	/* Enter graphics mode.			  */
		"\x1B(B"	/* Exit graphics mode.			  */
		);

	/***********************************************/
	/*   Define  keyboard  layout  for  non-ascii  */
	/*   characters.  These  can only be used for  */
	/*   the console).			       */
	/***********************************************/
	set_term_keyboard(
		F1_F12, quote_list(
			"\x1B[192z", "\x1B[193z", "\x1B[194z", "\x1B[195z",
			"\x1B[196z", "\x1B[197z", "\x1B[198z", "\x1B[199z", 
			"\x1B[200z", "\x1B[201z", "\x1b[234z", "\x1B[235z"),


		/***********************************************/
		/*   Default   is  VT100  key  bindings.  Use  */
		/*   '-sf'  on  BTERM to add Sun function key  */
		/*   support.				       */
		/***********************************************/
		F1_F12, quote_list(
			"\x1B[11~", "\x1B[12~", "\x1B[13~", "\x1B[14~", 
			"\x1B[15~", "\x1B[17~", "\x1B[18~", "\x1B[19~",
			"\x1B[20~", "\x1B[21~"),

		/***********************************************/
		/*   These are the LEFT-letter keys.	       */
		/***********************************************/
		ALT_A_Z, quote_list(
			"\x1Ba", "\x1Bb", "\x1Bc", "\x1Bd", "\x1Be",
			"\x1Bf", "\x1Bg", "\x1Bh", "\x1Bi", "\x1Bj",
			"\x1Bk", "\x1Bl", "\x1Bm", "\x1Bn", "\x1Bo",
			"\x1Bp", "\x1Bq", "\x1Br", "\x1Bs", "\x1Bt",
			"\x1Bu", "\x1Bv", "\x1Bw", "\x1Bx", "\x1By",
			"\x1Bz"),

		KEYPAD_0_9, quote_list(
			"\x1B[2~", "\x1BO$", "\x1BOB", "\x1B[6~",
			"\x1BOD", "\x1BOu", "\x1BOC", "\x1BO\x00",
			"\x1BOA", "\x1B[5~", NULL, "\x1BOk",
			"\x1BOm", "\x1BOj"),

		CTRL_KEYPAD_0_9, quote_list(
			NULL, NULL, NULL, "\x1B[232z", 
			NULL, "\x1B[231z"),
		ALT_0_9, quote_list(
			"\x1B1", "\x1B2", "\x1B3", "\x1B4", "\x1B5",
			"\x1B6", "\x1B7", "\x1B8", "\x1B9", "\x1B0"),
			
		SHIFT_KEYPAD_2, "\x1BOr",
		SHIFT_KEYPAD_4, "\x1BOt",
		SHIFT_KEYPAD_6, "\x1BOv",
		SHIFT_KEYPAD_8, "\x1BOx",
		
		MOUSE_KEY, "\x1B[M",

		ALT_0_9, quote_list(
			"\x1bA0",
			"\x1bA1",
			"\x1bA2",
			"\x1bA3",
			"\x1bA4",
			"\x1bA5",
			"\x1bA6",
			"\x1bA7",
			"\x1bA8",
			"\x1bA9")
		);
		
	assign_to_key("<Mouse>", "xterm_mouse");
}
/**********************************************************************/
/*   Macro  called  when  a  mouse  button is hit from an Xterm when  */
/*   the mouse option is enabled in the window.			      */
/**********************************************************************/
int	mouse_cnt = 0;
void
xterm_mouse()
{	int	ch1, ch2, ch3;

	ch1 = read_char(0);
	ch2 = read_char(0);
	ch3 = read_char(0);
	message("Mouse hit %d! %s%s%s (%d,%d)", 
		mouse_cnt++,
		ch1 == ' ' ? "o" : "-",
		ch1 == '!' ? "o" : "-",
		ch1 == '"' ? "o" : "-",
		ch2 - ' ', ch3 - ' '
		);
	/***********************************************/
	/*   Let  CRISP  do  the real work of working  */
	/*   out whats happened to the mouse keys.     */
	/***********************************************/
	process_mouse(ch1 == ' ', ch1 == '!', ch1 == '"', 
		ch2 - ' ' - 1, 
		ch3 - ' ' - 1);
}
void
xterm_arrow()
{
	set_term_keyboard(
		KEYPAD_0_9, quote_list(
			"\x1B[212z", "\x1B[220z", "\x1B[B",  "\x1B[222z",
			"\x1B[D", NULL, "\x1B[C", "\x1B[214z", "\x1B[A")
		);
} 

/**********************************************************************/
/*   Macro to handle xterm running under Sun's OpenWindows product.   */
/**********************************************************************/
void
openwin() 
{ 
	set_term_keyboard(
		SHIFT_F1_F12, quote_list(
			"\x1B[224z", "\x1B[225z", "\x1B[226z", "\x1B[227z",
			"\x1B[228z", "\x1B[229z", "\x1B[230z", "\x1B[231z",
			"\x1B[232z"),
			
		ALT_A_Z, quote_list(
			"\xe1", "\xe2", "\xe3", "\xe4", "\xe5",
			"\xe6", "\xe7", "\xe8", "\xe9", "\xea",
			"\xeb", "\xec", "\xed", "\xee", "\xef",
			"\xf0", "\xf1", "\xf2", "\xf3", "\xf4",
			"\xf5", "\xf6", "\xf7", "\xf8", "\xf9",
			"\xfa"));
}

/**********************************************************************/
/*   Sunview function keys.					      */
/**********************************************************************/
void
sf()
{
	set_term_keyboard(
		F1_F12, quote_list(
			"\x1B[224z", "\x1B[225z", "\x1B[226z", "\x1B[227z",
			"\x1B[228z", "\x1B[229z", "\x1B[230z", "\x1B[231z",
			"\x1B[232z", "\x1B[233z"),
		KEYPAD_0_9, quote_list(
			"\x1B[2z", 
			"\x1B[220z", "\x1BOB", "\x1B[222z",
			"\x1BOD", "\x1B[218z", "\x1BOC", 
			"\x1B[214z", "\x1BOA", "\x1B[216z", 
			"\x1B[P", 
			"\x1BOk", "\x1BOm", "\x1B[213z"),
		CTRL_KEYPAD_0_9, quote_list(
			NULL, 
			"\x1B[220C", "\x1B[221C", "\x1B[222C", 
			"\x1B[217C", "\x1B[218C", "\x1B[219C", 
			"\x1B[214C", "\x1B[215C", "\x1B[216C")
		);
}

