/**********************************************************************/
/*                                                                    */
/*	CRISP - Programmable editor                                   */
/*	===========================                                   */
/*                                                                    */
/*  File:          window.cr                                          */
/*  Author:        P. D. Fox                                          */
/*  Created:       7 Jun 1991                      		      */
/*                                                                    */
/*  Copyright (c) 1990, 1991 Paul Fox                                 */
/*                All Rights Reserved.                                */
/*                                                                    */
/*                                                                    */
/*--------------------------------------------------------------------*/
/*  Description:  Terminal Description for native window support      */
/*                                                                    */
/*   This  description  file is used to configure CRISP when running  */
/*   under  a  windowing  system,  e.g.  X11. It avoids us having to  */
/*   define  key  bindings,  because  they're  built  into  CRISP or  */
/*   configurable  via  the  standard resource management scheme. We  */
/*   just  need  to  tell  it  simple things like we have color. (If  */
/*   the hardware doesnt have color, then CRISP will figure it out).  */
/**********************************************************************/

/* SCCS ID: %Z% %M% %R%.%L% */
# include	"tty.h"

void
main()
{
	/***********************************************/
	/*   We  only  want  to  tell  CRISP  we have  */
	/*   color for now.			       */
	/***********************************************/
	set_term_features(
		NULL,		/* Sequence to clear 'n' spaces.	    */
		NULL,		/* Sequence to print characters with top    */
				/* bit set.				    */
		NULL,		/* Insert-mode cursor.			    */
		NULL,		/* Overwrite-mode cursor.		    */
		NULL,		/* Insert-mode cursor (on virtual space).   */
		NULL,		/* Overwrite-mode cursor (on virtual space).*/
		NULL,		/* Print ESCAPE character graphically.	    */
		NULL,	  	/* Escape sequence to repeat last character.*/
		NULL,	  	/* ESC [0m resets color.		    */
		TRUE,	  	/* Terminal supports color.		    */
		NULL,
		NULL,
		NULL 		/* Dont try and scroll window.		    */
		);
}
