/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.FixedSortKeyDefinition;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.sort.SortedIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.xpath.XPathException;

public class SortExpression
extends ComputedExpression {
    private Expression select = null;
    private SortKeyDefinition[] sortKeys = null;
    private FixedSortKeyDefinition[] fixedSortKeys = null;

    public SortExpression(Expression expression, SortKeyDefinition[] sortKeyDefinitionArray) {
        this.select = expression;
        this.sortKeys = sortKeyDefinitionArray;
        boolean bl = true;
        int n = 0;
        while (n < sortKeyDefinitionArray.length) {
            if (!(sortKeyDefinitionArray[n] instanceof FixedSortKeyDefinition)) {
                bl = false;
                break;
            }
            ++n;
        }
        if (bl) {
            this.fixedSortKeys = new FixedSortKeyDefinition[sortKeyDefinitionArray.length];
            System.arraycopy(sortKeyDefinitionArray, 0, this.fixedSortKeys, 0, sortKeyDefinitionArray.length);
        }
    }

    public Expression simplify() throws XPathException {
        this.select = this.select.simplify();
        return this;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.select = this.select.analyze(staticContext);
        if (!Cardinality.allowsMany(this.select.getCardinality())) {
            return this.select;
        }
        return this;
    }

    public int computeCardinality() {
        return this.select.getCardinality();
    }

    public ItemType getItemType() {
        return this.select.getItemType();
    }

    public int computeSpecialProperties() {
        int n = 0;
        if ((this.select.getSpecialProperties() & 0x10000) != 0) {
            n |= 0x10000;
        }
        return n;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        FixedSortKeyDefinition[] fixedSortKeyDefinitionArray;
        SequenceIterator sequenceIterator = this.select.iterate(xPathContext);
        XPathContext xPathContext2 = xPathContext.newContext();
        if (this.fixedSortKeys != null) {
            fixedSortKeyDefinitionArray = this.fixedSortKeys;
        } else {
            fixedSortKeyDefinitionArray = new FixedSortKeyDefinition[this.sortKeys.length];
            int n = 0;
            while (n < this.sortKeys.length) {
                fixedSortKeyDefinitionArray[n] = this.sortKeys[n].reduce(xPathContext2);
                ++n;
            }
        }
        sequenceIterator = new SortedIterator(xPathContext2, sequenceIterator, fixedSortKeyDefinitionArray);
        return sequenceIterator;
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "sort");
        this.select.display(n + 1, namePool);
    }
}

