.\" 
.de EX		\"Begin example
.ne 5
.if n .sp 1
.if t .sp .5
.nf
.in +.5i
..
.de EE
.fi
.in -.5i
.if n .sp 1
.if t .sp .5
..
.TH XGOPHER 1 "Release 5" "X Version 11"
.SH NAME
xgopher - gopher client for the X window system
.SH SYNTAX
.PP
\fBxgopher\fP [-\fItoolkitoption\fP ...]
.PP
.SH DESCRIPTION
.PP
\fIxgopher\fP is an X window system client interface to the
gopher information server.  Xgopher provides access to tremendous
amounts of information which may be accessed from a local system
or a remote information server.  The source of the information
is generally transparent, with data supplied from world-wide
locations as easily as from a local on-campus server.

The Gopher information system software is from the University of Minnesota.
.PP
.SH INTERACTIONS
.PP
The initial display will show the top level directory of gopher
information available.  Selecting an item from this list will
fetch the contents of a file, subdirectory, or other information.
The directory display may be updated to show the new subdirectory.

A item is highlighted by pointing at a directory list item or
a previously marked directory (a bookmark) with the mouse
and clicking the left button.  The display button marked 
"Fetch selection" is used to act on the selection.  An
accelerator allows you to simply "click" a second time on
a highlighted item to activate the fetch.

By default, all interactions use only the left mouse button.

A directory is a collection of other files and directories.
The directory items are displayed in a list with an identifying
symbol to the left of each item.  The symbol identifies the type
of the item.  The symbols may be changed by the installer or
by each user.  The default symbols are:
.RS .5i
.TP 1.5i
blank
Text file
.TP 1.5i
>>
directory
.TP 1.5i
<cso>
a CSO name server (phone book)
.TP 1.5i
<idx>
a full text index search
.TP 1.5i
<tel>
a telnet session
.TP 1.5i
<snd>
a sound file (spoken, sound effect, or music)
.RS .5i
.PP
The file types are discussed below.

From all but the top level directory, the \fBGo up a Level\fP button
will return you to the parent of the currently displayed directory.
A keyboard accelerator allows you to press the "u" key while
the X pointer is anywhere on the main panel to achieve the same
action.

.SH BOOKMARKS
If you are viewing a directory that you may wish to return to
later, set a bookmark there with the \fBSet new bookmark\fP button.
This directory will be displayed with your other bookmarks in the 
lower scrolling region below the current directory list.

Later, no matter where you have browsed through the gopher
directory space, you may return to any bookmark by selecting
it just as you would a regular directory item.  You are brought
immediately to that marked directory, in the same context that
you were when you were last there.  This means, for example, that
if you press \fBGo up a Level\fP, you are moved to the parent
of that now-current directory.  The location of the directory that you were
in when you selected the bookmark is not saved unless you explicitly
marked it with a bookmark also.

Other buttons let you remove individual bookmarks or all of the bookmarks.

The main gopher directory that you see when you first start Xgopher
is normally marked for you so you can easily and quickly return
to the top level.

.SH TEXT DISPLAYS
When the item selected from the directory list is a text file,
the contents of the file are fetched and displayed as a 
pop-up text display window.  Help information is displayed in
this way also.

The text display shows several command buttons and the text
itself in a vertically scrolling window.  The buttons are:
\fBDone\fP to release this text file and window,
\fBPage down\fP to position the text down one page,
\fBPage up\fP to position the text up one page,
\fBPrint\fP to send the contents of this display to the printer,
\fBSave\fP to save the contents of this display in a user-specified file.
The \fBPrint\fP or \fBSave\fP buttons may not always be available.
They may be disallowed by the installer or system-wide resources file for
Xgopher.
.PP
Text displays use the text widget from the MIT-supplied Athena
widget set.  The text is given a read-only attribute, but all
of the position, search, and selection capabilities of the 
widget are available.  For the user who knows how to use these
functions, there is this additional power.  For example, entering
control-S from the keyboard will bring up a text search panel
allowing you to scan for any string in the file.  Other control
sequences allow more flexible text positioning than is provided
by the scroll bar and paging buttons.  All of these options
are described in the Athena widget set documentation of the
text widget.

.SH CSO NAME SERVER (Phone Book)
When the item selected is a CSO name server,
a new window is displayed on the X display.  The name
of the institution supporting the name server is displayed
at the top of the window.  Below this are 4 areas.  First
are the control buttons: \fPDone\fP closes the CSO name server window;
\fBHelp\fP provides a text display with additional information;
and \fBShow Fields\fP, discussed below.

The next area is a single line text entry field where you type
the name of the person you are looking up.  The name server will
usually be able to find someone by first name, last name, or both.
Although, overly general searches are prohibited.  For example, trying to
look up "smith" is probably not a good idea in most of the United States.
After entering the name, type a carriage return (enter) or click
the mouse on the \fBDo query\fP button to submit the request.
Additional buttons in the third area allow you to clear
the query or result text areas.
The result is displayed in the forth area, the bottom scrolling text region.

The \fBShow Fields\fP button displays a pop up menu.
Select an item from this menu to
list the
names and a brief description of the fields in the data base being
searched.  Note that these fields may be different for every
institution!  Listing \fBdefault\fP fields will show the things that 
are returned for a normal query (usually name, address, phone number,
department, plus others).
\fBIndexed\fP fields are those that you can
use to search for (usually name and perhaps office phone).
\fBLookup\fP fields are those that can be used to narrow the search
(for example, department).
Finally, \fBPublic\fP fields are all the 
fields that can be viewed by everyone.

A query may include more than just a name, for example, legitimate
queries are:
.RS .5i

.IP "john smith" .5i
.br
This will return every John Smith in the selected data base.
If there are more than a handful, the name server will complain
that there are too many to give you.  In this case, you may
want to try the next example.

.IP "smith department=biology" .5i
The department will help narrow the search to only those
people in the department of biology.

.IP "j* smith department=biology" .5i
A "*" matches any characters and will help if you are not
sure of the exact spelling of a name or only know initials.

.IP "john smith department=biology return all" .5i
The return option may specify a field you are interested in
or the value "all" to get all public fields returned.
.RE

The CSO name server window may be left on the X display as long as
you like.  Once displayed, it operates independent of the 
gopher directory traversal.  If you want to switch to search
another institution's phone directory you can select it
from the appropriate directory list without first closing a
prior CSO name server window.  The same window is re-used for the
currently selected institution.

.SH INDEX SEARCH
An index search is a very powerful way of obtaining a list
of documents which contain (or do not contain) certain words.
When you select an index search item, a small pop-up panel
asks you for a list of search words.  You can enter one or
more words, plus the special reserved boolean operators
\fBand\fP, \fBor\fP, and \fBnot\fP.  For example, if you want
information on setting certain terminal parameters for Unix,
you may enter:
.RS .5i

terminal and setting or tset

.RE
which will find all documents in the search space which contain
both the words "terminal" and "setting", or the word "tset".  The
"or" is non-exclusive so the document may contain all of the words.
The input words may be in upper- or lower-case, and will match
words of either case.

After entering the words, press carriage return (enter) or click
the mouse on the "Do query" button and the search will be carried
out.

The result of the index search looks very much like a normal
gopher directory of text files,
but each file is one that matches
your specified criterion.

You will see a difference in the display of the text file, however.
Every word (or part of a word) that matches the index words will be
highlighted in the text display.  This allows you to quickly
locate the parts of a document that are interesting to you.

.SH TELNET SESSION
Telnet sessions are normally text-based information services,
for example access to University library holdings.

When you select an item which is identified as a telnet session,
A new xterm window (normal terminal emulator window) will be created
and it will be running a telnet session.
It may take a few seconds for the xterm window to show up.
Some hosts that you connect to may require you to enter a
username (login name).  If so, then Xgopher will pop up an
information window showing you the name to use once the
telnet session is started.
Many telnet sessions require you to enter a terminal type as
a part of the startup interaction.  Usually, you should choose
\fBvt100\fP, as the xterm commands are very similar to that
of a DEC VT100 terminal.

Telnet sessions may be disallowed by the 
\fBallowTelnet\fP resource described below.
If telnet sessions are not allowed, an error message will be displayed to 
that effect.

.SH SOUNDS
If your X display is a workstation that supports sounds,
then you can play files containing spoken words, sound effects,
or music through Xgopher.  Selecting a sound file will
cause that file to be "played" through your workstation's
audio device.  Only a single sound file can be active at a time;
you will be warned if you try to play a sound before
a previous one is through.  Use the application resources
\fBhasSound\fP and \fBsoundCommand\fP described below.

.SH RESOURCES
.PP
The application class is \fBXgopher\fP.  Most of the user-interface
is configured in the app-defaults file; if this file is missing
a warning message will be printed to standard error and the
program will terminate.  All of the important defaults are
established in the system app-defaults file, normally installed
as /usr/lib/X11/app-defaults/Xgopher.
... The widget hierarchy is documented in the system app-defaults file.
.PP
The defaults mentioned below may have been changed by the
installer for a specific system.  They may all be overridden
in by individual preferences.  Application specific resources:
.PP
.TP 8
.B "rootServer (\fPclass\fB RootServer)"
Specifies the initial gopher information server host name
as an internet address.
.TP 8
.B "rootPort (\fPclass\fB RootPort)"
The port number of the top level gopher server to connect to.
The supplied default is 70.
.TP 8
.B "helpFile (\fPclass\fB HelpFile)"
This is the absolute or relative path name of the file to be
displayed when the \fIhelp\fP command button is depressed.
The supplied default is /usr/lib/X11/xgopher/xgopher.help
.TP 8
.B "mainTitle (\fPclass\fB MainTitle)"
The main title displayed above the listing of the top level directory.
The supplied default is "UIUC Gopher Information Service".
.TP 8
.B "allowPrint (\fPclass\fB AllowPrint)"
If this boolean resource is true, text displayed in pop up windows
may be spooled to a printer by depressing a \fIPrint\fP button.
If False, the button will not be displayed.
The supplied default is True.
.TP 8
.B "allowSave (\fPclass\fB AllowSave)"
If this boolean resource is true, text displayed in pop up windows
may be saved to a user-specified file by depressing a \fISave\fP button.
If False, the button will not be displayed.
The supplied default is True.
.TP 8
.B "printCommand (\fPclass\fB PrintCommand)"
This is the print command used to spool a print request.  Useful
examples of print commands are \fIlpr\fP or \fIenscript\fP.  The gopher
internal file name containing the text is appended to the end of the
command supplied.  As an option, if the 2 characters %s appear in the
print command string anywhere, they are replaced by the file name.
The %s may even appear more than once.  If %s appears, then the file
name is not appended to the end.
The supplied default is: "# print" without the quotes.  It is a comment.
.TP 8
.B "markRoot (\fPclass\fB MarkRoot)"
When true, a bookmark is automatically set at the top lever (root)
directory.  If you do not want to have this bookmark set, change
the value of this resource to False.
The supplied default is True.
.TP 8
.B "directoryTime (\fPclass\fB DirectoryTime)"
Directory entries for all active directories (current directory, 
directories with bookmarks, and all of their ancestors) are saved
for this many seconds.  After this time, their contents are released
and re-requested from the appropriate place when needed.  This caching
of directory contents makes moving up the directory tree and jumping
to bookmarks quite fast.  The very small potential risk is that the
contents of a directory in a gopher server may be changed while
the directory is stored.  The caching, freeing, and reloading
of directories is transparent to the user.
The supplied default is 600.  This is 10 minutes.
.TP 8
.B "hasSound (\fPclass\fB HasSound)"
This flag indicated whether the X display being used has the
ability to play general sounds, such as spoken words, sound effects, 
and music.  For example, an X terminal will not normally have this
ability, but some workstations such as the Sun SparcStation can play
sounds.
The supplied default is False.
.TP 8
.B "soundCommand (\fPclass\fB SoundCommand)"
The command to use to get a sound file from the standard input
stream (\fIstdin\fP) to the audio device.  On many workstations
this command may be called "\fIplay\fP".  Another command which
may be useful is "\fIcat > /dev/audio\fP".  The supplied command
is started by Xgopher as a separate process with sound data fed
into its standard input.  This command is never executed if
the \fBhasSound\fP resource is False.
The supplied default is "play" (without the quotes).
.TP 8
.B "allowTelnet (\fPclass\fB AllowTelnet)"
If this boolean resource is true, telnet sessions are allowed.
If False, they are inhibited with an error message displayed to 
that effect.
This resource should be False in secure environments such as
public access terminals, as it is easy to start a shell from a
telnet session.
The supplied default is True.
.TP 8
.B "telnetCommand (\fPclass\fB TelnetCommand)"
The command Xgopher will use to start a telnet session.
The host and port number are added to the end of this command.
The resulting command is executed
(via the \fIsystem(3)\fP function) to provide a telnet session.
In general, the telnet command should be executed by an xterm
as with the default (\fIxterm -e telnet\fP).
In some environments (such as OpenWindows), it may be useful
to specify the full path name of both the xterm and telnet commands.
For example, \fI/usr/bin/X11/xterm -e /usr/ucb/telnet\fP.
This command should be disabled for secure environments such as
public access terminals, as it is easy to start a shell from a
telnet session.
the \fBallowTelnet\fP resource is False.
The supplied default is "xterm -e telnet" (without the quotes).
.TP 8
.B "itemStart (\fPclass\fB ItemStart)"
Not normally changed by the user, this determines the amount of 
memory dynamically allocated when xgopher starts execution to hold
gopher items (directory contents).
The supplied default is 500.
.TP 8
.B "itemIncrement (\fPclass\fB ItemIncrement)"
Not normally changed by the user, this determines the amount of 
memory dynamically allocated each time xgopher needs additional 
memory to hold gopher items (directory contents).
The supplied default is 50.
.TP 8
.B "dirStart (\fPclass\fB DirStart)"
Not normally changed by the user, this determines the amount of 
memory dynamically allocated when xgopher starts execution to hold
gopher directories.
The supplied default is 50.
.TP 8
.B "dirIncrement (\fPclass\fB DirIncrement)"
Not normally changed by the user, this determines the amount of 
memory dynamically allocated each time xgopher needs additional
memory to hold gopher directories.
The supplied default is 10.
.TP 8
.B "doubleClick (\fPclass\fB DoubleClick)"
Normally a gopher item or directory is selected by "clicking" on
it.  Then the \fIFetch\fP button is pressed to process the request.
If this resource is true, the fetch action may be invoked by
simply re-selecting the same item already selected.  This is
a double-click on that item, although with no time limit between
clicks.
The supplied default is True.
It may be disabled for example, if a touch sensitive
screen replaces the mouse, to ensure more reliable operation.
.TP 8
.B "tempDirectory (\fPclass\fB TempDirectory)"
The directory for xgopher to create files that it will need
for display or other purposes, but will not exist beyond this
xgopher session.
The supplied default is /tmp.
.TP 8
.B "logFile (\fPclass\fB LogFile)"
If a file name is provided, all directory changes, remote host
connections, and errors are logged to this file.  If nothing
else, it provides a trail of where you have been and allows
some simple diagnostics to determine what remote machines
are not accessible.  If no file name is provided, no logging occurs.
The supplied default is no log file.
.TP 8
.B "prefixFile (\fPclass\fB PrefixFile)"
This prefix is shown in the directory listing to the left of
text files.
The supplied default is blank for text files.
.TP 8
.B "prefixDir (\fPclass\fB PrefixDir)"
This prefix is shown in the directory listing to the left of
directory entries.
The supplied default is \273 (an octal escape sequence),
which is a single character in the
Latin-1 character set which looks like \fI>>\fP.
.TP 8
.B "prefixCSO (\fPclass\fB PrefixCSO)"
This prefix is shown in the directory listing to the left of
entries which are CSO name servers (phone books).
The supplied default is <cso>.
.TP 8
.B "prefixTelnet (\fPclass\fB PrefixTelnet)"
This prefix is shown in the directory listing to the left of
entries which are telnet sessions.
The supplied default is <tel>.
.TP 8
.B "prefixIndex (\fPclass\fB PrefixIndex)"
This prefix is shown in the directory listing to the left of
entries which are full text index searches.
The supplied default is <idx>.
.TP 8
.B "prefixSound (\fPclass\fB PrefixSound)"
This prefix is shown in the directory listing to the left of
entries which are sound files.
The supplied default is <snd>.
.TP 8
.B "prefixUnknown (\fPclass\fB PrefixUnknown)"
This prefix is shown in the directory listing to the left of
entries which are unknown file types.
This prefix is not normally displayed since Xgopher normally does not
display file types which it cannot further process.
The supplied default is <???>.
.PP
Widget specific resources:
.PP
The X Toolkit and Athena Widgets documentation covers the
widget specific resources.
The most significant widget specific resources are mentioned here.
.TP 8
.B "font (\fPclass\fB Font)"
All text, label, and command button widgets have a font that can be selected.
.TP 8
.B "label (\fPclass\fB Label)"
All command button widgets and many labels text strings may be
changed, for example to another language.
.PP
.SH FILES
.PP
 /usr/local/lib/X11/app-defaults/Xgopher
.PP
 /usr/local/lib/X11/xgopher.help
.PP
.SH SEE ALSO
.PP
Installers should see the internal documentation for
changes to the configuration file before compiling and
installing Xgopher.
.SH BUGS
.PP
Some gopher file types are not yet supported.  These are
primarily binary file types.  They are
intentionally omitted for now as the official Minnesota Gopher
Protocol document cautions that this file type and protocol
may change shortly.  Duplicate servers are also not yet supported.
.SH COPYRIGHT
Copyright 1992 by the Board of Trustees of the University of Illinois
.br
This program with copyright notice intact may be freely
distributed without permission.
.SH AUTHOR
.PP
Allan Tuchman, Computing and Communications Services Office,
University of Illinois at Urbana-Champaign, Urbana, Illinois.
email to: a-tuchman@uiuc.edu.
