/* index.c
   processing for full index search support */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.1     20 April 1991                  */
     /*                version 1.0     04 March 1991                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing Services Office                      */
     /* Copyright 1992 by                                             */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/


#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/AsciiText.h>

#include "index.h"
#include "gui.h"

#define INDEX_SHELL_TITLE	"Index Search"


static	Widget		topLevel;
static	Widget		indexShell,
			queryText, doIndexButton,
			indexLabel;
static	Boolean		indexPanelCreated = False;
static	XtPointer	savedItem;



/* helpProc
   provide help for a index search session */

static void
helpProc(w, clientData, callData)
Widget		w;
XtPointer	clientData, callData;
{
	showHelp("index help");
}


/* doIndexProc
   submit a query to an index search */

static void
doIndexProc(w, clientData, callData)
Widget		w;
XtPointer	clientData, callData;
{
	Cardinal	n;
	Arg		args[3];
	char		*string, *s;
	int		length;
	Boolean		inPlace;


	n=0;
	XtSetArg(args[n], XtNstring, &s);  n++;
	XtGetValues(queryText, args, n);
	length = strlen(s);

	string = XtMalloc(length + 1);
	strncpy (string, s, length);
	string[length] = '\0';

	if (strlen(string) == 0) {
		showError("Enter a query string.");
	} else {

		XtRemoveAllCallbacks(doIndexButton, XtNcallback);
		/* do Index */
		XtPopdown(indexShell);

		processIndexSelection(clientData, string);
	}

}


/* cancelProc
   cancel a index search session */

static void
cancelProc(w, clientData, callData)
Widget		w;
XtPointer	clientData, callData;
{
	Cardinal	n;
	Arg		args[3];

	XtRemoveAllCallbacks(doIndexButton, XtNcallback);
	XtPopdown(indexShell);
}


/* IndexOk
   accept the "do Index" action from a keyboard <cr> instead of the
   "do Index" button.  The <cr> translation is defined elsewhere.
   Capitalized name is for X action proc convention. */

static void
IndexOk(w, event, parms, nparms)
Widget          w;
XEvent          *event;
String          *parms;
Cardinal        *nparms;
{
        doIndexProc(w, savedItem, NULL);
        return;
}


/* displayIndexPanel
   display the panel for index search queries */

void
displayIndexPanel(clientData, title)
XtPointer	clientData;
char		*title;
{
	Arg		args[10];
	Cardinal	n;
	char		titleString[128];


	sprintf (titleString, "Search of:  %.60s\n", title);
	n=0;
	XtSetArg(args[n], XtNlabel, titleString);  n++;
	XtSetValues(indexLabel, args, n);

	XtAddCallback(doIndexButton, XtNcallback, doIndexProc, clientData);
	savedItem = clientData;

	/* position at the top of the main panel, centered across */

	positionPopup(indexShell, POS_appPanel, topLevel, 50, 0, 1, 0);

	XtPopup (indexShell, XtGrabNone);


	return;
}


/* makeIndexPanel
   create the X panel for Index Search queries */

void
makeIndexPanel(top)
Widget	top;
{
	Arg		args[10];
	Cardinal	n;
	Widget		indexForm;
	Widget		cancelButton, helpButton;
	static XtActionsRec     indexActionsTable[] = {
					{ "indexok", (XtActionProc) IndexOk }
					};


	if (indexPanelCreated) return;

	topLevel = top;


	/* create Index Search shell */

		n=0;
		XtSetArg(args[n], XtNtitle, INDEX_SHELL_TITLE);  n++;
	indexShell = XtCreatePopupShell("indexShell",
				topLevelShellWidgetClass,
				topLevel, args, n);


	/* create Index Search main panel form */

		n=0;
	indexForm  = XtCreateManagedWidget("indexForm",
				formWidgetClass,
				indexShell, args, n);
	

	/* create INDEX label */

		n=0;
	indexLabel = XtCreateManagedWidget("indexLabel",
				labelWidgetClass,
				indexForm, args, n);


	/* create DO QUERY button */

		n=0;
	doIndexButton = XtCreateManagedWidget("indexDoIndex",
				commandWidgetClass,
				indexForm, args, n);


	/* create CANCEL button */

		n=0;
	cancelButton = XtCreateManagedWidget("indexCancel", commandWidgetClass,
				indexForm, args, n);
		XtAddCallback(cancelButton, XtNcallback, cancelProc, NULL);


	/* create HELP button */

		n=0;
	helpButton = XtCreateManagedWidget("indexHelp", commandWidgetClass,
				indexForm, args, n);
		XtAddCallback(helpButton, XtNcallback, helpProc, NULL);


	/* create NAME TEXT entry */

		n=0;
		XtSetArg(args[n], XtNeditType, XawtextEdit);  n++;
		XtSetArg(args[n], XtNstring, "");  n++;
	queryText = XtCreateManagedWidget("indexQueryText",
				asciiTextWidgetClass,
				indexForm, args, n);
		setTextWidgetSize(queryText, 60, 1);

	XtAddActions(indexActionsTable, XtNumber(indexActionsTable));

	indexPanelCreated = True;
}
