/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/cdc/RCS/check_res_apdu.c,v $
 *
 *
 *  MODULE NAME:    check_res_apdu.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <syslog.h>
#include "SPHINX-types.h"
#include "cdc.h"

#define NOT_REGISTERED       -5

int check_login_res_apdu(rpkt_dat, rpkt_len, logininfo, len_p, debugflag)
char  *rpkt_dat;
int   rpkt_len;
char  *logininfo;
int   *len_p;
int   debugflag;
{
  struct type_SPHINX_CDCAPDU  *cdc_response;
  struct type_SPHINX_ReadPrinLoginResponse  *loginres;
  char   *tmp_logininfo;
  int    result, explicit, cdc_resplen, status, j, logininfolen;
  PE     cdc_res_apdu_pe;

  if (!(cdc_res_apdu_pe=ssdu2pe(rpkt_dat, rpkt_len, 0, &result)))
    return(CDC_CHECK_RES_ERROR);

  explicit = 1;
  if (decode_SPHINX_CDCAPDU(cdc_res_apdu_pe, explicit, &cdc_resplen, NULLCP, &cdc_response) == NOTOK)
    return(CDC_CHECK_RES_ERROR);

  if (cdc_response->offset != type_SPHINX_CDCAPDU_readPrinLoginResponse) {
    if (cdc_response->offset == type_SPHINX_CDCAPDU_errorResponse) {
      status = cdc_response->un.errorResponse->parm;
    } else status = CDC_CHECK_RES_UNKNOWN;
    free_SPHINX_CDCAPDU(cdc_response);
    return(status);
  }

  loginres = cdc_response->un.readPrinLoginResponse;
  status = loginres->status->parm;

  if (status == 0) {
    tmp_logininfo = bitstr2strb(loginres->loginInfo, &j);
    logininfolen = (j + 7)/8;
    bcopy(tmp_logininfo, logininfo, logininfolen);
    *len_p = logininfolen;
  } else {
    syslog(LOG_INFO, "check_login_res rets %d (error) w/ readPrinLoginResponse", status);
    j = 0;
    *len_p = j;
  }

  return(status);
}

int check_certif_res_apdu(rpkt_dat, rpkt_len, certifpath, debugflag)
char *rpkt_dat;
int  rpkt_len;
struct type_SPHINX_CertPath  **certifpath;
int   debugflag;
{
  struct type_SPHINX_CDCAPDU  *cdc_response;
  struct type_SPHINX_ReadPrinCertResponse  *certres;
  int    result, explicit, cdc_resplen, status;
  PE     cdc_res_apdu_pe;

  if (!(cdc_res_apdu_pe=ssdu2pe(rpkt_dat, rpkt_len, 0, &result)))
    return(CDC_CHECK_RES_ERROR);

  explicit = 1;
  if (decode_SPHINX_CDCAPDU(cdc_res_apdu_pe, explicit, &cdc_resplen, NULLCP, &cdc_response) == NOTOK)
    return(CDC_CHECK_RES_ERROR);

  if (cdc_response->offset != type_SPHINX_CDCAPDU_readPrinCertResponse) {
    if (cdc_response->offset == type_SPHINX_CDCAPDU_errorResponse) {
      status = cdc_response->un.errorResponse->parm;
    } else status = CDC_CHECK_RES_UNKNOWN;
    free_SPHINX_CDCAPDU(cdc_response);
    return(status);
  }

  certres = cdc_response->un.readPrinCertResponse;
  status = certres->status->parm;

  if (status == 0)
    *certifpath = certres->certPath;
  else {
    *certifpath = NULL;
    syslog(LOG_INFO, "check_certif_res rets %d (error) w/ readPrinCertResponse", status);
  }

  return(status);
}

int check_tacertif_res_apdu(rpkt_dat, rpkt_len, index, certifpath, debugflag)
char  *rpkt_dat;
int   rpkt_len;
int   *index;
struct type_SPHINX_CertPath  **certifpath;
int   debugflag;
{
  struct type_SPHINX_CDCAPDU  *cdc_response;
  struct type_SPHINX_ReadTACertResponse  *certres;
  int    result, explicit, cdc_resplen, status;
  PE     cdc_res_apdu_pe;

  if (!(cdc_res_apdu_pe=ssdu2pe(rpkt_dat, rpkt_len, 0, &result)))
    return(CDC_CHECK_RES_ERROR);

  explicit = 1;
  if (decode_SPHINX_CDCAPDU(cdc_res_apdu_pe, explicit, &cdc_resplen, NULLCP, &cdc_response) == NOTOK)
    return(CDC_CHECK_RES_ERROR);

  if (cdc_response->offset != type_SPHINX_CDCAPDU_readTACertResponse) {
    if (cdc_response->offset == type_SPHINX_CDCAPDU_errorResponse) {
      status = cdc_response->un.errorResponse->parm;
    } else status = CDC_CHECK_RES_UNKNOWN;
    free_SPHINX_CDCAPDU(cdc_response);
    return(status);
  }

  certres = cdc_response->un.readTACertResponse;
  status = certres->status->parm;

  if (status == 0) {
    if (certres->optionals == opt_SPHINX_ReadTACertResponse_index)
      *index = certres->index;
    else *index = 0;
    *certifpath = certres->certPath;
  } else {
    *index = 0;
    *certifpath = NULL;
    syslog(LOG_INFO, "check_tacertif_res rets %d (error) w/ readTACertResponse", status);
  }

  return(status);
}
