/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/auth/RCS/key_from_certif.c,v $
 *
 *
 *  MODULE NAME:    key_from_certif.c
 *
 *
 *  AUTHORS:
 *
 *      J. Tardo
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <ctype.h>
#include "SPHINX-types.h"
#include "BigZ.h"
#include "BigRSA.h"

#define BIGBUFFER_SIZE  1000

/*
 * Extract subject public key from certificate
 */
int key_from_certif(cinfo,key)
struct type_SPHINX_CertifInfo *cinfo;
RSAKeyStorage *key;
{
  int keysize;
  char *encodedkey;
  struct type_SPHINX_SubjectPublicKeyInfo *pubkey;

  if(((pubkey=cinfo->subjectPublicKey)==NULL) ||
     ((encodedkey=prim2str(pubkey->subjectPublicKey, &keysize))==NULL) ||
     (DecodePublic(encodedkey+1,key)==NULL)) {
#ifdef DEBUG
printf("\n%s: Error recovering public key.\n", __FILE__);
#endif
       return(0);
  }
  return(1);
}

/*
 * Extract uid's if 1992 certificate
 */
int uid_from_certif(cinfo,iuid,iuidlen,suid,suidlen)
struct type_SPHINX_CertifInfo *cinfo;
unsigned char *iuid,*suid;
int *iuidlen,*suidlen;
{
  char *temp;
  int i;
  
  if ((cinfo->version != NULL) && (cinfo->version->parm == int_SPHINX_Version_v1992)) {

    temp = prim2str(cinfo->issuerUID, &i);
    if (i>1) { 
        i--;
        memcpy(iuid,temp+1,i);
        free(temp); 
    }
    else i=0;
    *iuidlen = i;

    temp = prim2str(cinfo->subjectUID, &i);
    if (i>1) { 
        i--;
        memcpy(suid,temp+1,i);
        free(temp); 
    }
    else i=0;
    *suidlen = i;

    return(1);
  }
  else return(0);
}


