/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/api/RCS/spxapi.c,v $
 *
 *
 *  MODULE NAME:    spxapi.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <sys/types.h>
#include <syslog.h>
#include <pwd.h>
#include "cdc.h"
#include "cdc_db.h"
#include "SPHINX-types.h"
#include "BigNum.h"
#include "BigRSA.h"
#include "random.h"
#include "objid.h"
#include "spxapi_defs.h"
#include "gssapi_defs.h"

/*
 * Jacket routines offering "SPX" API
 */

static char gss_error_buf[255];

/*
 * spx_make_response() - 
 *
 *   int *minor_status  (output) - returned mechanism dependent status
 *   int claimant_cred_handle (input) - claimant credential handle
 *   int context_handle (input) _ context handle
 *   char *input_token  (input)  -  input token pointer
 *   int  input_tokenlen (input) -  input token length
 *   char *output_token (output) - output token pointer (GSS_MAX_TOKEN_SZ buf)
 *   int  output_tokenlen (output) - output token length
 *
 */

int spx_make_response(minor_status, claimant_cred_handle, context_handle,
	output_token, output_tokenlen)
int   *minor_status;
gss_cred_id_t   claimant_cred_handle;
gss_ctx_id_t    context_handle;
char  *output_token;
int   *output_tokenlen;
{
  int status, deleg_flag, token_len = 0;
  SPXCredentials  *gsscred;
  SPXContextHandle  *gssctxhandle;
  ContextHandle   *ctxhandle = NULL;
  char *spx_cred_handl, *spx_ta_cred_handl;
  struct passwd   *pwd;

  if (claimant_cred_handle == NULL) {
    /*
     * acquire default credentials for user
     */
    pwd = getpwuid(getuid());
    if (pwd == 0) return(GSS_S_NO_CRED);
    gsscred = (SPXCredentials *) malloc(sizeof(SPXCredentials));
    status = Sphinx_Acquire_cred(pwd->pw_name,
				 NULL,
				 GSS_C_INITIATE,
				 &spx_cred_handl,
				 &spx_ta_cred_handl,
				 0);
    *minor_status = status;
    if (status < 0)  return(GSS_S_NO_CRED);
    gsscred->clm_handle = (ClaimantCred *) spx_cred_handl;
    gsscred->ver_handle = (VerifierCred *) NULL;
    gsscred->ta_handle = (TrustedCred *) spx_ta_cred_handl;
    bzero(gsscred->credential_file, sizeof(gsscred->credential_file));
    gss_default_credentials = (void *) gsscred;
  } else gsscred = (SPXCredentials *) claimant_cred_handle;

  if (gssctxhandle != NULL) {
    gssctxhandle = (SPXContextHandle *) context_handle;
    ctxhandle = (ContextHandle *) gssctxhandle->context_handle;
  } else ctxhandle = (ContextHandle *) NULL;

  status = Sphinx_make_response(gsscred->clm_handle,
				gsscred->ta_handle,
				ctxhandle,
				output_token,
				&token_len);
  *minor_status = status;
  *output_tokenlen = token_len;

/*
  if (status == SPX_S_CLAIM_UNABLE_TO_ACCESS_CDC)
    return(GSS_S_CONTINUE_NEEDED);
*/

  if (status != 1)
    return(GSS_S_FAILURE);

  return(GSS_S_COMPLETE);
}

/*
 * spx_verify_response() - 
 *
 *   int *minor_status  (output) - returned mechanism dependent status
 *   int context_handle (input) _ context handle
 *   int verifier_cred_handle (input) - verifier credential handle
 *   char *input_token  (input)  -  input token pointer
 *   int  input_tokenlen (input) -  input token length
 *
 */

int spx_verify_response(minor_status, context_handle,
	 verifier_cred_handle, input_token, input_tokenlen)
int   *minor_status;
int   context_handle;
int   verifier_cred_handle;
char  *input_token;
int   input_tokenlen;
{
  int status, len, token_len;
  SPXCredentials *gsscred;
  SPXContextHandle *gssctxhandle;
  ContextHandle  *ctxhandle = NULL;

  if (verifier_cred_handle == 0) return(GSS_S_DEFECTIVE_CREDENTIAL);
  gsscred = (SPXCredentials *) verifier_cred_handle;
  gssctxhandle = (SPXContextHandle *) context_handle;
  ctxhandle = (ContextHandle *) gssctxhandle->context_handle;

  status = Sphinx_verify_response(ctxhandle,
				  gsscred->ver_handle,
				  gsscred->ta_handle,
				  input_token,
				  input_tokenlen);
  *minor_status = status;
  if (status != 1) {
    return(GSS_S_FAILURE);
  }
  return(GSS_S_COMPLETE);
}
