/*
C
C  _______________________________________________________________
C
C*   Licence
C    =======
C
C    You may use or modify this code for your own non commercial
C    purposes for an unlimited time. 
C    In any case you should not deliver this code without a special 
C    permission of ZIB.
C    In case you intend to use the code commercially, we oblige you
C    to sign an according licence agreement with ZIB.
C
C
C  _______________________________________________________________
C
*/

#include <stdio.h>
#include <math.h>

#include "kask.h"
#include "kaskcmd.h"
#include "kasktri.h"
#include "kaskgraph.h"
#include "kaskass.h"

GRAPHIC *NewGraph();
DRIVER  *PSDriver();

GRAPHIC *actGraph = nil;
DRIVER *actDriver = nil;
int errorPlot = 0;

static char *oneBlank = " ";
static GRAPHIC *newG;


static int ErrorP(p)
  PT *p;
  {
    (actProblem->Sol)(p->x,p->y,p->class,actProblem->solVals);
    RA(p,R_RES) = RA(p,R_SOL)-(actProblem->solVals)[0];
    return true;
  }

int Graphic(cmd)
  COMMAND *cmd;
  {
	int index, rc, k, lev;
	float from, to, by;
	char *tp;

	if (ParsCheck(cmd, 0, 99)) return false;

	if (actTriang==nil)
	  { ZIBStdOut("Graph: no triangulation - no graphic\n"); return false; }

	if (actGraph==nil)
	  actGraph = NewGraph();
	if (actGraph==nil) return false;
	errorPlot = false;

	if ((cmd->noOfPars)==0)			/* informing */
	  {
	    ZIBStdOut("Graph: graphic settings:\n");
		sprintf(globBuf, "Graph:     triangulation rectangle (%.3f,%.3f,%.3f,%.3f)",
				actGraph->maxBottom, actGraph->maxLeft,
				actGraph->maxTop, actGraph->maxRight);
		ZIBStdOut(globBuf);

		if (((actGraph->bottom)!=(actGraph->maxBottom))||
			((actGraph->left)!=(actGraph->maxLeft))||
			((actGraph->top)!=(actGraph->maxTop))||
			((actGraph->right)!=(actGraph->maxRight)))
		  {
			sprintf(globBuf, "Graph:     clipping (%.3f,%.3f,%.3f,%.3f)",
					actGraph->bottom, actGraph->left,
					actGraph->top, actGraph->right);
			ZIBStdOut(globBuf);
		  }

		globBuf[0] = NUL;
		if (actGraph->boundary)
		  { strcat(globBuf, (cmd->names)[0]); strcat(globBuf, oneBlank); }
		if (actGraph->level)
		  { strcat(globBuf, (cmd->names)[1]); strcat(globBuf, oneBlank); }
		if (actGraph->triangulation)
		  { strcat(globBuf, (cmd->names)[2]); strcat(globBuf, oneBlank); }
		if (actGraph->index)
		  { strcat(globBuf, (cmd->names)[3]); strcat(globBuf, oneBlank); }
		if (actGraph->points)
		  { strcat(globBuf, (cmd->names)[4]); strcat(globBuf, oneBlank); }
		if (actGraph->temperature)
		  { strcat(globBuf, (cmd->names)[5]); strcat(globBuf, oneBlank); }
		if (actGraph->layer)
		  { strcat(globBuf, (cmd->names)[9]); strcat(globBuf, oneBlank); }
		if (globBuf[0]==NUL) { globBuf[0] = '-', globBuf[1] = NUL; }
		ZIBStdOut("Graph:     to draw ");
		ZIBStdOut(globBuf);

		sprintf(globBuf, "\nGraph:     %d levels\n", actGraph->levels);
		ZIBStdOut(globBuf);

		return true;
	  }

	for (k = 1; k<=(cmd->noOfPars); k++)
	  {
		tp = (cmd->pars)[k];
		index = CheckName(&tp, cmd->names, nameClass);
		if (index==-1)
		  {
		    sprintf(globBuf, "Graph: '%s' unknown parameter to %s\n",
					(cmd->pars)[k], (cmd->pars)[0]);
			ZIBStdOut(globBuf);
			return false;
		  }
		switch (index)
		{
		  case 0:
		          actGraph->boundary = true;
				  break;
		  case 1:
		          actGraph->level = true;
				  break;
		  case 2:
			      actGraph->triangulation = true;
				  break;
		  case 3:
		          actGraph->index = true;
				  break;
		  case 4:
		          actGraph->points = true;
				  break;
		  case 5:
		          actGraph->temperature = true;
				  break;
		  case 6:								/* clipping */
		          if ((cmd->noOfPars)==k)
				    {
					  actGraph->bottom = actGraph->maxBottom;
					  actGraph->left = actGraph->maxLeft;
					  actGraph->top = actGraph->maxTop;
					  actGraph->right = actGraph->maxRight;
					}
				  else
					{
					  rc = sscanf((cmd->pars)[k+1], "(%e,%e,%e,%e)",
					  			  &(actGraph->bottom), (&actGraph->left),
								  &(actGraph->top), &(actGraph->right));
					  if (rc!=4)
					    {
						  sprintf(globBuf, "Graph: syntax error reading clipping '%s'\n",
						  		  (cmd->pars)[k+1]);
						  ZIBStdOut(globBuf);
						  return false;
						}
					  k++;
					}
				  break;
		  case 7:								/* levels */
		          if ((cmd->noOfPars)==k) lev = 7;
				  else
					{
					  rc = sscanf((cmd->pars)[k+1], "%d",
					  			  &lev);
					  if (rc!=1)
					    {
						  sprintf(globBuf, "Graph: syntax error reading number of level lines '%s'\n",
						  		  (cmd->pars)[k+1]);
						  ZIBStdOut(globBuf);
						  return false;
						}
					  k++;
					}
  				  if ((lev<(actGraph->levels))
					  &&((actGraph->levelsAt)!=nil))
  				    {
					  ZIBFree((PTR)(actGraph->levelsAt));
					  actGraph->levelsAt = nil;
					}
   				  (actGraph->levels) = lev;
				  break;
		  case 8:								/* clear */
		          actGraph->boundary = false;
	 	    	  actGraph->level = false;
	 	          actGraph->triangulation = false;
	 	          actGraph->index = false;
	 	          actGraph->points = false;
	  	   		  actGraph->temperature = false;
	  	   		  actGraph->layer = false;
	 	          actGraph->ddd = false;
	 	          actGraph->cut = false;
				  break;
		  case 9:								/* layer */
		          actGraph->layer = true;
				  break;
		  case 10:								/* 3D */
		          actGraph->boundary = false;
	 	    	  actGraph->level = false;
	 	          actGraph->triangulation = false;
	 	          actGraph->index = false;
	 	          actGraph->points = false;
	  	   		  actGraph->temperature = false;
	 	          actGraph->ddd = true;
		          if ((cmd->noOfPars)==k)
				    {
					  actGraph->rotX = 0.0;
					  actGraph->rotY = 0.0;
					  actGraph->rotZ = 0.0;
					}
				  else
					{
					  rc = sscanf((cmd->pars)[k+1], "(%e,%e,%e)",
					  			  &(actGraph->rotX), &(actGraph->rotY),
								  &(actGraph->rotZ));
					  if (rc!=3)
					    {
						  sprintf(globBuf, "Graph: syntax error reading number of level lines '%s'\n",
						  		  (cmd->pars)[k+1]);
						  ZIBStdOut(globBuf);
						  return false;
						}
					  k++;
					}
				  break;
		  case 11:								/* cut */
		          actGraph->boundary = false;
	 	    	  actGraph->level = false;
	 	          actGraph->triangulation = false;
	 	          actGraph->index = false;
	 	          actGraph->points = false;
	  	   		  actGraph->temperature = false;
	  	   		  actGraph->ddd = false;
	 	          actGraph->cut = true;
		          if ((cmd->noOfPars)==k)
				    {
					  actGraph->cutX1 = actGraph->maxLeft;
					  actGraph->cutY1 = actGraph->maxBottom;
					  actGraph->cutX2 = actGraph->maxRight;
					  actGraph->cutY2 = actGraph->maxTop;
					}
				  else
					{
					  rc = sscanf((cmd->pars)[k+1], "(%e,%e,%e,%e)",
					  			  &(actGraph->cutX1),&(actGraph->cutY1),
								  &(actGraph->cutX2),&(actGraph->cutY2));
					  if (rc!=4)
					    {
						  sprintf(globBuf, "Graph: syntax error reading number of level lines '%s'\n",
						  		  (cmd->pars)[k+1]);
						  ZIBStdOut(globBuf);
						  return false;
						}
					  k++;
					}
				  break;
		  case 12:								/* percentage */
		          actGraph->percentage = true;
				  break;
		  case 13:								/* levelsAt */
		          if ((cmd->noOfPars)==k)
				    {
					  sprintf(globBuf, "Missing value for %s\n",
					  			(cmd->pars)[k]);
					  ZIBStdOut(globBuf);
					  return false;
					}
				  rc = sscanf((cmd->pars)[k+1], "(%e,%e)%e", &from,
					  			  &to, &by);
				  if (rc!=3)
				    {
					  sprintf(globBuf, "Graph: syntax error reading number of level lines '%s'\n",
						  	  (cmd->pars)[k+1]);
					  ZIBStdOut(globBuf);
					  return false;
					}
				  k++;
				  lev = (to-from)/by+1.0;
   				  if ((actGraph->levelsAt)!=nil)
				    {
					  ZIBFree((PTR)(actGraph->levelsAt));
					  actGraph->levelsAt = nil;
				    }
   				  if ((actGraph->levelsAt)==nil)
				    actGraph->levelsAt = 
						(REAL*)ZIBAlloc((long)(lev*sizeof(REAL)));
   				  if ((actGraph->levelsAt)==nil)
				    {
					  ZIBStdOut("Not enough memory(levelsAt)\n");
					  return false;
					}
				  (actGraph->levels) = lev;				  
				  for (lev = 0; lev<(actGraph->levels); lev++)
				    {
					  (actGraph->levelsAt)[lev] = from;
					  from += by;
					}
				  break;
		  case 14:								/* errors */
                  ApplyP(ErrorP,all);
                  errorPlot = true;
                  break;
		}
	  }
	return true;
  }

int MaxMin(p)
  PT *p;
  {
    if ((p->x)<(newG->maxLeft)) newG->maxLeft = p->x;
    if ((p->x)>(newG->maxRight)) newG->maxRight = p->x;
    if ((p->y)<(newG->maxBottom)) newG->maxBottom = p->y;
    if ((p->y)>(newG->maxTop)) newG->maxTop = p->y;
    return true;
  }
 
GRAPHIC *NewGraph()
  {
    newG = (GRAPHIC*) ZIBAlloc((long)sizeof(GRAPHIC));
	if (newG==nil) { ZIBStdOut("Graph: not enough memory (NewGraph)\n"); return nil; }

	newG->maxBottom = RMAX;
	newG->maxLeft = RMAX;
	newG->maxTop = RMIN;
	newG->maxRight = RMIN;
	ApplyP(MaxMin, all);

	newG->rotX = 0.0;
	newG->rotY = 0.0;
	newG->rotZ = 0.0;

	newG->cutX1 = newG->maxBottom;
	newG->cutY1 = newG->maxLeft;
	newG->cutX2 = newG->maxTop;
	newG->cutY2 = newG->maxRight;

	newG->bottom = newG->maxBottom;
	newG->left = newG->maxLeft;
	newG->top = newG->maxTop;
	newG->right = newG->maxRight;

	newG->boundary = false;
	newG->level = false;
	newG->triangulation = false;
	newG->index = false;
	newG->points = false;
	newG->temperature = false;
	newG->layer = false;
    newG->ddd = false;
    newG->cut = false;
	newG->levels = 7;
	newG->percentage = false;
	newG->levelsAt = nil;

	return newG;
  }

int ShowGraph(cmd)
  COMMAND *cmd;
  {
	int index, continueP = false, frameP = true, k;
	char *tp;
	DRIVER *d = actDriver;

	if (ParsCheck(cmd, 0, 3)) return false;

	if (actTriang==nil)
	  { ZIBStdOut("Graph: no triangulation - no graphic\n"); return false; }

	if (actGraph==nil)
	  {
	    actGraph = NewGraph();
		if (actGraph==nil) return false;
		actGraph->boundary = true;
		actGraph->triangulation = true;
	  }

	for (k = 1; k<=(cmd->noOfPars); k++)
	  {
		tp = (cmd->pars)[k];
		index = CheckName(&tp, cmd->names, nameClass);
		if (index==-1)
		  {
		    sprintf(globBuf, "Graph: '%s' unknown parameter to %s\n",
					(cmd->pars)[k], (cmd->pars)[0]);
			ZIBStdOut(globBuf);
			return false;
		  }
		switch (index)
		{
		  case 0:
		          actDriver = PSDriver();
				  break;
		  case 1:
		          continueP = true;
				  break;
		  case 2:
		          frameP = false;
				  break;
		}
	  }
	if (actDriver==nil)
	  { ZIBStdOut("Graph: no driver available\n"); return false; }

	(actDriver->NewPict)();
    if (frameP) DrawFrame();
    if (actGraph->triangulation)      DrawTri();
    if (actGraph->temperature)        DrawTemp();
    if (actGraph->level)              DrawSol();
    if (actGraph->points)             DrawPoint();
    if (actGraph->index)              DrawIndex();
    if (actGraph->boundary)           DrawBound();
    if (actGraph->ddd)                Draw3D();
    if (actGraph->cut)                DrawCut();
	if (!continueP) (actDriver->Show)();

	actDriver = d;
	return true;
  }
