//$$ newmatap.hxx         definition file for matrix package applications

// Copyright (C) 1991: R B Davies and DSIR

#ifndef MATRIXAP_LIB
#define MATRIXAP_LIB 0

#include "newmat.hxx"


/**************************** applications *****************************/


void HHDecompose(Matrix&, LowerTriangularMatrix&);

void HHDecompose(const Matrix&, Matrix&, Matrix&);

ReturnMatrix Cholesky(const SymmetricMatrix&);

void SVD(const Matrix&, DiagonalMatrix&, Matrix&, Matrix&,
    BOOL=(BOOL)TRUE, BOOL=(BOOL)TRUE);

void SVD(const Matrix&, DiagonalMatrix&);

inline void SVD(const Matrix& A, DiagonalMatrix& D, Matrix& U,
   BOOL withU = (BOOL)TRUE)
   { SVD(A, D, U, U, withU, FALSE); }

void Jacobi(const SymmetricMatrix&, DiagonalMatrix&);

void Jacobi(const SymmetricMatrix&, DiagonalMatrix&, SymmetricMatrix&);

void Jacobi(const SymmetricMatrix&, DiagonalMatrix&, Matrix&);

void Jacobi(const SymmetricMatrix&, DiagonalMatrix&, SymmetricMatrix&,
   Matrix&, BOOL=(BOOL)TRUE);

void EigenValues(const SymmetricMatrix&, DiagonalMatrix&);

void EigenValues(const SymmetricMatrix&, DiagonalMatrix&, SymmetricMatrix&);

void EigenValues(const SymmetricMatrix&, DiagonalMatrix&, Matrix&);

class SymmetricEigenAnalysis
{
public:
   SymmetricEigenAnalysis(const SymmetricMatrix&);
private:
   DiagonalMatrix diag;
   DiagonalMatrix offdiag;
   SymmetricMatrix backtransform;
};

void SortAscending(GeneralMatrix&);

void SortDescending(GeneralMatrix&);


void FFT(const ColumnVector&, const ColumnVector&,
   ColumnVector&, ColumnVector&);


#endif
