/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  _basic.c
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#include <LEDA/basic.h>

#include <time.h>
#include <string.h>
#include <sys/types.h>

#if defined(__MSDOS__)
#include <dos.h>
#else
#include <sys/times.h>
#endif


const char* leda_version_string = 
  "LEDA 2.2 (c) 1992  Max-Planck-Institut fuer Informatik, Saarbruecken, FRG";


LEDA_INIT L_E_D_A;


LEDA_INIT::LEDA_INIT()
{ init_list = getenv("LEDA_INIT");
  if (init_list) fprintf(stderr,"\n%s\n\n",leda_version_string);
  fflush(stderr);
  init_random();
 }


LEDA_INIT::~LEDA_INIT() 
{ 
  if (init_list && strcmp(init_list,"statistics")==0) print_statistics(); 
 } 


//------------------------------------------------------------------------------
// bool
//------------------------------------------------------------------------------

#ifndef __MSDOS__

const bool false = 0;
const bool true  = 1;

#endif



//------------------------------------------------------------------------------
// Error Handling
//------------------------------------------------------------------------------


PEH p_error_handler = default_error_handler;

void default_error_handler(int i, char* s)
{ if (i==0) 
   cout << "(warning) " << s << "\n";
  else 
   { cout << "ERROR "<< s << "\n";
     cout.flush();
     abort();
    }
}

PEH set_error_handler(PEH handler)
{ PEH old = error_handler;
  p_error_handler = handler;
  return old;
}

//------------------------------------------------------------------------------
// usefull functions
//------------------------------------------------------------------------------

int interrupt_handler()
{ string cmd;

  cout << "\n INTERRUPT \n";

  for(;;) 
  { newline;
    cmd=read_string("m(emory) / t(ime) / !(cmd) / c(ontinue) / i(nterrupt): ");
    switch(cmd[0]) 
     { case 'c': { cout << "execution continued\n";
                   return(0);
                  }
       case 'i': { cout << "execution terminated\n";
                   exit(1);
                  }
       case 'm': { print_statistics(); 
                   newline;
                   break;
                  }
       case 't': { newline;
                   print_time();
                   break;
                  }
       case '!': { cmd[0] = ' ';
                   system(cmd.cstring());
                   newline;
                   break;
                  }
      }
    }
}







#if defined(__MSDOS__) 

void init_random(int seed)
{ long l = seed;
  if (l==0) time(&l);
  srand(int(l));
 }

int random(int a, int b)  
{ return a + rand()%(b-a+1); }

unsigned random(unsigned a, unsigned b)  
{ return a + unsigned(rand())%(b-a+1); }

double rrandom() 
{ return double(rand())/MAXINT; }

#if defined(__GNUG__)
float used_time() { return 0; }   // djgpp
#else
float used_time() { return  float(clock())/CLK_TCK; }
#endif

float used_time(float& T)
{ float t = T;
  T =  used_time();
  return  T-t;
}

void print_time(string s)
{ cerr << s;
  cerr << string("user time: %.2f sec   system time: 0.0 sec \n",used_time());
}

#else

void init_random(int seed)
{ long l = seed;
  if (l==0) time(&l);
  srandom(int(l));
 }

int random(int a, int b)  
{ return a + random()%(b-a+1); }

unsigned random(unsigned a, unsigned b)  
{ return a + unsigned(random())%(b-a+1); }

double rrandom()  
{ return double(random())/MAXINT; }


float used_time()
{ tms x;
  times(&x);
  return  float(x.tms_utime)/60;
}

float used_time(float& T)
{ float t = T;
  tms x;
  times(&x);
  T =  float(x.tms_utime)/60;
  return  float(T)-t;
}

void print_time(string s)
{
  tms x;
  times(&x);
  float ut = float(x.tms_utime)/60;
  float st = float(x.tms_stime)/60;
  cerr << s;
  cerr << string("user time: %.2f sec   system time: %.2f sec \n",ut,st);
}

#endif


void wait(unsigned int sec) { sleep(sec); }
  

//------------------------------------------------------------------------------
// Input/Ouput
//------------------------------------------------------------------------------


int Yes(string s)
{ char answer = read_char(s);
  return ((answer == 'y') || (answer == 'Y'));
}

int read_int(string s)
{ int answer;
  char c;
  int success = 0;
  while (!success)
  { cout << s;
    cin >> answer;
    if (!cin) { cin.clear();
                cin.get(c);
                cout << string("read_int: illegal input \"%c\"\n",c);
                while (c!='\n') cin.get(c); //skip rest of line
               }
    else  success=1;
   }
  cin.get(c);   // eat '\n'

  return answer;
}

char read_char(string s)
{ char c;
  cout << s;
  cin.get(c);
  if (c!='\n') read_line(cin);
  return c;
}

double read_real(string s)
{ double answer;
  cout << s;
  cin >> answer;
  read_line(cin);
  return answer;
}

char*  read_line(istream& s)
{ char buf[256];
  char* p = buf;

  while (s.get(*p))
  { if (*p == '\n') break;
    p++;
   } 
  *p = '\0';
  return ~string(buf);
}

char*  read_string(string s)
{ cout << s;
  return read_line(cin); 
 }

int     Yes()              { return Yes(""); }
int     read_int()         { return read_int(""); }
char    read_char()        { return read_char(""); }
double  read_real()        { return read_real(""); }
char*   read_string()      { return read_string(""); } 
char*   read_line()        { return read_line(cin); }

