/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  ugraph.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/



#ifndef UGRAPH_H
#define UGRAPH_H

#include <LEDA/graph.h>


//-----------------------------------------------------------------------------
// ugraph: base class for all undirected graphs
//-----------------------------------------------------------------------------

class ugraph : public graph{

#ifdef __ZTC__
public:
#else
protected:
#endif

edge new_edge(node,node,GenPtr);
edge new_edge(node,node,edge,edge,GenPtr,int=0,int=0);


public:

edge new_edge(node v, node w)
{ GenPtr x; init_edge_entry(x);
  return new_edge(v,w,x);
 }

edge new_edge(node v, node w, edge e1 ,edge e2, int dir1=0,int dir2=0)
{ GenPtr x; init_edge_entry(x);
  return new_edge(v,w,e1,e2,x,dir1,dir2);
 }

list(node) adj_nodes(node) const;

node opposite(node v, edge e)  const;

int  degree(node v)     const  { return v->adj_edges.length(); }

edge adj_succ(edge e,node v) const;
edge adj_pred(edge e,node v) const;
edge cyclic_adj_succ(edge e,node v) const;
edge cyclic_adj_pred(edge e,node v) const;

void print_edge(edge, ostream& = cout) const;

void read(string s) { graph::read(s); make_undirected(); } 

ugraph()  { undirected = true; }

ugraph(const graph& a): graph(a) { undirected = true; make_undirected(); }

ugraph(const ugraph& a) : graph((graph&)a)  { undirected = true;  }

~ugraph() { /* ~graph does the job */ }

//subgraph constructors
ugraph(ugraph&, const list(node)&, const list(edge)&);
ugraph(ugraph&, const list(edge)&);

ugraph& operator=(const ugraph& a) 
                               { return (ugraph&)graph::operator=((graph&)a); }

ugraph& operator=(const graph& a)  { graph::operator=(a); 
                                     make_undirected();
                                     return (ugraph&)(*this);
                                    }

};


//------------------------------------------------------------------------------
// UGRAPH: generic ugraphs
//------------------------------------------------------------------------------

#define UGRAPH(vtype,etype)  name3(vtype,etype,UGRAPH)

#define UGRAPHdeclare2(vtype,etype)\
\
class UGRAPH(vtype,etype) : public ugraph {\
\
vtype name2(vtype,X1);\
etype name2(etype,X2);\
\
void copy_node_entry(GenPtr& x) const { x=Copy(ACCESS1(vtype,x)); }\
void copy_edge_entry(GenPtr& x) const { x=Copy(ACCESS2(etype,x)); }\
\
void clear_node_entry(GenPtr& x) const { Clear(ACCESS1(vtype,x)); }\
void clear_edge_entry(GenPtr& x) const { Clear(ACCESS2(etype,x)); }\
\
void write_node_entry(ostream& o, GenPtr& x) const{ Print(ACCESS1(vtype,x),o);}\
void write_edge_entry(ostream& o, GenPtr& x) const{ Print(ACCESS2(etype,x),o);}\
\
void read_node_entry(istream& i, GenPtr& x) { Read(name2(vtype,X1),i);\
                                              x=Copy(name2(vtype,X1)); }\
void read_edge_entry(istream& i, GenPtr& x) { Read(name2(etype,X2),i);\
                                              x=Copy(name2(etype,X2)); }\
\
void init_node_entry(GenPtr& x) { Init(name2(vtype,X1));\
                                  x = Copy(name2(vtype,X1)); }\
void init_edge_entry(GenPtr& x) { Init(name2(etype,X2));\
                                  x = Copy(name2(etype,X2)); }\
\
void print_node_entry(ostream& o, GenPtr& x)  const\
     { o << "("; Print(ACCESS1(vtype,x),o); o << ")"; }\
void print_edge_entry(ostream& o, GenPtr& x)  const\
     { o << "("; Print(ACCESS2(etype,x),o); o << ")"; }\
\
public:\
\
int cmp_node_entry(node x, node y) const { return compare(inf(x),inf(y)); }\
int cmp_edge_entry(edge x, edge y) const { return compare(inf(x),inf(y)); }\
\
   vtype  inf(node v)         const { return ACCESS1(vtype,ugraph::inf(v)); }\
   etype  inf(edge e)         const { return ACCESS2(etype,ugraph::inf(e)); }\
   vtype& operator[] (node v)       { return ACCESS1(vtype,entry(v)); }\
   vtype  operator[] (node v) const { return ACCESS1(vtype,ugraph::inf(v)); }\
   etype& operator[] (edge e)       { return ACCESS2(etype,entry(e)); }\
   etype  operator[] (edge e) const { return ACCESS2(etype,ugraph::inf(e)); }\
   void   assign(node v,vtype x)    { graph::assign(v,Convert(x)); }\
   void   assign(edge e,etype x)    { graph::assign(e,Convert(x)); }\
\
   node   new_node()        { return ugraph::new_node(); }\
   node   new_node(vtype a) { return ugraph::new_node(Copy(a)); }\
\
   edge   new_edge(node v, node w) \
                      { return ugraph::new_edge(v,w); }\
   edge   new_edge(node v, node w, etype a) \
                      { return ugraph::new_edge(v,w,Copy(a)); }\
   edge   new_edge(node v, node w, edge e1, edge e2, int dir1, int dir2)\
                      { return ugraph::new_edge(v,w,e1,e2,dir1,dir2); }\
   edge   new_edge(node v,node w,edge e1,edge e2,etype a,int dir1,int dir2)\
                      { return ugraph::new_edge(v,w,e1,e2,Copy(a),dir1,dir2); }\
\
   UGRAPH(vtype,etype)& operator=(const UGRAPH(vtype,etype)& a)\
       {return (UGRAPH(vtype,etype)&)(ugraph::operator=((ugraph&)a)); }\
\
   UGRAPH(vtype,etype)& operator=(const graph& a)\
       {return (UGRAPH(vtype,etype)&)(ugraph::operator=(a)); }\
\
   UGRAPH(vtype,etype)()                                       { }\
   UGRAPH(vtype,etype)(const UGRAPH(vtype,etype)& a): ugraph((ugraph&)a) { copy_all_entries();}\
   UGRAPH(vtype,etype)(const graph& a)              : ugraph(a)         { copy_all_entries();}\
\
   ~UGRAPH(vtype,etype)() { clear(); }\
};\



extern void complete_ugraph(ugraph&,int);
extern void random_ugraph(ugraph&,int,int);
extern void test_ugraph(ugraph&);

#ifndef __ZTC__
inline void complete_graph(ugraph& U,int n)     { complete_ugraph(U,n); }
inline void random_graph(ugraph& U,int n,int m) { random_ugraph(U,n,m); }
inline void test_graph(ugraph& U)               { test_ugraph(U); }
#endif


#endif
