#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************





CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Subroutine User (X, Y, Numpt, NumCrv, term)


*****************************************************************
*                                                               *
*    Subroutine User                                            *
*                                                               *
*      This routine gets the XY points, for the curve.          *
*      The user is prompted for the number of simultaneous      *
*      curves. The routine asks the user for the number of      *
*      data points to be entered. Prompts are used to read      *
*      in the X & Y array. The process is repeated for the      *
*      number of curves requested.                              *
*                                                               *
*      If the user would like to enter the points for more      *
*      than one file simultaneously, control is given to        *
*      "usersn".                                                *
*                                                               *
*      Minor error checking is done by this routine; mainly     *
*      to make sure the user enters a reasonable amount of      *
*      simultaneous curves, and that the number of data         *
*      points are of a reasonible size.                         *
*                                                               *
*      The subroutine also finds the max and min points for     *
*      the X & Y curves. The max and min points are depen-      *
*      dent on the maximum and minimum points of all the        *
*      curves. The window is also initialized to these          *
*      points, which the user has the option of later           *
*      changing.                                                *
*                                                               *
*****************************************************************

        Logical         cldrun
        Common /strtup/ cldrun
        Save   /strtup/

        Integer         max, num, maxC
        Common /Object/ max, num, maxC
        Save   /Object/

        Character    ans
        Real         X(max,num), Y(max,num)
        Integer      NumCrv, Numpt(num), term, I, J


*       (* Find out how curves are to be plotted at once, or
*          how many simultaneous curves are desired. *)
    1   Call clear(term)
        Write (*,10)
   10   Format (/15x,'Keyboard Input',///,
     +          5x,'Please enter the number of simultaneous curves',/
     +          5x,'desired (1 - 3) ...')
        Read (*,'(i3)',err=1) NumCrv
        IF (NumCrv .EQ. 0) NumCrv = 1

*       (* Make sure a legal amount of curves were selected. *)
  100   IF (NumCrv .LT. 1 .OR. NumCrv .GT. num) THEN
    2     Call clear(term)
          Write (*,'(a1)') Char(7)
          Write (*,10)
          Read (*,'(i3)',err=2) NumCrv
          IF (NumCrv .EQ. 0) NumCrv = 1
          GOTO 100
        ENDIF
*
*  Would the user like to enter the data for all the curves at once?
*  (Automatically set the answer to "n" if there is only one
*   curve.)
*
        IF (NumCrv .GT. 1) THEN 
   22     Call clear(term)
          Write (*,20) NumCrv
   20     Format (/15x,'User Input',///5x,'Would you like to enter',
     +            ' the data for these',/,5x,
     +             I1,' curves at the same time? (y,n)'/)     

          Read (*,'(a1)',err=22) ans
        ELSE
          ans = 'n'
        ENDIF

        IF ((ans .EQ. 'Y') .OR. (ans .EQ. 'y')) THEN
*
*      Do it at the same time.          
*
          Call UserSn (X, Y, Numpt, NumCrv, term)
        ELSE
*         (* Get the data for the different curves. *)
          I = 1
  200     IF (I .LE. NumCrv) THEN
    3       Call clear(term)
            Write (*,30) I
   30       Format(/,15x,'Keyboard Input',///
     +           ,5x,'Please enter the number of points for curve',i1,
     +               ' ...')
            Read (*,*,err=3) Numpt(I)

            IF (Numpt(I) .LT. 2  .OR. Numpt(I) .GT. max) THEN
*             (* Disaster!! Too many data points. Allow the user to 
*                either quit or retry to enter the number of points. *)
    4         Call clear(term)
              Write (*,40) Numpt(I)
   40         Format(/,15x,'Keyboard Input',///,5x,'Sorry, but ',i4
     +                ,' is not a valid number',' of points.',//
     +               ,5x,'Do you wish to stop the program? (Y/N)... ')
              Read (*,'(a1)',err=4) ans
              IF (ans .EQ. 'Y' .OR. ans .EQ. 'y') THEN
                Write (*,50)
   50           Format (//,5x,'Goodbye!'//)
                STOP
              ENDIF
            ELSE
*             (* Read in the X & Y points. *)
              Do 400 J = 1,Numpt(I)
    5           Call clear(term)
                Write(*,60) J
   60           Format(/,15x,'Keyboard Input',///,5x,
     +                     'Enter X and Y, point:',i3)
                Read (*,*,err=5,end=300) X(J,I), Y(J,I)
  400         CONTINUE

*           (* Increment I, the curve indicator, to the next curve. *)
  300         I = I +1
            ENDIF

            GOTO 200
          ENDIF
        ENDIF

*       (* Get the max and min points. *)

        IF (.NOT. cldrun) THEN
 450      Call Clear (term)
          Write (*,500)
 500      Format(5x,'Do you want the window edges set automatically?',
     +           /5x,'default = (yes)'/)
          Read (*,'(a1)',err=450) ans
        ELSE
          ans = 'y'
        ENDIF

        IF (ans .NE. 'n' .AND. ans .NE. 'N') THEN
          Call MaxMin (X, Y, NumCrv, NumPt)
        ENDIF

*       (* See if the user wishes to dump their points into files. *)
    6   Call clear(term)
        Write (*,70)
   70   Format (/15x,'Keyboard Input',///,5x,'Do you wish to save'
     +          ' these points in data files? (Y/N) ...')
        Read (*,'(a1)',err=6) ans
        if (ans .EQ. 'y' .OR. ans .EQ. 'Y') Call Save(X, Y, Numpt, 
     +      NumCrv, term)

        RETURN
        END
