#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************




CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Subroutine Save (X, Y, Numpt, NumCrv, term)


*********************************************************************
*                                                                   *
*    Subroutine Save_User_Input                                     *
*                                                                   *
*      This routine is used to dump the data points, entered        *
*      from the user in Subroutine "User", to data files            *
*      specified by the user. The is prompted for the name of       *
*      the desired data file. The file is opened and the points     *
*      written to it. The process is repeated for each curve.       *
*                                                                   *
*      If the file already exists, the user will then have the      *
*      choice to either input a new name, overwrite the old one,    *
*      or going onto the next curve.                                *
*                                                                   *
*********************************************************************


        Integer         max, num, maxC
        Common /Object/ max, num, maxC
        Save   /Object/

        Character    ans
        Character*35 files
        Real         X(max,num), Y(max,num)
        Integer      NumCrv, Numpt(num), term, IOerr, I, J

*       (* Prompt the user for each filename of each curve, and
*          save the data points. *)
        I = 1
  100   IF (I .LE. NumCrv) THEN
    1     Call clear(term)
          IF (NumCrv .NE. 1) THEN
            Write (*,10) I
   10       Format (/,15x,'Save Curves',///5x,' Do you wish to save the'
     +               ,' points stored in curve ',i1,'? (Y/N) ...')
            Read (*,'(a1)',err=1) ans
          ELSE
            ans = 'y'
          ENDIF

          IF (ans .EQ. 'y' .OR. ans .EQ. 'Y') THEN
    2       Call clear(term)
            Write (*,20) I
   20       Format (/15x,'Save Curves',///5x,'Please enter ',
     +              'the desired filename for curve ',i1,'?')
            Read (*,'(a35)',err=2) files
            IF (files .EQ. ' ') THEN
              Write (*,'(a1)') Char(7)
              GOTO 2
            ENDIF

*           (* Open the file. *)
            Open (unit =1, file = files, status = 'new', iostat = IOerr)
            IF (IOerr .EQ. 0) THEN
              Rewind 1
              Write (1,30,err=100) (X(J,I), Y(J,I), J = 1, Numpt(I))
   30         Format (2(G14.6))
              I = I +1
            ELSE
    3         Call clear(term)
              Write (*,40) files
   40         Format (/15x,'Save Curves',///,
     +                5x,'Sorry, but file: ',a,/5x,'already exists!',
     +                //5x,'Do you wish to overwrite? (Y/N) ...')
              Read (*,'(a1)',err=3) ans

*             (* If the user wishes to overwrite the old file, open
*                the file as old, and then dump the points. *)
              IF (ans .EQ. 'y' .OR. ans .EQ. 'Y') THEN
                Open (unit =1, file = files, status='old',iostat= IOerr)
                Rewind 1
                Write (1,30,err=100) (X(J,I), Y(J,I), J = 1, Numpt(I))
                I = I +1
              ELSE
    4           Write (*,50)
   50           Format (/,5x,'Do you wish to retry? (Y/N) ...')
                Read (*,'(a1)',err=4) ans
                IF (ans .NE. 'y' .AND. ans .NE. 'Y') I = I +1
              ENDIF
            ENDIF
          ELSE IF (ans.EQ.'n' .OR. ans.EQ.'N' .OR. ans.EQ.' ') THEN
            I= I +1
          ENDIF
          GOTO 100
        ENDIF

        RETURN
        END
