
#include <stdio.h>
#include <hipl_format.h>

#define Calloc(x,y) (y *)calloc((unsigned)(x), sizeof(y))
#define Fread(a,b,c,d) fread((char *)(a), b, (int)(c), d)
#define Fwrite(a,b,c,d) fwrite((char *)(a), b, (int)(c), d)
#define Cfree(x) cfree((char *)(x))

extern int VERBOSE;
extern char MY_NAME[80];

/**************************** get_data ****************************/
float  ***
get_data(fp, xdim, ydim, zdim)
    FILE     *fp;
    int      *xdim, *ydim, *zdim;
/* This subroutine will read in the HIPS data file. */
{
    struct header hd;
    int       fd;
    float  ***data;
    float  ***alloc_3d_float_array();

    fd = fileno(fp);
    if (fread_headerc(fd, &hd, 1) != 0) {
	fprintf(stderr, "\n Error reading hips header\n");
	exit(0);
    }
    if (hd.pixel_format != PFFLOAT) {
	fprintf(stderr, "\n Error: pixel format must be float\n");
	exit(0);
    }
#ifdef BETTER			/* this is much more intuitive to me, but Max
				 * set things up weird, as usual -BT */
    *zdim = hd.num_frame;
    *ydim = hd.rows;
    *xdim = hd.cols;
#else
    *xdim = hd.num_frame;
    *ydim = hd.rows;
    *zdim = hd.cols;
#endif

    if (VERBOSE)
	fprintf(stderr, "%s: data set size xdim=%d ydim=%d zdim=%d\n",
		MY_NAME, *xdim, *ydim, *zdim);

    data = alloc_3d_float_array(*xdim, *ydim, *zdim);

    read_3d_float_array(fp, data, *xdim, *ydim, *zdim);

    return (data);
}

/******************************************************/
void
write_polys(output, trans, norm, edges_done, num_sides,
	    edgelist, normlist, triangles)
    FILE     *output;
    int       trans;
    int       norm, edges_done, num_sides;
    float    *edgelist[3], *normlist[3];
    long     *triangles;
{

/* Write things out and free the space they took up:
 * the number of vertices, the number of polygon sides,
 * then the transparency factor.
 */
    Fwrite(&edges_done, sizeof(int), 1, output);
    Fwrite(&num_sides, sizeof(int), 1, output);
    Fwrite(&trans, sizeof(int), 1, output);
    Fwrite(&norm, sizeof(int), 1, output);

/* Then the list of vertices...
 */
    Fwrite(&(edgelist[0][1]), sizeof(float), edges_done, output);
    Fwrite(&(edgelist[1][1]), sizeof(float), edges_done, output);
    Fwrite(&(edgelist[2][1]), sizeof(float), edges_done, output);
    Cfree(edgelist[0]);

/* If we used Gouraud shading, we expect normals;
 */
    if (norm) {
	Fwrite(&(normlist[0][1]), sizeof(float), edges_done, output);
	Fwrite(&(normlist[1][1]), sizeof(float), edges_done, output);
	Fwrite(&(normlist[2][1]), sizeof(float), edges_done, output);
    }
    /*
     * And the list of polygon sides.
     */
    Fwrite(triangles, sizeof(int), num_sides, output);
}

/******************************************************/

void
write_ascii_polys(output, trans, norm, edges_done, num_sides,
		  edgelist, normlist, triangles)
    FILE     *output;
    int       trans;
    int       norm, edges_done, num_sides;
    float    *edgelist[3], *normlist[3];
    long     *triangles;
{
    register int i;

    fprintf(output, " %d %d %d %d \n", edges_done, num_sides, trans, norm);

    for (i = 0; i < edges_done; i++)
	fprintf(output, " %f %f %f \n", edgelist[0][i],
		edgelist[1][i], edgelist[2][i]);

    if (norm) {
	for (i = 0; i < edges_done; i++)
	    fprintf(output, " %f %f %f \n", normlist[0][i],
		    normlist[1][i], normlist[2][i]);
    }
    /*
     * And the list of polygon sides.
     */
    for (i = 0; i < num_sides; i++) {
	fprintf(output, " %d ", triangles[i]);
	if (triangles[i] < 0)
	    fprintf(output, "\n");
    }
}
