 /*
  * Khoros: $Id: run_preview.c,v 1.2 1991/12/18 09:07:48 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: run_preview.c,v 1.2 1991/12/18 09:07:48 dkhoros Exp $";
#endif

 /*
  * $Log: run_preview.c,v $
 * Revision 1.2  1991/12/18  09:07:48  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "preview.h"
#include "form_info.h"


/********************************************************
*
*  Routine Name:  run_show
*
*       Purpose:  drives the subform 'show'
*
*         Input:  form - pointer to the form tree 
*		  show_info  - information structure for subform 'show'
*        Output:  action of the application program
*
*     Called By:  run_UI_view()
*
*   Automatically Generated By:  vgenform
*
********************************************************/


run_show(form, show_info)

xvf_form *form;
UI_view_show *show_info;
{

	/*
	 * action came from the 'preview' pane
	 */
	if (show_info->preview_selected)
	    run_preview(form, show_info->preview);


}   /* end run_show */


/********************************************************
*
*  Routine Name:  run_preview
*
*       Purpose:  drives the pane 'preview'
*
*         Input:  form - pointer to the form tree 
*		  preview_info  - information structure for pane 'preview'
*        Output:  action of the application program
*
*     Called By:  run_show()
*
*   Automatically Generated By:  vgenform
*
********************************************************/

run_preview(form, preview_info)

xvf_form *form;
show_preview *preview_info;
{
	char	*editor, *getenv(), *filename, temp[MaxLength];
	int	pid, update_file();

	/*
 	 *  any action on the preview form is invalid if there
	 *  is no valid input UIS file
	 */
 	if (preview_info->i == NULL)
	{
	    xvf_error_wait("Please specify a UIS file to edit", 
			   "run_preview", NULL);
	    return;
	}

	/*
	 * user clicked on "Edit" button
	 */
	if (preview_info->edit) 
        {
	   filename = vfullpath(preview_info->i, NULL, NULL);
	   if (filename != NULL)
	   {
	       /*
	        * Check to see if the user has specified a preferred editor.  
                * If not use the default EDITOR.
	        */
	       if (!(editor = getenv("EDITOR")))
	          (void) sprintf(temp, 
			"xterm -display %s -geometry 132x24 -e %s %s",
                         display->display_name, EDITOR, filename);
	       else
	       {
                  /* kludge by Robin Corbet to avoid producing an xterm
                   * window if one isn't really needed 
		   */
                   if (strcmp(editor,"textedit") == 0 ||
                       strcmp(editor,"xedit") == 0)
                       (void) sprintf(temp, "%s %s", editor, filename);
                   else
                       (void) sprintf(temp, 
			"xterm -display %s -geometry 132x24 -e %s %s",
                         display->display_name, editor, filename);
	       }
	       pid = xvf_fork(temp, NULL, NULL);
	       free(filename);
	    }
	}

	/*
	 * user clicked on live input file selection or "Show" button
	 */
	else if (preview_info->i_selected || preview_info->revisit) 
        {
	    if (demo_form != NULL)
	       xvf_destroy_form(demo_form);

	    if (demo_id != 0)
	       xvf_delete_detect(demo_id);

	    if (demo_form = xvf_create_form(preview_info->i, av, ac, 
					      SIMPLE, NULL,-1,-1))
	    {
		if (demo_form->subform != NULL)
                {
	            xvf_change_active (demo_form, true);
	            demo_id = xvf_detect_file(preview_info->i, PREVIEW_DELAY,
					      update_file, NULL);
		}
		else
                {
                   xvf_error_wait("Empty UIS definition - nothing to display.",
                                   NULL, NULL);
                }
	    }
	}
}


/********************************************************
*
*  Routine Name:  update_file()
*
*       Purpose:  this is the call back routine for the detection of
		a change in a file.
*
*         Input:  id - identifier for the file that has changed
*		  filename  - name of file detected.
*		  data  - data structure sent back ... not imploemented
*        Output:  form is created and mapped
*
*     Called By:  
*
*   Writen By:  Mark Young and John rasure
*
********************************************************/

int update_file(id, filename, data)

int  id;
char *filename;
char *data;
{
	int  x, y, width, height;


	if (demo_form != NULL)
	{
	   if (demo_form->toplevel != NULL)
	      xvf_form_geometry(demo_form, &x, &y, &width, &height);
	   else
	      xvf_subform_geometry(demo_form->subform, &x, &y, &width, &height);

	   xvf_destroy_form(demo_form);
	}
	else
	   x = y = -1;

	if (demo_form = xvf_create_form(filename, av, ac, SIMPLE, NULL, x, y))
	{
	   xvf_change_active (demo_form, true);
	   FORM_DONE = true;
	}
	return(1);
}
