 /*
  * Khoros: $Id: lkraftsman.c,v 1.4 1992/03/20 22:52:34 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lkraftsman.c,v 1.4 1992/03/20 22:52:34 dkhoros Exp $";
#endif

 /*
  * $Log: lkraftsman.c,v $
 * Revision 1.4  1992/03/20  22:52:34  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lkraftsman.c
 >>>>
 >>>>      Program Name: kraftsman
 >>>>
 >>>> Date Last Updated: Fri Dec 13 15:03:16 1991 
 >>>>
 >>>>          Routines: lkraftsman - the library call for kraftsman
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "xvinclude.h"


/* -library_includes */
#include "kraftsman.h"
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lkraftsman - library call for kraftsman
*
* Purpose:
*    
*    Creates the GUI and drives the master form.
*    
*    

* Input:
* Output:
*
* Written By: Steven Jorgensen 
****************************************************************/


/* -library_def */
lkraftsman(program, tname)
char    *program;
char    *tname;
/* -library_def_end */

/* -library_code */
{
        char *form_filestring;
        char *form_pathname;

        /*
         * initialize the display & the forms - 
         * NOTE: assuming a global 'Display *display'
         */
        display = xvf_initialize(ac, av, program);
        if (display == NULL)
        {
             fprintf(stderr, "Could not open connection to server");
             exit(0);
        }

        /*
         * Substitute below the correct filename and directory path
         * of the User Interface Description file to be used
         */
        form_filestring = VStrcpy("kraftsman.form");
#ifdef LOCAL
        form_pathname   = VStrcpy("KHOROS_HOME/work/xvroutines/kraftsman");
#else
        form_pathname   = VStrcpy("KHOROS_HOME/repos/kraftsman");
#endif
        form_filestring = vfullpath(form_filestring, form_pathname, NULL);

        /*
         * Create the forms 
         */
        if (!(form = xvf_create_form(form_filestring, av, ac, SIMPLE, NULL,
                                     -1, -1)))
           exit(0);

        /*
         * Initialize the auto-generated information structure
         */
        _xvf_init_Master(form,  &Master_info);

        /*
         * Map the forms
         */
        xvf_change_active(form, true);
	if (tname != NULL)
	  {
	    if (vtoolbox_entry(tname) == NULL)
	      xvf_change_input(form,Master_info.Kraftsman->create->toolbox_index, xvf_stringval_chng, tname, 0);
	    else
	      {
		xvf_change_input(form,Master_info.Kraftsman->configure->toolbox_index, xvf_stringval_chng, tname, 0);
		xvf_change_input(form,Master_info.Kraftsman->configure_gb_index,
				 xvf_guide_chng, "1", 0);
	      }
	  }
        deactivate_create(form);
        deactivate_config(form);

        do
        {
             /*
              * run the forms
              */
             form = xvf_run_form();
             if (form == NULL) break;

             /*
              * get information from the master
              */
             _xvf_get_Master(form, &Master_info);

             /*
              * action came from the 'Kraftsman' subform
              */
             if (Master_info.Kraftsman_selected)
             {
                  run_Kraftsman(form, Master_info.Kraftsman);
             }


        xvf_clear_selections(form->db, form->line_num);
        } while (!Master_info.Kraftsman->quit);    /* end user interface loop */

}    /* end run_Master */
/* -library_code_end */
