 /*
  * Khoros: $Id: vrotate.h,v 1.2 1991/10/02 00:28:47 khoros Exp $
  */

 /*
  * $Log: vrotate.h,v $
 * Revision 1.2  1991/10/02  00:28:47  khoros
 * HellPatch2
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vrotate.h
 >>>>            Author: Scott Wilson
 >>>> Date Last Updated: Sun Aug 25 21:10:25 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vrotate_h_
#define _vrotate_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vrotate Argument Structure
*
****************************************************************/

typedef struct _vrotate  {

/*
 *  input image (Required infile)
 */
char	*i_file;	/* input image FILENAME */
int	 i_flag;	/* input image FLAG */

/*
 *  resulting output image (Required outfile)
 */
char	*o_file;	/* resulting output image FILENAME */
int	 o_flag;	/* resulting output image FLAG */

/*
 *  X coord of center of rotation (Optional integer)
 */
int	 x_int; 	/* X coord of center of rotation INT */
int	 x_flag;	/* X coord of center of rotation FLAG */

/*
 *  Y coord of center of rotation (Optional integer)
 */
int	 y_int; 	/* Y coord of center of rotation INT */
int	 y_flag;	/* Y coord of center of rotation FLAG */

/*
 *  specifies the clockwise rotation angle in degrees (Optional float)
 */
float	 d_float;	/* specifies the clockwise rotation angle in degrees FLOAT */
int	 d_flag;   	/* specifies the clockwise rotation angle in degrees FLAG */

}  vrotate_struct;

vrotate_struct *vrotate;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define CHECKINPUT(program, image) \
        (void) proper_num_images(program,image,1,TRUE); \
        \
        if (propertype(program,image,VFF_TYP_COMPLEX,FALSE)) \
        { \
            (void) fprintf(stderr, "Image data type can NOT be \
VFF_TYP_COMPLEX \n"); \
            exit(1); \
        } \
        \
        (void) proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE); \
        \
        (void) proper_loc_type(program,image,VFF_LOC_IMPLICIT,TRUE)
/* -include_macros_end */

#endif
