 /*
  * Khoros: $Id: vect2row.c,v 1.1 1991/05/10 15:47:09 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vect2row.c,v 1.1 1991/05/10 15:47:09 khoros Exp $";
#endif

 /*
  * $Log: vect2row.c,v $
 * Revision 1.1  1991/05/10  15:47:09  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vect2row.c
 >>>>
 >>>>      Program Name: vect2row
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	reformats data stored in vector format to a single-band file
 >>>>	where  each  vector  is represented as a separate row in the
 >>>>	output file.
 >>>>	
 >>>>	
 >>>>            Author: Donna Koechner
 >>>>
 >>>> Date Last Updated: Sun Apr 28 22:35:13 1991
 >>>>
 >>>>          Routines: main- the main program for vect2row
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vect2row.h"


/****************************************************************
 *
 * Routine Name:  main program for vect2row
 *
 *       Input:  
 *          -i  input data file 
 *          -o  output (vector) file 
 *
 *
 *          [-s] Extract only one vector (1 = yes, 0 = no)
 *          [-x] horizontal (x) offset of voxel  (value >= 0)
 *          [-y] vertical (y) offset of voxel  (value >= 0)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage  *image,         /* input/output image */
                *readimage();
int             process_dir;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args())
{
  fprintf(stderr, "%s: Illegal arguments on command line.\n", program);
  exit(1);
}
READIMAGE(image) ;
CHECKTYPE(program, image) ;
CHECKINPUT(program, image) ;

process_dir = 0;        /* DSP_VECTOR */

/*
 * If input image has only one band, exit.
 */
 if ( image->num_data_bands < 2 )
 {
   (void)fprintf(stderr,"vect2row:  Cannot operate on images with less ");
   (void)fprintf(stderr,"than 2 data bands\n");
   exit(1);
 }

/*
 * Make sure row offset and col offset are within range
 */
 if ( vect2row->s_logic && ( (vect2row->y_int >= image->col_size) || 
                       (vect2row->x_int >= image->row_size) ) )
 {
   (void) fprintf(stderr,"vect2row: row or column offset out of range\n");
   exit(1);
 }

/* -main_before_lib_call_end */

/* -main_library_call */
 if(! lvect2row ( image, vect2row->s_logic, vect2row->y_int, vect2row->x_int, 
                  process_dir ) )
 {
   (void) fprintf(stderr, "lvect2row Failed\n");
   exit(1);
 }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(vect2row->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vect2row 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vect2row :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\treformats data stored in vector format to a single-band file\n");
	fprintf(stderr, "\twhere  each  vector  is represented as a separate row in the\n");
	fprintf(stderr, "\toutput file.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input data file  (infile)\n");
	fprintf(stderr,"\t-o  output (vector) file  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-s]  Extract only one vector (1 = yes, 0 = no) (boolean) [false]\n");
	fprintf(stderr,"\t[-x]  horizontal (x) offset of voxel (integer, >= 0) [0]\n");
	fprintf(stderr,"\t[-y]  vertical (y) offset of voxel (integer, >= 0) [0]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vect2row\n");
	fprintf(stderr, "\t[-U] Gives the usage for vect2row\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vect2row.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vect2row.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vect2row
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input data file \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output (vector) file \n        {outfile}: "; 
char	*s_pstr = 
	"\nEnter: (s) Extract only one vector (1 = yes, 0 = no) \n        {boolean, (y/n)  [no] }: "; 
char	*x_pstr = 
	"\nEnter: (x) horizontal (x) offset of voxel \n        {integer, >= 0 [0] }: "; 
char	*y_pstr = 
	"\nEnter: (y) vertical (y) offset of voxel \n        {integer, >= 0 [0] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vect2row", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vect2row.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vect2row: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vect2row.ans");
		}

	     }

	}

	/*
	 * allocate the vect2row structure
	 */
	vect2row = (vect2row_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vect2row_struct));

	/*
	 * get required arguments for vect2row
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vect2row->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vect2row->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vect2row->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vect2row->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vect2row->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vect2row->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vect2row->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vect2row->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vect2row->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vect2row->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vect2row
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vect2row->s_flag = vget_logic(fid, prompt_flag,
	"-s", s_pstr, &(vect2row->s_logic), 0);

	vect2row->x_flag = vget_int(fid, prompt_flag,
	"-x", x_pstr, &(vect2row->x_int),
	0, 1, 1);

	vect2row->y_flag = vget_int(fid, prompt_flag,
	"-y", y_pstr, &(vect2row->y_int),
	0, 1, 1);


}



