 /*
  * Khoros: $Id: vquant.c,v 1.3 1991/12/18 09:33:38 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vquant.c,v 1.3 1991/12/18 09:33:38 dkhoros Exp $";
#endif

 /*
  * $Log: vquant.c,v $
 * Revision 1.3  1991/12/18  09:33:38  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vquant.c
 >>>>
 >>>>      Program Name: vquant
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Perform N-dimensional vector quantization or classification
 >>>>	
 >>>>	

 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Thu Nov 14 16:03:09 1991
 >>>>
 >>>>          Routines: main- the main program for vquant
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vquant.h"


/****************************************************************
 *
 * Routine Name:  main program for vquant
 *
 *       Input:  
 *        -i  input image 
 *        -o  output resulting image 
 *        -axis  Select splitting axis
 *		1 (Maximum span axis),
 *		2 (Maximum variance axis),
 *		or 3 (Principal eigenvector)
 *		 
 *
 *
 *        [-o1] cluster center output image
 *        [-o2] cluster variance output image
 *        [-n] number of vectors  (value > 0)
 *        [-m] Output Image Map Enable
 *        [-s] Select split point - False: mid-span, True: mean
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image,*ccimage,*cvimage,*readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);
/* -main_before_lib_call_end */

/* -main_library_call */
READINPUT(image);
CHECKINPUT(program,image);

if (! lvquant(image,vquant->n_int,vquant->m_logic,&ccimage,
                    vquant->o1_flag, &cvimage,
                    vquant->o2_flag,
                    vquant->s_logic,
                    vquant->axis_toggle))
 {
   (void) fprintf(stderr, "lvquant Failed\\n");
   exit(1);
 }
/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(vquant->o_file,image);
if (vquant->o1_flag) writeimage(vquant->o1_file,image);
if (vquant->o2_flag) writeimage(vquant->o2_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vquant 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vquant :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tPerform N-dimensional vector quantization or classification\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  output resulting image  (outfile)\n");
	fprintf(stderr, "\t-axis  ");
	fprintf(stderr, "Select splitting axis\n  ");
	fprintf(stderr, "\t\t1  (Maximum span axis),\n");
	fprintf(stderr, "\t\t2  (Maximum variance axis),\n");
	fprintf(stderr, "\t\tor 3  (Principal eigenvector)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-o1]  cluster center output image (outfile) [null]\n");
	fprintf(stderr,"\t[-o2]  cluster variance output image (outfile) [null]\n");
	fprintf(stderr,"\t[-n]  number of vectors (integer, > 0) [128]\n");
	fprintf(stderr,"\t[-m]  Output Image Map Enable (boolean) [true]\n");
	fprintf(stderr,"\t[-s]  Select split point - False: mid-span, True: mean (boolean) [false]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vquant\n");
	fprintf(stderr, "\t[-U] Gives the usage for vquant\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vquant.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vquant.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vquant
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output resulting image \n        {outfile}: "; 
char	*axis_pstr = "\nEnter: (axis) Select splitting axis -- \n      \t\t1 (Maximum span axis)\n\t\t2 (Maximum variance axis)\n\t\tor 3 (Principal eigenvector)\n     : "; 
char	*o1_pstr = 
	"\nEnter: (o1) cluster center output image \n        {outfile}: "; 
char	*o2_pstr = 
	"\nEnter: (o2) cluster variance output image \n        {outfile}: "; 
char	*n_pstr = 
	"\nEnter: (n) number of vectors \n        {integer, > 0 [128] }: "; 
char	*m_pstr = 
	"\nEnter: (m) Output Image Map Enable \n        {boolean, (y/n)  [yes] }: "; 
char	*s_pstr = 
	"\nEnter: (s) Select split point - False: mid-span, True: mean \n        {boolean, (y/n)  [no] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vquant", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vquant.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vquant: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vquant.ans");
		}

	     }

	}

	/*
	 * allocate the vquant structure
	 */
	vquant = (vquant_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vquant_struct));

	/*
	 * get required arguments for vquant
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vquant->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vquant->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vquant->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vquant->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vquant->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vquant->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vquant->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vquant->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vquant->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vquant->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


	/*
	 * get required toggles for vquant
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		vquant->axis_flag = vget_int(fid, prompt_flag,
		"-axis", axis_pstr, &(vquant->axis_toggle),
		1, 0, 0);

		if (((vquant->axis_toggle == 1 ) || 
		     (vquant->axis_toggle == 2 ) || 
		     (vquant->axis_toggle == 3 )) &&
		     (vquant->axis_flag))
		      ok = TRUE;
		else
		{
		    fprintf(stderr, "\naxis is a required argument.\n");
		}
	    }
	}
	else
	{
		vquant->axis_flag = vget_int(fid, prompt_flag,
		"-axis", axis_pstr, &(vquant->axis_toggle),
		1, 0, 0);

		if (((vquant->axis_toggle != 1 ) && 
		     (vquant->axis_toggle != 2 ) && 
		     (vquant->axis_toggle != 3 )) ||
		     (!(vquant->axis_flag)))
		{
		    fprintf(stderr, "axis is a required argument.\n");
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}

	/*
	 * get optional arguments for vquant
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vquant->o1_flag = vget_outfile(fid, prompt_flag,
	"-o1", o1_pstr, &(vquant->o1_file))
;

	vquant->o2_flag = vget_outfile(fid, prompt_flag,
	"-o2", o2_pstr, &(vquant->o2_file))
;

	vquant->n_flag = vget_int(fid, prompt_flag,
	"-n", n_pstr, &(vquant->n_int),
	128, 2, 2);

	vquant->m_flag = vget_logic(fid, prompt_flag,
	"-m", m_pstr, &(vquant->m_logic), 1);

	vquant->s_flag = vget_logic(fid, prompt_flag,
	"-s", s_pstr, &(vquant->s_logic), 0);


}



