 /*
  * Khoros: $Id: lvtranspos.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvtranspos.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvtranspos.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvtranspos.c
 >>>>
 >>>>      Program Name: vtranspos
 >>>>
 >>>> Date Last Updated: Wed Apr 24 22:28:28 1991 
 >>>>
 >>>>          Routines: lvtranspos - the library call for vtranspos
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvtranspos - library call for vtranspos
*
* Purpose:
*    
*    Transpose  an  xvimage  structure  by  exchanging  rows  and
*    columns
*    
*    
* Input:
*    
*         img - a pointer on an xvimage structure.
*    
*    
* Output:
*    
*         img - holds the result of the transposition.
*    
*    
*
* Written By: Pascal ADAM
*    
*    Jeremy Worley Wed Apr 24 22:26:57 MDT 1991
*                                  complex case had indexing  problems
*                                  that could cause core dumps.  these
*                                  indexing problems have been fixed.
*    
*    
****************************************************************/


/* -library_def */
int
lvtranspos(img)
struct xvimage *img;
/* -library_def_end */

/* -library_code */
{
#define X(i,j,l)   (i*nc + j + l*k)
#define XP(i,j,l)  (i*nr + j + l*k)
    
     int    i, j, k, l, nc, nr, band;
  
     unsigned char *c1;
     short  *s1;
     int    *i1;
     float  *f1;

     unsigned char  *result1;  /* pointer to resulting image byte  */
     short          *result2;  /* pointer to resulting image short */
     int            *result3;  /* pointer to resulting image int   */
     float          *result4;  /* pointer to resulting image float */

     nc= img->row_size; 
     nr=img->col_size;
     band=img->num_data_bands;
     k = nc * nr; 

     switch (img->data_storage_type)
     {
        case VFF_TYP_BIT :
          (void)fprintf(stderr,
          "lvtranspos: Don't know how to transpose BIT images\n");
          return(0);
          break;

        case VFF_TYP_1_BYTE :

          /* Allocate space for resulting image */
          result1 = (unsigned char *)malloc(band*k*sizeof(char));
          if(result1 == NULL) 
          {
            (void) fprintf(stderr,
            "lvtranspos: insufficient memory available\n");
            return(0);
          }


          /* pointer on image data */
          c1 = (unsigned char *)(img->imagedata);
     
          /* loop for transposition computation */    
          for (i=0; i<nr; i++)
              for (j=0; j<nc; j++)
                  for (l=0; l<band; l++)
                      *(result1+XP(j,i,l)) = *(c1+X(i,j,l)); 
  
          c1 = (unsigned char *)(img->imagedata);
          for (i=0;i<k*band;i++) *(c1+i) = *(result1+i);

          break;
        case VFF_TYP_2_BYTE :

          /* Allocate space for resulting image */
          result2 = (short *)malloc(band*k*sizeof(short));
          if(result2 == NULL) 
          {
            (void) fprintf(stderr,
            "lvtranspos: insufficient memory available\n");
            return(0);
          }

          /* pointer on image data */
          s1 = (short *)(img->imagedata);
     
          /* loop for transposition computation */    
          for (i=0; i<nr; i++)
              for (j=0; j<nc; j++)
                  for (l=0; l<band; l++)
                      *(result2+XP(j,i,l)) = *(s1+X(i,j,l)); 
  
          s1 = (short *)(img->imagedata);
          for (i=0;i<k*band;i++) *(s1+i) = *(result2+i);

          break;
        case VFF_TYP_4_BYTE :
        
          /* Allocate space for resulting image */
          result3 = (int *)malloc(band*k*sizeof(int));
          if(result3 == NULL) 
          {
            (void) fprintf(stderr,
            "lvtranspos: insufficient memory available\n");
            return(0);
          }

          /* pointer on image data */
          i1 = (int *)(img->imagedata);
     
          /* loop for transposition computation */    
          for (i=0; i<nr; i++)
              for (j=0; j<nc; j++)
                  for (l=0;l<band;l++)
                      *(result3+XP(j,i,l)) = *(i1+X(i,j,l)); 
  
          i1 = (int *)(img->imagedata);
          for (i=0;i<k*band;i++) *(i1+i) = *(result3+i);

          break;

        case VFF_TYP_FLOAT :

          /* Allocate space for resulting image */
          result4 = (float *)malloc(band*k*sizeof(float));
          if(result4 == NULL) 
          {
            (void) fprintf(stderr,
            "lvtranspos: insufficient memory available\n");
            return(0);
          }

          /* pointer on image data */
          f1 = (float *)(img->imagedata);
     
          /* loop for transposition computation */    
          for (i=0; i<nr; i++)
              for (j=0; j<nc; j++)
                  for (l=0;l<band;l++)
                      *(result4+XP(j,i,l)) = *(f1+X(i,j,l)); 
  
          f1 = (float *)(img->imagedata);
          for (i=0;i<k*band;i++) *(f1+i) = *(result4+i);

          break;

        case VFF_TYP_COMPLEX :
          /* Allocate space for resulting image */
          result4 = (float *)malloc(band*k*sizeof(float));
          if(result4 == NULL)
          {
            (void) fprintf(stderr,
            "lvtranspos: insufficient memory available\n");
            return(0);
          }


         /* pointer on image data */
          f1 = (float *)(img->imagedata);
          for (i=0;i<nr;i++) 
              for (j=0;j<nc;j++)  
                  for (l=0;l<band;l++) {
                      *(result4+2*XP(j,i,l)+1)= *(f1+2*X(i,j,l)+1);
                      *(result4+2*XP(j,i,l)+1)= *(f1+2*X(i,j,l)+1);
                      }
   
          f1 = (float *)(img->imagedata);
          for (i=0;i < (2*k*band) ;i++) *(f1+i) = *(result4+i);
                   
          break;
        default:
          fprintf(stderr,
          "lvtranspos: Unknown data storage type, %d\n",
          img->data_storage_type);
          return(0);
          break;
      }

      /* substitute  row size and column size */
      img->row_size = nr;
      img->col_size = nc;

      return(1);
}
/* -library_code_end */
