 /*
  * Khoros: $Id: imkmf.c,v 1.2 1991/10/01 23:58:16 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: imkmf.c,v 1.2 1991/10/01 23:58:16 khoros Exp $";
#endif

 /*
  * $Log: imkmf.c,v $
 * Revision 1.2  1991/10/01  23:58:16  khoros
 * HellPatch2
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: imkmf.c
 >>>>
 >>>>      Program Name: imkmf
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	An Imakefile maker/updater
 >>>>	
 >>>>	

 >>>>            Author: Tait Cyrus 
 >>>>
 >>>> Date Last Updated: Wed Sep 25 22:10:56 1991
 >>>>
 >>>>          Routines: main- the main program for imkmf
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "imkmf.h"


/****************************************************************
 *
 * Routine Name:  main program for imkmf
 *
 *       Input:  
 *
 *
 *       [-name] name of object
 *       [-toolbox] Toolbox name
 *       [-o] Imakefile to be output
 *       [-type] Imakefile type
 *		'lib' (library),
 *		'dir' (directory),
 *		'script' (script),
 *		'prog' (vroutine),
 *		'fprog' (vroutine w/ FORTRAN dependancies),
 *		'xprog' (xvroutine),
 *		 or 'fxprog' (xvroutine w/ FORTRAN dependancies)
 *		   [default = lib] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);
/* -main_before_lib_call_end */

/* -main_library_call */
        do_imkmf();
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for imkmf 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "imkmf :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tAn Imakefile maker/updater\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-name]  name of object (string) [null]\n");
	fprintf(stderr,"\t[-toolbox]  Toolbox name (string) [null]\n");
	fprintf(stderr,"\t[-o]  Imakefile to be output (outfile) [null]\n");
	fprintf(stderr, "\t[-type]  Imakefile type\n");
	fprintf(stderr, "\t\t'lib'  (library),\n");
	fprintf(stderr, "\t\t'dir'  (directory),\n");
	fprintf(stderr, "\t\t'script'  (script),\n");
	fprintf(stderr, "\t\t'prog'  (vroutine),\n");
	fprintf(stderr, "\t\t'fprog'  (vroutine w/ FORTRAN dependancies),\n");
	fprintf(stderr, "\t\t'xprog'  (xvroutine),\n");
	fprintf(stderr, "\t\t or 'fxprog'  (xvroutine w/ FORTRAN dependancies)\n");
	fprintf(stderr, "\t\t[default = lib]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for imkmf\n");
	fprintf(stderr, "\t[-U] Gives the usage for imkmf\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called imkmf.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses imkmf.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for imkmf
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*name_pstr = 
	"\nEnter: (name) name of object \n        {string}: "; 
char	*name_def = NULL;
char	*toolbox_pstr = 
	"\nEnter: (toolbox) Toolbox name \n        {string}: "; 
char	*toolbox_def = NULL;
char	*o_pstr = 
	"\nEnter: (o) Imakefile to be output \n        {outfile}: "; 
char	*type_pstr = "\nEnter: (type) Imakefile type -- \n      \t\t'lib' (library)\n\t\t'dir' (directory)\n\t\t'script' (script)\n\t\t'prog' (vroutine)\n\t\t'fprog' (vroutine w/ FORTRAN dependancies)\n\t\t'xprog' (xvroutine)\n\t\tor 'fxprog' (xvroutine w/ FORTRAN dependancies)\n  [lib]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "imkmf", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "imkmf.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "imkmf: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "imkmf.ans");
		}

	     }

	}

	/*
	 * allocate the imkmf structure
	 */
	imkmf = (imkmf_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (imkmf_struct));

	/*
	 * get optional arguments for imkmf
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	imkmf->name_flag = vget_string(fid, prompt_flag,
	"-name", name_pstr, &(imkmf->name_string),
	name_def);

	if (prompt_flag == FALSE)
	{
	    if ((imkmf->name_flag == 1)&&(imkmf->name_string == NULL))
    	{
		fprintf(stderr, "imkmf:\n");
		fprintf(stderr, "you must specify a name following '-name'\n");
		gw_usage();
		exit(1);
		}
	}
	imkmf->toolbox_flag = vget_string(fid, prompt_flag,
	"-toolbox", toolbox_pstr, &(imkmf->toolbox_string),
	toolbox_def);

	if (prompt_flag == FALSE)
	{
	    if ((imkmf->toolbox_flag == 1)&&(imkmf->toolbox_string == NULL))
    	{
		fprintf(stderr, "imkmf:\n");
		fprintf(stderr, "you must specify a name following '-toolbox'\n");
		gw_usage();
		exit(1);
		}
	}
	imkmf->o_flag = vget_outfile(fid, prompt_flag,
	"-o", o_pstr, &(imkmf->o_file))
;


	/*
	 * get optional toggles for imkmf
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		imkmf->type_flag = vget_string(fid, prompt_flag,
		"-type", type_pstr, &(imkmf->type_toggle),
		"lib");

		if (((strcmp(imkmf->type_toggle, "lib") == 0)) || 
		     ((strcmp(imkmf->type_toggle, "dir") == 0)) || 
		     ((strcmp(imkmf->type_toggle, "script") == 0)) || 
		     ((strcmp(imkmf->type_toggle, "prog") == 0)) || 
		     ((strcmp(imkmf->type_toggle, "fprog") == 0)) || 
		     ((strcmp(imkmf->type_toggle, "xprog") == 0)) || 
		     ((strcmp(imkmf->type_toggle, "fxprog") == 0)))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		imkmf->type_flag = vget_string(fid, prompt_flag,
		"-type", type_pstr, &(imkmf->type_toggle),
		"lib");

		if (((strcmp(imkmf->type_toggle, "lib") != 0)) && 
		     ((strcmp(imkmf->type_toggle, "dir") != 0)) && 
		     ((strcmp(imkmf->type_toggle, "script") != 0)) && 
		     ((strcmp(imkmf->type_toggle, "prog") != 0)) && 
		     ((strcmp(imkmf->type_toggle, "fprog") != 0)) && 
		     ((strcmp(imkmf->type_toggle, "xprog") != 0)) && 
		     ((strcmp(imkmf->type_toggle, "fxprog") != 0)))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



