 /*
  * Khoros: $Id: cp_mapdata.c,v 1.2 1991/12/18 09:56:16 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: cp_mapdata.c,v 1.2 1991/12/18 09:56:16 dkhoros Exp $";
#endif

 /*
  * $Log: cp_mapdata.c,v $
 * Revision 1.2  1991/12/18  09:56:16  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

/*
#
# FILE NAME:	cp_mapdata.c
# 
# AUTHORS:	Ron E. Neher
# 
# DATE:		3/23/89
# 
# DESCRIPTION:	Copy map data and malloc space if requested.
# 
# MODIFICATIONS: 
# 
*/

/*INCLUDE*/
#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "vdefines.h"	 	
#include "viff.h"	 	
#include <stdio.h>

#define LENGTH 512

/**************************************************************
*
* MODULE NAME: copymapdata
*
*     PURPOSE: Copy map data
*
*       INPUT: 	img1 -- original image to copy map data from
*		img2 -- pointer to copied map data
*               malloc_flg -- if set (=1) malloc room
*
*      OUTPUT: 	returns a 1 upon success and a zero upon failure.
*
* CALLED FROM:
*
* ROUTINES CALLED:
*
**************************************************************/

int
copymapdata(img1, img2, malloc_flg)
struct
xvimage	*img1,
	**img2;
int	malloc_flg;
{

long	lsize;

/* calculate room for the color map data */

    switch (img1->map_storage_type)
    {
        case VFF_MAPTYP_NONE:
	    return(1);
            break;
        case VFF_MAPTYP_1_BYTE:
            lsize = img1->map_col_size*img1->map_row_size;
            break;
        case VFF_MAPTYP_2_BYTE:
            lsize = img1->map_col_size*img1->map_row_size*sizeof(short);
            break;
        case VFF_MAPTYP_4_BYTE:
            lsize = img1->map_col_size*img1->map_row_size*sizeof(int);
            break;
        case VFF_MAPTYP_FLOAT:
            lsize = img1->map_col_size*img1->map_row_size*sizeof(float);
            break;
        case VFF_MAPTYP_DOUBLE:
            lsize = img1->map_col_size*img1->map_row_size*sizeof(double);
            break;
        case VFF_MAPTYP_COMPLEX:
            lsize = img1->map_col_size*img1->map_row_size*
		    sizeof(float)*2;
            break;
        default:
            (void) fprintf(stderr,"copymapdata: Not valid data storage \
type\n");
            return(0);
            break;
    }

     /* If map_scheme is ONEPERBAND, then need to copy all map 
      * data over to image2 
      */
    if (img1->map_scheme == VFF_MS_ONEPERBAND)
    {
      lsize *= img1->num_data_bands;
    }

    if (malloc_flg)
        if (((*img2)->maps = malloc((unsigned int) lsize)) == NULL)
        {
	    (void) fprintf(stderr,"copymapdata: Not enough memory for \
map data!\n");
	    return(0);
        }

    bcopy(img1->maps, (*img2)->maps, (int) lsize);

    (*img2)->map_storage_type = img1->map_storage_type;
    (*img2)->map_row_size = img1->map_row_size;
    (*img2)->map_col_size = img1->map_col_size;

    return(1);
}
