 /*
  * Khoros: $Id: pro_map_co.c,v 1.1 1991/05/10 15:40:47 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: pro_map_co.c,v 1.1 1991/05/10 15:40:47 khoros Exp $";
#endif

 /*
  * $Log: pro_map_co.c,v $
 * Revision 1.1  1991/05/10  15:40:47  khoros
 * Initial revision
 *
  */ 

/*
#
# FILE NAME:	pro_map_co.c
# 
# AUTHORS:	Tom Sauer
# 
# DATE:		6/1/89
# 
# DESCRIPTION:	Contains module proper_map_colsize().
# 
# MODIFICATIONS:
#		John Rasure updated error messages
#		Sat Jun  2 23:17:36 MDT 1990
# 
# ROUTINES:	proper_map_rowsize()
#		
*/

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */

#include "vinclude.h"	  


/**************************************************************
*
* MODULE NAME: 	proper_map_rowsize()
*
*     PURPOSE:	Check to see if map row size is correct.
*
*       INPUT:  prog 	- program name
*		*image	- viff data
*		proper_row_size - desired row_size
*		exit_flag
*
*      OUTPUT:  If exit_flag is true and match fails, an error 
*          	message is printed.
*      		If exit_flag is false and match fails, return(0).
*
*       USAGE:	If exit_flag is set, The routine will print out an
*		error message and then exit().  In this case, the
*		function should be declared (void).  If exit_flag
*               is not set (equal 0) then the function should be
*		declared int.
*
*
**************************************************************/
proper_map_rowsize(prog,image,proper_row_size,exit_flag)
char  *prog;
struct xvimage *image;
unsigned long proper_row_size;
int exit_flag;
{
    if( ! (image->map_row_size==proper_row_size) ) {
	if (exit_flag == TRUE) {
	    (void) fprintf(stderr,"\nError in program %s. ",prog);
	    (void) fprintf(stderr,"viff data map is not the specified size required for this program.\n");
	    (void) fprintf(stderr,"You may need to modify or remove the map, or perhaps use different data.\n");
	    (void) fprintf(stderr,
                        "Map should contain %d rows\n",proper_row_size);
	    (void) fprintf(stderr,
                        "currently contains %d rows\n",image->map_row_size);
	    exit(1);
	}
	else return(0);
    }
return(1);
}
