 /*
  * Khoros: $Id: xvlineinfo.h,v 1.2 1991/10/01 23:53:07 khoros Exp $
  */

 /*
  * $Log: xvlineinfo.h,v $
 * Revision 1.2  1991/10/01  23:53:07  khoros
 * HellPatch2
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */


#ifndef _xvlineinfo_h_
#define _xvlineinfo_h_

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                          <<<<
   >>>>      file: xvlineinfo.h					 <<<<
   >>>>                                                          <<<<
   >>>>      contains: Information structure for passing info    <<<<
   >>>>                to and from the xvforms graphical user    <<<<
   >>>>		       interface and the UIS file via the        <<<<
   >>>>		       xvforms parsing and deparsing routines    <<<<
   >>>>                                                          <<<<
   >>>>      date: 11/5/88                                       <<<<
   >>>>                                                          <<<<
   >>>>      written by: Danielle Argiro and Stephanie Hallett   <<<<
   >>>>                                                          <<<<
   >>>>      modifications:                                      <<<<
   >>>>                                                          <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */

#include "xvinclude.h"


/*
 *  A Generic information structure that contains all possible
 *  information that may be contained in a line of the "knowledge base"
 *  (or xvform definition).  Thus, this single structure can be used
 *  with parsing of all types of "database" lines, regardless of the type.
 *  Which type of line this is (and therefore, which information is relevant
 *  is indicated with a flag).
 * 
 */

typedef struct {
	
	/***  general information about the selection  ***/

	int  	typeflag,  /* indicates the category to which the line of info 
			      belongs - see #defines below */
	       	activate,  /* whether this selection is activated */
		selected,  /* whether this selection is selected  */
		optional,  /* whether this selection is optional */
		opt_sel,   /* whether this optional selection has 
			      been selected*/

		live;      /* whether this selection is "live"  */

	float	width, height, x, y,  /* geometry specs wrt parent window */
		xpos, ypos;           /* x & y position of selection wrt 
					 current window */

	char    *title,	       /* name of the pane/button/toggle/widget */
		*description,  /* string providing info about selection */
		*variable,     /* variable name (how will we use this?) */ 
		*prompt,       /* any prompt necessary */
		*routine,      /* name of routine to execute */
		*help_file;    /* file with help text */

	/***  values for input provided through xvforms ***/

	char   *filename,      /* filename - this could be for an input file,
				  output file, or journal file  */
	       *string_val;     /* string value */

	int    int_val;        /* integer value */
	float  float_val;      /* float value */
	int    toggle_val;     /* toggle value (1 to N) */
	int    logical_val;    /* logical value (1 or 0) */
	int    cycle_val;      /* cycle value (1 to N) */
	int    list_val;      /* list (string) value (1 to N) */

	/***  defaults for form selections ***/

	char    *string_def;   /* default string value */ 
	char    *file_def;     /* default input, output or journal file */ 
	int     int_def;       /* default value of integer */
	int     logical_def;   /* default value of boolean */
	float   float_def;     /* default value of float */
	int     toggle_def;    /* default value of toggle switch */
		 
	/***  lower and upper bounds ***/

	int     lower_int, upper_int;
	float   lower_float, upper_float;
	int     cycle_num;
	int     list_num;
		
	/***  other various & sundry information ***/

	char  *path, *directory;  /* path & directory of global input directory
				     or global output directory */

	int	exec_bg;	  /* execute a routine in background */
        float   version;          /* version & release number for
				     the current implementation of xvforms */

	char   *literal;	  /* the literal string that appears in an
				     ascii widget - may be an unevaluated
				     expression, or simply the string rep.
				     of an int or float value */

	char   *val_labels[20];   /* on a logical or cyclic selection, 
				     the labels on the value widget 
				     representing integer values, 
				     (e.g, "False" and "True" for a logical,
				     "One", "Two", "Three" for a cyclic, etc) */

	int    exec_type;	  /* type of execution for a routine selection -
				     used by cantata to tell if a routine should
				     be re-run after every execution */

        Widget workspace;         /* for when the -w line is used */

	char   *lib_call;

	int	file_type;	  /* for -I and -O : 
				    the type of input or output file */

	int	write;		  /* should ALWAYS be 0 unless we are going
				     to write out a new UIS file */
	} Line_Info;


/*
 *
 *  The first element of the line_info structure is the "typeflag".  Each
 *  particular line in the xvform description (database) varies greatly 
 *  according to what type of xvform user interface mechanism it is describing.
 *  
 *  For instance, a database line describing a "Quit" button has much less
 *  (and different) information than a toggle selection between 5 integers.
 *  Since the line_info structure is generic to all lines of the data base, 
 *  some of the information will be irrelevant to each of the database lines.
 *  Thus, some way of indicating which category we are in is necessary.
 *
 *  The following are the different categories that database lines fall into,
 *  and are #defined to possible values that "typeflag" can take on:
 *
 */


/*   form description controlling flags */

#define	StartForm	1	/*  -F  : start of knowledge base structure */	
#define StartMaster     2       /*  -S  : start of master form  definition */
#define StartSubMenu    3       /*  -D  : start of subform definition */
#define StartSubForm    4       /*  -M  : start of subform definition */
#define	StartGuide	5	/*  -G  : description of a guiding pane */	
#define	StartPane	6	/*  -P  : description of a pane */	
#define End             7       /*  -E  : end any database structure  */


/*   on Master Form */

#define SubFormButton   8	/*  -d  : subform button on Main form  */
#define MasterAction    9	/*  -n  : action button on Main form  */
#define PsuedoSubForm   10	/*  -u  : psuedo subform button on Main form  */
#define IncludeSubForm	11	/*  -k  : include subform*/


/*   on Guide Pane */

#define	GuideButton	12	/*  -g  : guiding button controls which pane */	
#define	QuitForm	13	/*  -Q  : quit the sub form */	
#define SubformAction   14      /*  -m  : action button on guide pane */


/*   on workspace panes */

#define	InputFile	15	/*  -I  : input file option */	
#define	OutputFile	16	/*  -O  : output file option */	
#define IntegerOpt   	17	/*  -i  : integer input option */
#define FloatOpt   	18 	/*  -f  : float input option */
#define StringOpt   	19	/*  -s  : string input option */
#define LogicOpt        20      /*  -l  : boolean input option */
#define Toggle   	21	/*  -T  : toggle switch option */
#define Routine      	22	/*  -R  : execute a routine  */
#define HelpSel   	23	/*  -H  : print out doc/man/help pages */
#define Blank		24	/*  -b  : blank line  */
#define PaneAction	25	/*  -a  : action button  on workspace pane */
#define MutExcl		26	/*  -C  : mutually exclusive group on pane */
#define Cycle		27	/*  -c  : cyclic selection */
#define IncludePane	28	/*  -p  : include pane file */
#define WorkWidget	29	/*  -w  : workspace widget */
#define LibCall		30	/*  -L  : library call */
#define List		31	/*  -x  : list selection */
#define AnswerInfile	32	/*  -A  : answer input file option */
#define AnswerOutfile	33	/*  -Z  : answer output file option */


/*
 *
 *	SIMPLIFIED MODEL  FORM
 *
 *
 *	-F  { Master Form }
 *
 *	   -S   { indicate Sub forms }
 *
 *	      -d  { button to bring up Sub form 1 }
 *	      -d  { button to bring up Sub form 2 }
 *	      -d  { button to bring up Sub form 3 }
 *	      -n  { action button on Master Form }
 *	      -H  { help }
 *	      -Q  { quit }
 *
 *	   -E  { end  of Master Form definition itself }
 *
 *	   -M  { definition of Sub form 1 }
 *	
 *	      -G  { guide pane of Sub form 1 }
 *
 *		 -g { button to bring up Pane 1}
 *		 -g { button to bring up Pane 2}
 *		 -g { button to bring up Pane 3}
 *		 -m { action button on guide pane}
 *	         -H  { help }
 *	         -Q  { quit }
 *
 *	      -E  { end of Guide Pane definition for Sub Form 1 }
 *	     
 *	      -P  { Pane 1 of Subform 1 }
 *
 *		 -I { Input File }  
 *		 -O { Output File }  
 *		 -i { integer }  
 *		 -f { float }  
 *		 -s { string }  
 *		 -l { logical }  
 *		 -b { blank }  
 *		 -a { action }  
 *		 
 *		 -T {integer toggle}
 *		    -i {integer 1}
 *		    -i {integer 2}
 *		    -i {integer 3}
 *		 -E {end opf toggle}
 *
 *	      -E {end of Pane 1 of Subform 1}
 *
 *	      -P { Pane 2 of Subform 1 }
 *		.
 *		.
 *		.
 *	      -E {end of Pane 2 of Subform 1}
 *
 *	      -P { Pane 3 of Subform 1 }
 *		.
 *		.
 *		.
 *	      -E {end of Pane 3 of Subform 1}
 *
 *	   -M  { defintion of Sub form 2 }
 *		.
 *		.
 *		.
 *	   -E  { end of definition of Sub form 2 }
 *
 *	   -M  { defintion of Sub form 3 }
 *		.
 *		.
 *		.
 *	   -E  { end of definition of Sub form 3 }
 *
 *	-E { end of Form definition as a whole }
 */	 
#endif /* _xvlineinfo_h_ */
/* Don't add after the endif */
