.so include.n
.fo ``-A.%-``
.bp
.pn 1
.po
.nh
.ls 2
.sp 2
.ce
Appendix A
.ce
.he ``muTENSOR Switches``
.pp
There are a number of switches in muTENSOR which control various aspects of
the system's operation. These switches are described briefly below. Switches
are set by the function \*BON\fP, and cleared with the function \*BOFF\fP.
The internal switch name is prepended by a '#'. Note that many other muMATH
and muTENSOR control variables begin with a '#' and others end with a '#'.
Descriptions are for the default value.
.in 4
.br
.ti 0
\*BAUTOGARB\fP [FALSE] - causes the system to call the virtual memory
garbage collector after \*BMAPFI\fP has been applied to an object on
disk.
.br
.ti 0
\*BDIFTMP\fP [FALSE] - causes the system to always use a temporary object when
computing normal derivatives. This is useful when the same derivative appears
many times in an expression, the system can re-use the temporary with no
new calculation. Except in this case, it is often faster to avoid the
temporary object.
.br
.ti 0
\*BETIME\fP [TRUE] - causes the printing of elapsed times after each muTENSOR
function finishes.
.br
.ti 0
\*BEXTENDEDSUM\fP [FALSE] - allows contractions over indices which are both
covariant or contravariant.
.br
.ti 0
\*BFLGDOT\fP [FALSE] - forces printing of the current index for all indexed
assignment operations, even those started inside muTENSOR functions. Allows
the user to see the progress of a calculation.
.br
.ti 0
\*BHCPY\fP [FALSE] - changes the escape codes on output to be those for a hardcopy
device. The hardcopy codes are in the variables UPCURSORH and DNCURSORH;
the lengths of these are in UPSEQLENH and DNSEQLENH. Variables of the
same form but without the
trailing 'H' are for normal CRT output. The default printer controls
are for the DEC LA50 printer, and are defined in the following fashion
(note that ESC is defined as the ASCII escape character):
.sp 1
UPCURSORH: COMPRESS (LIST (ESC, 'L))$
.br
DNCURSORH: COMPRESS (LIST (ESC, 'K))$
.sp 1
The user may construct the required escape sequences in the same way
for any other kind of printer, ensuring that the lengths of these
sequences are properly reflected in UPSEQLENH and DNSEQLENH.
.br
.ti 0
\*BIPROP\fP [TRUE] - causes printing of the property list when examining an
object.
.br
.ti 0
\*BPRETTYP\fP [TRUE] - causes the system to use escape codes to make super-
and sub-scripts. When off, output reverts to the normal one line format.
.br
.ti 0
\*BREWRITE\fP [TRUE] - causes the right hand expression of a :: operation
to be echoed in the current print style.
.br
.ti 0
\*BUSEDISK\fP [FALSE] - forces all newly created objects to have their
elements stored in a disk file. See Virtual Memory above.
.br
.ti 0
\*BXEVAL\fP [FALSE] - forces an extra evaluation when reading an
element from an object to include any recent variable redefinitions.
.br

