/**********************************************************************
MPEG-4 Audio VM

This software module was originally developed by
  Y.B. Thomas Kim and S.H. Park (Samsung AIT)
and edited by
  Y.B. Thomas Kim (Samsung AIT) on 1997-11-06

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard. ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation. Copyright is not released for non MPEG-2
NBC/MPEG-4 Audio conforming products. The original developer retains
full right to use the code for his/her own purpose, assign or donate
the code to a third party and to inhibit third party from using the
code for non MPEG-2 NBC/MPEG-4 Audio conforming products. This
copyright notice must be included in all copies or derivative works.

Copyright (c) 1997.

**********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "sam_encode.h"

static int swb_offset_long[50]={0,
	  4,   8,  12,  16,  20,  
	 24,  28,  32,  36,  40,
	 48,  56,  64,  72,  80, 
     88,  96, 108, 120, 132, 
	144, 160, 176, 196, 216, 
	240, 264, 292, 320, 352, 
	384, 416, 448, 480, 512, 
	544, 576, 608, 640, 672, 
	704, 736, 768, 800, 832, 
	864, 896, 928, 1024
};

static int	swb_offset_short[15]={0,
	 4, 8, 12, 16, 20, 28, 36, 44, 56, 68, 80, 96, 112, 128
};


static int			sample[2][1024];
static int			tmpspl[1024];
static int			tempband[1024];
static int			scf[2][112];
static int			index2cband[2][1024];

#ifdef __cplusplus
extern "C" {
#endif

static int get_region_info(int groupInfo[], int s[], int e[]);
static int my_log2(int value);

#ifdef __cplusplus
}
#endif

int sam_encode_data(int common_window,
		int	windowSequence[],
		int scaleFactors[][112],
		int groupInfo[][8],
		int quant[][1024],
		int maxSfb[],
		int swb_offset[][112],
		int	stereo_mode,
		int	stereo_info[],
		int	ubits,
		int abits,
		int i_ch,
		int nch,
		int w_flag)
{
	int		i, j, k, ch;
	int		b, w;
	int		qband, cband;
	int		frame_length;
	int		band_snf[2][200];
	int		max;
	int		end_cband;
	int		start_i, end_i;
	int		num_window_group[2], s[2][8], e[2][8];
	int		which_model[2][200];


	for(ch = i_ch; ch < nch; ch++) {

		for (i = 0; i < 200; i++)
			band_snf[ch][i] = 0;

		if(windowSequence[ch] == EIGHT_SHORT_SEQUENCE) {
			num_window_group[ch] = get_region_info(groupInfo[ch]+1, s[ch], e[ch]);

			for(i = 0;i < 1024; i++) {
				tempband[i] = -1;
				index2cband[ch][i] = -1;
			}

			/* reshuffling */
			k = 0;
			for(w = 0; w < num_window_group[ch]; w++)
				for(qband = 0; qband < 14; qband++) for(b = s[ch][w]; b < e[ch][w]; b++)
   					for (i=swb_offset_short[qband]; i<swb_offset_short[qband+1]; i++)
						tmpspl[128*b+i] = quant[ch][k++];

    		for(qband = 0; qband < maxSfb[ch]; qband++)  {
    			for (i=swb_offset_short[qband]; i<swb_offset_short[qband+1]; i+=4) 
       			for(w=0; w<num_window_group[ch]; w++)  {
					cband = i*(e[ch][w]-s[ch][w])/32;
					max = 0;
					for (b=s[ch][w]; b<e[ch][w]; b++) {
						for (k=0; k<4; k++) {
							if (abs(tmpspl[128*b+i+k])>max) 
								max = abs(tmpspl[128*b+i+k]);
							tempband[128*b+i+k] = 24*w+cband;
						}
					}
					if (max > 0) max = my_log2(max);
					if(max > band_snf[ch][24*w+cband])
						band_snf[ch][24*w+cband] = max;
    			}
			}

			j = 0;
			for(i = 0; i < swb_offset_short[maxSfb[ch]]; i+=4) {
				for(b = 0; b < 8; b++) {
					for(k = 0; k < 4; k++, j++) {
						sample[ch][j] = tmpspl[128*b+i+k];
						index2cband[ch][j] = tempband[128*b+i+k];
					}
				}
			}

		} else {
			num_window_group[ch] = 1;
			for (i = 0; i < 1024; i++)
				sample[ch][i] = quant[ch][i];

			end_cband = (swb_offset[ch][maxSfb[ch]]+31)/32;
			for (cband = 0; cband < end_cband; cband++) {
				start_i = cband * 32;
				end_i =   (cband+1) * 32;
				max = 0;
				for (i = start_i; i < end_i; i++) {
					if (abs(sample[ch][i])>max) 
						max = abs(sample[ch][i]);
				}
				band_snf[ch][cband] = 0;
				if(max > 0) band_snf[ch][cband] = my_log2(max);
			}
		}

		j = 0;
		for (w = 0; w < num_window_group[ch]; w++) {
			for (i = 0; i < maxSfb[ch]; i++) {
				scf[ch][j++] = scaleFactors[ch][(w*14)+i];
			}
		}

		for (i = 0; i < 200; i++) 
			which_model[ch][i] = 0;
	}


	/********** B I T S T R E A M   M A K I N G *********/
	frame_length = sam_encode_bsac(common_window, windowSequence, sample, band_snf,
			scf, maxSfb, num_window_group, swb_offset, which_model,
			stereo_mode, stereo_info, ubits, abits, i_ch, nch, w_flag);


	return frame_length;
}

sam_i2cb(int ch, int i)
{
	return index2cband[ch][i];
}

static int get_region_info(int groupInfo[], int s[], int e[])
{
	int reg, b;

	reg = 0;
	s[0] = 0;
	for (b=0; b<7; b++) {
		if (groupInfo[b]==0) {
			s[reg+1] = e[reg] = b+1;
			reg++;
		}
	}
	e[reg] = 8;

	return (reg + 1);
}

static int my_log2(int value)
{
	int	i, step;

	if(value < 0) {
		fprintf(stderr, "my_log2:error : %d\n", value);
		return 0;
	}
	if(value == 0)	return 0;

	step = 2;
	for(i = 1; i < 24; i++) {
		if(value < step) return i;
		step *= 2;
	}
	return ( 1 + (int)(log10((double)value)/log10(2.0)));
}
