/* this is a subset with changes  of: */
/*======================================================================*/
/*                                                                      */
/* Standard MIDI File Data Structures                                   */
/*                                                                      */
/* Copyright 1990 by Music Quest, Inc - All rights reserved             */
/*                                                                      */
/*======================================================================*/
/*===================================*/
/*                                   */
/* Standard MIDI file block          */
/*                                   */
/* Represents an opened SMF          */
/*                                   */
/*===================================*/
class smfblok
  {
    protected:

    long hc_chunklng;                   /* header chunk length */
    char hc_type[4];                    /* MThd chunk type */
    unsigned hc_format;                 /* format 0,1, or 2 */
    unsigned hc_ntrks;                  /* number of tracks */
    unsigned hc_division;               /* generally, ticks per beat */
    unsigned char *smf_data;        /* pointer to file data */
    int smf_fh;                         /* file handle */
    int smf_open;                       /* smfblok opened flag */

    public:

    smfblok();
    ~smfblok();
    int open_std_mfile(unsigned char *filename);
    int close_std_mfile();
    unsigned char  *smflocate_track(unsigned n);
    int get_hc_format() {return(hc_format);}
    int get_hc_ntrks() {return(hc_ntrks);}
    int get_hc_division() {return(hc_division);}
    int get_smf_fh() {return(smf_fh);}
  };

/*===================================*/
/*                                   */
/* Track I/O control block           */
/*                                   */
/* Used to read from a track         */
/*                                   */
/*===================================*/
class tiob                              /* track I/O control block */
  {
    protected:

    unsigned char  *t_rwaddr;        /* next read/write address */
    unsigned char  *t_ceaddr;        /* current read/write address */
    unsigned char  *t_trkaddr;       /* track base address */
    long t_length;                      /* existing track length */
    long t_wlength_fptr;                /* ptr to write length field in file */
    smfblok *t_smfb;                    /* associated smfblok */
    unsigned char t_cmd;                /* current cmd state (last cmd sent) */
    unsigned char t_cmdl;               /* cmd data length for current state */
    unsigned char t_mdata[4];           /* MIDI data for current event */

    unsigned t_open : 1;                /* tiob opened flag */
    unsigned t_eof : 1;                 /* end of file indicator */
    unsigned t_rwflag : 1;              /* read/write flag */
    unsigned t_first_event : 1;         /* force running status for first event */

    public:

    tiob();
    ~tiob();
    int open_track(smfblok *smfb, unsigned n);
    int close_track();
    unsigned char read_byte();
    int read_next_event(unsigned char *etype, long *etime,
			unsigned char *estatus, unsigned char  *(*edata), unsigned *elng);
    long smfread_vlq();
    long get_t_length() {return(t_length);}
    int get_t_eof() {return(t_eof);}
    void rewind_track();
  };

/*===================================*/
/*                                   */
/* Standard MIDI file events         */
/*                                   */
/*===================================*/
#define MIDIEVENT       0x80
#define SYSEXEVENT      0xF0
#define METAEVENT       0xFF
#define METASEQN        0
#define METATEXT        1
#define METACOPYR       2
#define METATNAME       3
#define METAINAME       4
#define METALYRIC       5
#define METAMARKER      6
#define METACUEPT       7
#define METACHANPFX     0x20
#define METAEOT         0x2F
#define METATEMPO       0x51
#define METASMPTEOFF    0x54
#define METATIMESIG     0x58
#define METAKEYSIG      0x59
#define METASEQEVENT    0x7F

/*===================================*/
/*                                   */
/* Function prototypes               */
/*                                   */
/*===================================*/
long smfmakelong(unsigned char *s);
unsigned smfmakeint(unsigned char *s);
unsigned char *write_vlq(unsigned char *s, unsigned long v);
unsigned char *write_long(unsigned char *s, unsigned long v);

