
$stdunit

*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************



CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Subroutine Crvpl (X, Y, Numpt, Numcrv, term, CrvTyp, NumTic, 
     +                   shadng, fid)


*********************************************************
*                                                       *
*  Subroutine Interpolation_Routine                     *
*                                                       *
*    The following routine is the driver used to call   *
*    "Spcoef" and "Svalue", used to interpolate the     *
*    data stored in the "X" and "Y" arrays. The routine *
*    expects the "X" points to be stored in ascending   *
*    order.                                             *
*                                                       *
*    The two subroutines were taken from the mathstat   *
*    library stored on UNMC:                            *
*                                                       *
*        /u2/mathstat/Courses/ma375/spline.f            *
*                                                       *
*********************************************************



        Integer         max, num, maxC
        Common /Object/ max, num, maxC
        Save   /Object/

        Real           WXmax, WXmin, WYmax, WYmin
        Common /windw/ WXmax, WXmin, WYmax, WYmin
        Save   /windw/

        Real       X(max, num), Y(max, num), Xtemp(10000), Ytemp(10000),
     +             Xint(10000,3), Yint(10000,3)
	Common /nada/ Xtemp, Ytemp, Xint, Yint
        Integer    NumCrv, Numpt(num), term, Ntemp(3), CrvTyp(3)
	  Integer    NumTic(2), fid
        Logical    shadng

        Real       B(10000), C(10000), D(10000), Dx, Intv, ABS
        Integer    N,INTERV,IFLAG,I,J,Nint
 
*       (* Assign values for N and arrays Xtemp and Ytemp. *)
        DO 100 J = 1, NumCrv
          N= Numpt(J)
          DO 200 I = 1,N
            Xtemp(I) = X(I,J)
            Ytemp(I) = Y(I,J)
  200     CONTINUE

*         (* Call SPCOEF to approximate the B,C,D vectors. *)
          Call Spcoef(N,Xtemp,Ytemp,B,C,D,IFLAG)
 
          IF (IFLAG .EQ. 0) THEN
            IF (N .GT. 250) THEN
              Nint = N
            ELSE
              Nint = 250
            ENDIF

   20       Dx = ABS(WXmax - WXmin)/(Nint -1)
            Intv = WXmin
            DO 300 I = 1,Nint
              Xint(I,J) = Intv
              Call Svalue(N,Xtemp,Ytemp,B,C,D,Xint(I,J),INTERV,
     +                    Yint(I,J),IFLAG)
              Intv = Intv + Dx
  300       CONTINUE
            Ntemp(J) = Nint
          ELSE
*           (* The curves couldn't be interpolated, so the old curves
*              are passed again. *)
            DO 400 I = 1, Numpt(J)
              Xint(I,J) = X(I,J)
              Yint(I,J) = Y(I,J)
  400       CONTINUE
            Ntemp(J) = Numpt(J)
          ENDIF

  100   CONTINUE

*       (* Call the plotting routine with the interpolated
*          curves. *)
        Call Plot(Xint, Yint, Ntemp, NumCrv, term, CrvTyp, NumTic, 
     +            shadng, fid)

        RETURN
        END
