#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************




CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Subroutine Termcp (term)


***************************************************************
*                                                             *
*  Subroutine Terminal_Type                                   *
*                                                             *
*     Is used to prompt the user for their terminal type.     *
*     The user is displayed a list of current terminals       *
*     and then asked to enter their terminal type.            *
*                                                             *
*     A minor amount of error checking is done, to make       *
*     sure they have entered a legitimate type. The user      *
*     also has the option of entering a "0" which indicates   *
*     that the user is not on a currently supported terminal  *
*     type.  At this time the program is terminated.          *
*                                                             *
***************************************************************


        Character*40 trmset(7)
        Integer term

        Data         trmset/'Undefined',
     +                      'Gigi (ReGIS graphics)',
     +                      'VT240 (ReGIS graphics)',
     +                      'VT240 (Tektronix emulation)',
     +                      'Tektronix 4014 (enhanced graphics)',
     +                      'Sun Workstation (w/ tektools)',
     +                      'IBM Personal Computer - color graphics'/

    1   Write (*,10) 
   10   Format (10x,'Choose  Terminal Type',//5x, 'This package ',
     +          'currently supports the',/,5x,'following types ',
     +          'of terminals:',//
     +           ,10x,'1. Gigi (ReGIS graphics)                 '//
     +           ,10x,'2. VT240 (ReGIS graphics)                '//
     +           ,10x,'3. VT240 (Tektronix emulation)           '//
     +           ,10x,'4. Tektronix 4014 (enhanced graphics)    '//
     +           ,10x,'5. Sun Workstation (w/ tektools)         '//
     +           ,10x,'6. None of the above! (Quit the program) '//)

        Write (*,20) trmset(term +1)
   20   Format (10x,'Your current terminal setting is:  ',a//
     +          ,5x,'Please enter your terminal type. (1 - 6) ...')

*       (* Get the user's response. *)  
        Read (*,'(i2)',err=1) term

*       (* See if the user needs to quit. *)
  100   IF (term .EQ. 6) THEN
          Write (*,30) 
   30     Format (//,5x,'Sorry that your terminal isn''t currently ',
     +            'supported!',/,5x,'Thank you for trying XYplot.',//)
          STOP
        ELSE IF (term .LT. 1 .OR. term .GT. 5) THEN
    2     term = 0
          Write (*,'(a1)') Char(7)
          Write (*,10)
          Write (*,20) trmset(term +1)
          Read (*,'(i2)',err=2) term
          GOTO 100 
        ENDIF

*       (* Initialize the color monitiors to a black background, with
*          white text. *)
        IF (term .EQ. 1) THEN
          Write (*,40) Char(27), Char(27), Char(92)
   40     Format (a1,'Pp S(I0) W(I7)',2a1)
        ELSE IF (term .EQ. 2 .OR. term .EQ. 3) THEN
          Write (*,50) Char(27), Char(27), Char(92), Char(27)
   50     Format (a1,'Pp S(M0(AH0L0S120)) S(M2(AH100L100S0))',3a1,'[!p')
        ENDIF

        RETURN
        END
