/* Conversion of files between different charsets and usages.
   Copyright (C) 1990 Free Software Foundation, Inc.
   Francois Pinard <pinard@iro.umontreal.ca>, 1988.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define STEP	latin1_ibmpc
#include <stdio.h>
#include "common.h"

static const char *translation_table[128] =
  {
    NULL,			/* \200 */
    NULL,			/* \201 */
    NULL,			/* \202 */
    NULL,			/* \203 */
    NULL,			/* \204 */
    NULL,			/* \205 */
    NULL,			/* \206 */
    NULL,			/* \207 */
    NULL,			/* \210 */
    NULL,			/* \211 */
    NULL,			/* \212 */
    NULL,			/* \213 */
    NULL,			/* \214 */
    NULL,			/* \215 */
    NULL,			/* \216 */
    NULL,			/* \217 */
    NULL,			/* \220 */
    NULL,			/* \221 */
    NULL,			/* \222 */
    NULL,			/* \223 */
    NULL,			/* \224 */
    NULL,			/* \225 */
    NULL,			/* \226 */
    NULL,			/* \227 */
    NULL,			/* \230 */
    NULL,			/* \231 */
    NULL,			/* \232 */
    NULL,			/* \233 */
    NULL,			/* \234 */
    NULL,			/* \235 */
    NULL,			/* \236 */
    NULL,			/* \237 */

    "\377",			/* \240  \  */
    "\255",			/* \241  !` */
    "\233",			/* \242  \cent */
    "\234",			/* \243  \pound */
    NULL,			/* \244 */
    "\235",			/* \245  \yen */
    NULL,			/* \246 */
    NULL,			/* \247 */
    NULL,			/* \250 */
    NULL,			/* \251 */
    "\246",			/* \252  a_ */
    "\256",			/* \253  `` */
    "\252",			/* \254  \neg */
    NULL,			/* \255 */
    NULL,			/* \256 */
    NULL,			/* \257 */
    "\370",			/* \260  \deg */
    "\361",			/* \261  +- */
    "\375",			/* \262  ^2 */
    NULL,			/* \263 */
    NULL,			/* \264 */
    "\346",			/* \265  \micro */
    NULL,			/* \266 */
    "\372",			/* \267  \cdot */
    NULL,			/* \270 */
    NULL,			/* \271 */
    "\247",			/* \272  o_ */
    "\257",			/* \273  '' */
    "\254",			/* \274  1/4 */
    "\253",			/* \275  1/2 */
    NULL,			/* \276 */
    "\250",			/* \277  ?' */
    NULL,			/* \300 */
    NULL,			/* \301 */
    NULL,			/* \302 */
    NULL,			/* \303 */
    "\216",			/* \304  A" */
    "\217",			/* \305  AA */
    "\222",			/* \306  AE */
    "\200",			/* \307  C, */
    NULL,			/* \310 */
    "\220",			/* \311  E' */
    NULL,			/* \312 */
    NULL,			/* \313 */
    NULL,			/* \314 */
    NULL,			/* \315 */
    NULL,			/* \316 */
    NULL,			/* \317 */
    NULL,			/* \320 */
    "\245",			/* \321  N~ */
    NULL,			/* \322 */
    NULL,			/* \323 */
    NULL,			/* \324 */
    NULL,			/* \324 */
    "\231",			/* \326  O" */
    "\366",			/* \327  \div */
    NULL,			/* \330 */
    NULL,			/* \331 */
    NULL,			/* \332 */
    NULL,			/* \333 */
    "\232",			/* \334  U" */
    NULL,			/* \335 */
    NULL,			/* \336 */
    "\341",			/* \337  \ss */
    "\205",			/* \340  a` */
    "\240",			/* \341  a' */
    "\203",			/* \342  a^ */
    NULL,			/* \343 */
    "\204",			/* \344  a" */
    "\206",			/* \345  aa */
    "\221",			/* \346  ae */
    "\207",			/* \347  c, */
    "\212",			/* \350  e` */
    "\202",			/* \351  e' */
    "\210",			/* \352  e^ */
    "\211",			/* \353  e" */
    "\215",			/* \354  i` */
    "\241",			/* \355  i' */
    "\214",			/* \356  i^ */
    "\213",			/* \357  i" */
    NULL,			/* \360 */
    "\244",			/* \361  n~ */
    "\225",			/* \362  o` */
    "\242",			/* \363  o' */
    "\223",			/* \364  o^ */
    NULL,			/* \365 */
    "\224",			/* \366  o" */
    NULL,			/* \367 */
    NULL,			/* \370 */
    "\227",			/* \371  u` */
    "\243",			/* \372  u' */
    "\226",			/* \373  u^ */
    "\201",			/* \374  u" */
    NULL,			/* \375 */
    NULL,			/* \376 */
    "\230",			/* \377  y" */
  };

void
STEP (FILE *input_file, FILE *output_file)
{
  int input_char;		/* current character */
  const char *output_string;	/* translated characters */

  while (input_char = getc (input_file), input_char != EOF)
    if ((input_char & 0377) < 0200)
      if (input_char == '\n')
	{
	  putc (0x0D, output_file);
	  putc (0x0A, output_file);
	}
      else
	putc (input_char, output_file);
    else
      if (output_string = translation_table[input_char & 0177], output_string)
	while (*output_string)
	  {
	    putc (*output_string, output_file);
	    output_string++;
	  }
}
