/* alias.c, created from alias.def. */
#line 33 "(null)alias.def"

#include <stdio.h>
#include "../shell.h"
#include "../alias.h"

extern int interactive;
static void print_alias ();

/* Hack the alias command in a Korn shell way. */
alias_builtin (list)
     WORD_LIST *list;
{
  int any_failed = 0;

  if (!list)
    {
      register int i;

      if (!aliases)
	return (EXECUTION_FAILURE);

      for (i = 0; aliases[i]; i++)
	print_alias (aliases[i]);
    }
  else
    {
      while (list)
	{
	  register char *value, *name = list->word->word;
	  register int offset;

	  for (offset = 0; name[offset] && name[offset] != '='; offset++);

	  if (offset && name[offset] == '=')
	    {
	      name[offset] = '\0';
	      value = name + offset + 1;

	      add_alias (name, value);
	    }
	  else
	    {
	      ASSOC *t = find_alias (name);
	      if (t)
		print_alias (t);
	      else
		{
		  if (interactive)
		    builtin_error ("`%s' not found", name);
		  any_failed++;
		}
	    }
	  list = list->next;
	}
    }
  if (any_failed)
    return (EXECUTION_FAILURE);
  else
    return (EXECUTION_SUCCESS);
}

#line 101 "(null)alias.def"
/* Remove aliases named in LIST from the aliases database. */
unalias_builtin (list)
     register WORD_LIST *list;
{
  register ASSOC *alias;
  int any_failed = 0;

  while (list && *list->word->word == '-')
    {
      register char *word = list->word->word;

      if (strcmp (word, "-a") == 0)
	{
	  delete_all_aliases ();
	  list = list->next;
	}
      else if (strcmp (word, "--") == 0)
	{
	  list = list->next;
	  break;
	}
      else
	{
	  bad_option (word);
	  return (EXECUTION_FAILURE);
	}
    }

  while (list)
    {
      alias = find_alias (list->word->word);

      if (alias)
	remove_alias (alias->name);
      else
	{
	  if (interactive)
	    builtin_error ("`%s' not an alias", list->word->word);

	  any_failed++;
	}

      list = list->next;
    }

  if (any_failed)
    return (EXECUTION_FAILURE);
  else
    return (EXECUTION_SUCCESS);
}

/* Return a new string which is the quoted version of STRING. */
static char *
single_quote (string)
     char *string;
{
  register int i, j, c;
  char *result;

  result = (char *)xmalloc (3 + (2 * strlen (string)));

  result[0] = '\'';

  for (i = 0, j = 1; string && (c = string[i]); i++)
    {
      result[j++] = c;

      if (c == '\'')
	result[j++] = '\'';
    }

  result[j++] = '\'';
  result[j] = '\0';

  return (result);
}

/* Output ALIAS in such a way as to allow it to be read back in. */
static void
print_alias (alias)
     ASSOC *alias;
{
  char *value = single_quote (alias->value);

  printf ("alias %s=%s\n", alias->name, value);
  free (value);

  fflush (stdout);
}
