#define INCL_GPILCIDS
#define INCL_WINATOM
#define INCL_WINDIALOGS
#define INCL_WINLISTBOXES
#define INCL_WINMENUS
#define INCL_WINSCROLLBARS
#define INCL_WINWINDOWMGR
#include <os2.h>
#include <stdio.h>
#include <string.h>
#include "rc.h"

HWND queryLbScroll(HWND hwndLb,BOOL bWantVert)
//-------------------------------------------------------------------------
// This function returns the specified scrollbar for a listbox.
//
// Input:  hwndLb - handle of the listbox window to query
//         bWantVert - TRUE if the vertical scrollbar is desired, FALSE if
//                     horizontal
// Returns:  handle of the scrollbar window if successful, NULLHANDLE
//           otherwise
//-------------------------------------------------------------------------
{
   ULONG ulWantStyle;
   HENUM heEnum;
   HWND hwndScroll;
   CHAR achClass[256];
   ATOM aClass;
   ULONG ulStyle;

   ulWantStyle=bWantVert?SBS_VERT:0;

   //----------------------------------------------------------------------
   // Enumerate all of the children of the scrollbar
   //----------------------------------------------------------------------
   heEnum=WinBeginEnumWindows(WinWindowFromID(hwndWnd,DLG_LB_TEST));

   hwndScroll=WinGetNextWindow(heEnum);
   while (hwndScroll!=NULLHANDLE) {
      //-------------------------------------------------------------------
      // Query the class name.  Public window classes have class names
      // which although they are in the for "#dddd" are really atoms.
      // Thus, we need to check the system atom table and compare the
      // result against the low word of the WC_* constant.
      //
      // Oh.  Why, you ask?  Because the numerical form of an integer
      // atom contains the number in the low word and 0xFFFF in the high
      // word.  Since all of the WC_* constants have 0xFFFF in the high
      // word, they are all integer atoms.
      //-------------------------------------------------------------------
      WinQueryClassName(hwndScroll,sizeof(achClass),achClass);

      aClass=WinFindAtom(WinQuerySystemAtomTable(),achClass);
      if (aClass==LOUSHORT(WC_SCROLLBAR)) {
         //----------------------------------------------------------------
         // We found a scrollbar; now check to see if it is the right
         // type.
         //----------------------------------------------------------------
         ulStyle=WinQueryWindowULong(hwndScroll,QWL_STYLE);
         if ((ulStyle & SBS_VERT)==ulWantStyle) {
            break;
         } /* endif */
      } /* endif */

      hwndScroll=WinGetNextWindow(heEnum);
   } /* endwhile */

   WinEndEnumWindows(heEnum);
   return hwndScroll;
}

MRESULT EXPENTRY dlgProc(HWND hwndWnd,
                         ULONG ulMsg,
                         MPARAM mpParm1,
                         MPARAM mpParm2)
{
   switch (ulMsg) {
   case WM_INITDLG:
      {
         ULONG ulIndex;
         CHAR achText[256];

         for (ulIndex=1; ulIndex<=10; ulIndex++) {
            sprintf(achText,"Item %ld: this is a very very very very very long item of text",ulIndex);
            WinInsertLboxItem(WinWindowFromID(hwndWnd,DLG_LB_TEST),
                              LIT_END,
                              achText);
         } /* endfor */
      }
      break;
   case WM_MEASUREITEM:
      {
         CHAR achText[256];
         HPS hpsTest;
         FONTMETRICS fmFont;

         WinSendDlgItemMsg(hwndWnd,
                           DLG_LB_TEST,
                           LM_QUERYITEMTEXT,
                           MPFROM2SHORT(SHORT1FROMMP(mpParm2),sizeof(achText)),
                           MPFROMP(achText));

         hpsTest=WinGetPS(WinWindowFromID(hwndWnd,DLG_LB_TEST));
         GpiQueryFontMetrics(hpsTest,sizeof(fmFont),&fmFont);
         WinReleasePS(hpsTest);

         return MRFROM2SHORT(fmFont.lMaxBaselineExt,
                             strlen(achText)*(fmFont.lAveCharWidth*2));
      }
   case WM_DRAWITEM:
      {
         POWNERITEM poiItem;
         CHAR achText[256];
         ULONG ulPos;
         FONTMETRICS fmFont;

         poiItem=(POWNERITEM)MPFROMP(mpParm2);

         hwndScroll=queryLbScroll(WinWindowFromID(hwndWnd,DLG_LB_TEST),FALSE);
         if (hwndScroll==NULLHANDLE) {
            WinAlarm(HWND_DESKTOP,WA_ERROR);
            return MRFROMSHORT(FALSE);
         } /* endif */

         WinSendMsg(poiItem->hwnd,
                    LM_QUERYITEMTEXT,
                    MPFROM2SHORT(poiItem->idItem,sizeof(achText)),
                    MPFROMP(achText));

         ulPos=LONGFROMMR(WinSendMsg(hwndScroll,SBM_QUERYPOS,0,0));

         GpiQueryFontMetrics(poiItem->hps,sizeof(fmFont),&fmFont);

         WinDrawText(poiItem->hps,
                     -1,
                     &achText[ulPos/(fmFont.lAveCharWidth*2)],
                     &poiItem->rclItem,
                     poiItem->fsState?CLR_WHITE:CLR_BLACK,
                     poiItem->fsState?CLR_BLACK:CLR_WHITE,
                     DT_LEFT|DT_TOP|DT_ERASERECT);

         poiItem->fsState=FALSE;
         poiItem->fsStateOld=FALSE;

         return MRFROMSHORT(TRUE);
      }
   default:
      return WinDefDlgProc(hwndWnd,ulMsg,mpParm1,mpParm2);
   } /* endswitch */

   return MRFROMSHORT(FALSE);
}

INT main(VOID)
{
   HAB habAnchor;
   HMQ hmqQueue;

   habAnchor=WinInitialize(0);
   hmqQueue=WinCreateMsgQueue(habAnchor,0);

   WinDlgBox(HWND_DESKTOP,
             HWND_DESKTOP,
             dlgProc,
             NULLHANDLE,
             DLG_MAIN,
             NULL);

   WinDestroyMsgQueue(hmqQueue);
   WinTerminate(habAnchor);
   return 0;
}
