#include "stdio.h"
#include "f2c.h"
#define PAUSESIG 15
#ifdef OS2
#define INCL_DOSFILEMGR
#undef INT
#include <os2.h>
#endif

#ifdef KR_headers
#define Void /* void */
#define Int /* int */
#else
#define Void void
#define Int int
#undef abs
#include "stdlib.h"
#include "signal.h"
extern int getpid(void), isatty(int), pause(void);
#endif

#ifdef __cplusplus
extern "C" void f_exit(void);
#else
extern VOID f_exit(Void);
#endif

static VOID waitpause(Int n)
{
return;
}

#ifdef KR_headers
VOID s_paus(s, n) char *s; ftnlen n;
#else
void s_paus(char *s, ftnlen n)
#endif
{
int i;
#ifdef OS2
FILE *console ;
#endif

fprintf(stderr, "PAUSE ");
if(n > 0)
	for(i = 0; i<n ; ++i)
		putc(*s++, stderr);
fprintf(stderr, " statement executed\n");
#ifdef OS2
/* OK, this might cause problems if we've run out of handles */
console = fopen( "con", "r" ) ;
fprintf(stderr, "To resume execution, type go.  Any other input will terminate job.\n");
fflush(stderr);
if( fgetc(console)!='g' || fgetc(console)!='o' || fgetc(console)!='\n' )
		{
		fprintf(stderr, "STOP\n");
		f_exit();
		exit(0);
		}
fprintf(stderr, "Execution resumes after PAUSE.\n");
fclose(console) ;
#else
if( isatty(fileno(stdin)) )
	{
	fprintf(stderr, "To resume execution, type go.  Any other input will terminate job.\n");
	fflush(stderr);
	if( getchar()!='g' || getchar()!='o' || getchar()!='\n' )
		{
		fprintf(stderr, "STOP\n");
		f_exit();
		exit(0);
		}
	}
else
	{
	fprintf(stderr, "To resume execution, execute a   kill -%d %d   command\n",
		PAUSESIG, getpid() );
	signal(PAUSESIG, waitpause);
	fflush(stderr);
	pause();
	}
fprintf(stderr, "Execution resumes after PAUSE.\n");
#endif
}
