/* nls.c (emx+gcc) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>
#include <sys/nls.h>
#include <emx/io.h>             /* For _trslash() */
#include <emx/locale.h>         /* For _cur_mbyte */

#define BSZ 512

static void usage (void)
{
  puts ("Usage: nls [-bfn]");
  exit (1);
}

int main (int argc, char *argv[])
{
  unsigned char inp[BSZ], buf1[BSZ], buf2[BSZ], *p;
  char drive[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME], ext[_MAX_EXT];
  char fname_flag = 0, fake_dbcs_flag = 0, no_init_flag = 0, batch_flag = 0;
  char mbyte_flag = 0;
  int i, c;

  while ((c = getopt (argc, argv, "bdfmn")) != -1)
    switch (c)
      {
      case 'b':
        batch_flag = 1;
        break;
      case 'd':
        fake_dbcs_flag = 1;
        break;
      case 'f':
        fname_flag = 1;
        break;
      case 'm':
        mbyte_flag = 1;
        break;
      case 'n':
        no_init_flag = 1;
        break;
      default:
        usage ();
      }
  if (optind != argc)
    usage ();

  if (!no_init_flag)
    _nls_init ();

  if (fake_dbcs_flag)
    {
      for (i = 0x80; i <= 0x8f; ++i)
        _nls_ctype_tab[i] |= _NLS_DBCS_LEAD;
      _cur_mbyte.mode = _MB_DBCS;
    }

  printf ("DBCS lead bytes:");
  for (i = 0; i < 256; ++i)
    if (_nls_is_dbcs_lead (i))
      printf (" 0x%.2x", i);
  printf ("\n");

  for (;;)
    {
      if (!batch_flag)
        printf ("Input: ");
      if (fgets (inp, sizeof (inp), stdin) == NULL)
        break;
      p = strchr (inp, '\n');
      if (p != NULL) *p = 0;
      if (batch_flag)
        printf ("Input:      |%s|\n", inp);
      if (mbyte_flag)
        {
          size_t len = strlen (inp);
          size_t pos = 0;

          mblen (NULL, 0);      /* Initialize shift state */
          printf ("mblen:      |");
          while (pos < len)
            {
              i = mblen (inp + pos, len - pos);
              if (i == -1)
                putchar ('-');
              else
                printf ("%d", i);
              if (i == -1)
                break;
              pos += i;
            }
          printf ("|\n");
        }
      strcpy (buf1, inp);
      strcpy (buf2, inp);
      _nls_strupr (buf1);
      _nls_strlwr (buf2);
      printf ("Upper case: |%s|\n", buf1);
      printf ("Lower case: |%s|\n", buf2);
      if (fname_flag)
        {
          strcpy (buf1, inp);
          strcpy (buf2, inp);
          _remext (buf1);
          _defext (buf2, "ext");
          printf ("_remext:    |%s|\n", buf1);
          printf ("_defext:    |%s|\n", buf2);
          p = _getext (inp);
          if (p == NULL) p = "(NULL)";
          printf ("_getext:    |%s|\n", p);
          printf ("_getname:   |%s|\n", _getname (inp));
          printf ("_splitpath:\n");
          _splitpath (inp, drive, dir, fname, ext);
          printf ("  drive:    |%s|\n", drive);
          printf ("  dir:      |%s|\n", dir);
          printf ("  fname:    |%s|\n", fname);
          printf ("  ext:      |%s|\n", ext);
          printf ("_trslash:   |%d|%d|\n",
                  _trslash (inp, strlen (inp), 0),
                  _trslash (inp, strlen (inp), 1));
          _makepath (buf1, drive, dir, fname, ext);
          if (strcmp (buf1, inp) != 0)
            printf ("_makepath:  |%s| (difference!)\n", buf1);
        }
    }
  return 0;
}
