/* strerror.c (emx+gcc) -- Copyright (c) 1990-1996 by Eberhard Mattes */

#include <stdlib.h>
#include <string.h>
#include <emx/thread.h>

char *strerror (int errnum)
{
  if (errnum >= 0 && errnum < _sys_nerr)
    return (char *)_sys_errlist [errnum];
  else
    {
      static char msg[] = "Unknown error ";
#if defined (__MT__)
      struct _thread *tp = _thread();
#define result (tp->_th_error)
#else
      static char result[32];
#endif
      memcpy (result, msg, sizeof (msg) - 1);
      _itoa (errnum, result + sizeof (msg) - 1, 10);
      return result;
    }
}
