/************************************************************
 *** OS2: This file contains additional routines          ***
 ***      only needed in the OS/2-version.                ***
 ***                                                      ***
 ***   last modified: 07/28/92                            ***
 ***   Authors:  Thilo Schuster (term@godot.stgt.sub.org) ***
 ***         Herbert Neugebauer (haen@veces.stgt.sub.org) ***
 ***                                                      ***
 ***  please send bug reports to term@godot or haen@veces ***
 ***                                                      ***
 ***  Remark: the things in os2patch.c are used in every  ***
 ***          executable, os2trn.c only in trn            ***
 ************************************************************/

#define OS2_TRN_C

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <termio.h>
#include <time.h>
#include "EXTERN.h"
#include "config.h"
#include "common.h"
#include "os2patch.h"
#include "term.h"

/*** We need prototypes for some functions ***/
extern char *filexp(char *s);
extern char *headname;

/*** And some global variables, defined somewhere else ***/
extern FILE *rcfp;
extern FILE *actfp;
extern ART_POS savefrom;

/***************************************************
 ** This function was written to replace the      **
 ** shell-script newsetup. It reads the active    **
 ** file and writes out a .newsrc file, by        **
 ** taking every group out of the active-file     **
 ** strip off the numbers after the name and      **
 ** adding a ":", so all groups are marked as     **
 ** subscribed.                                   **
 ***************************************************/

int make_newsrc(char *rcname, char *activename)
{  FILE *activefile, *rcfile;
   char tmpbuffer[80];
   char *tmpcharptr;

   if ((activefile = fos2open(activename,"r")) == NULL)
   {  fprintf(stderr,"Cannot open the ACTIVE-file.\n");
      fflush(stderr);
      return 1;   /** not successful **/
   }
   else
   {  if ((rcfile = fos2open(rcname,"w")) == NULL)
      {  fprintf(stderr,"Cannot create the .newsrc-file.\n");
         fflush(stderr);
         return 1;  /** not successful **/
      }
      else
      {  while(fgets(tmpbuffer,80,activefile))    /** read a line **/
         {  if (strtok(tmpbuffer," \r\n"))        /** cut out ng-name **/
               fprintf(rcfile,"%s:\n",tmpbuffer); /** write out name+':' **/
            else
            {  fprintf(stderr,"Perhaps bogus newsgroup-line, didn't write out the group!\n");
               fprintf(stderr,"  line:%s\n",tmpbuffer);
               fflush(stderr);
            }
         }
         fclose(rcfile);
         fclose(activefile);
      }
   }

   return 0;   /*success*/
}


/***************************************************
 ** This function was written to replace the      **
 ** shell-script's mbox.saver and norm.saver      **
 ***************************************************/

int article_saver(bool mailbox, char *fromname, char *tosavename)
{   char tmpbuffer[1023+1];     /** make it long because of long From-lines*/
    char *tmpptr;
    int  nobjread;
    FILE *readfile, *writefile;
    bool newfile = FALSE;
    time_t timeinseconds;

    if (!fromname)
       strcpy(tmpbuffer,filexp("%A"));
    else
       strcpy(tmpbuffer,fromname);
    if ((readfile = fos2open(tmpbuffer, "r")) == NULL)
    {   fprintf(stderr,"Cannot open article %s for input!\n",tmpbuffer);
    	fflush(stderr);
        return 1;
    }
    if (!tosavename)
       strcpy(tmpbuffer,filexp("%b"));
    else
       strcpy(tmpbuffer,tosavename);
    if ((writefile = fos2open(tmpbuffer, "r+")) == NULL)
    {  if ((writefile = fos2open(tmpbuffer, "w")) == NULL)
       {  if (mailbox)
             fprintf(stderr,"Cannot open mailbox %s for output!\n",tmpbuffer);
          else
             fprintf(stderr,"Cannot open file %s for output!\n",tmpbuffer);
          fclose(readfile);
          fflush(stderr);
          return 1;
       }
       else newfile = TRUE;
    }
    if (!newfile)
    {  fseek(writefile, 0l, SEEK_END);    /* go to end of file (append) */
       fprintf(writefile,"\n");
    }

/*** OS2: there is a difference between the saver-commands "s" and "w".
          The global variable "savefrom" contains a byte-offset for
          the input-file, which can be used to strip the header off
          when the user used the w-command. But we only use this
          feature if we save an article (this routine is also
          used to save outgoing mail or post to the users
          out-mailboxes)                                      ***/
    if (!fromname)
        if (savefrom)
            fseek(readfile,savefrom,SEEK_SET);

    if (mailbox)
    {
       /*** Create a UUPC-compatible Mailbox with the
            following article separator ***/
       fprintf(writefile,"\n");

       /*** Create a From-line with the date of the article via
            filexp("%T") filexp("%[date]"). If this doesn't work,
            take easy default data.   ***/
       
       tmpptr = filexp("%T");           
       if ( (tmpptr == NULL) || (strlen(tmpptr) < 3) || (fromname))
           fprintf(writefile,"From %s",uupc_rc_settings.domain);
       else
           fprintf(writefile,"From %s",tmpptr);

       tmpptr = filexp("%[date]");
       if ( (tmpptr == NULL) || (strlen(tmpptr) < 3) || (fromname))
       {   timeinseconds = time(NULL);
        	strftime(tmpbuffer,255,"%a, %d %b %y %H:%M:%S %Z",
                                  localtime(&timeinseconds));
           fprintf(writefile," %s\n", tmpbuffer);
       }
       else
           fprintf(writefile," %s\n",tmpptr);
    }
/*** OS2: We had a serious problem with this combination of commands.
          The destination filled up the entire disk under certain
          circumstances. The second problem was, that fget's
          changed special characters, so that the save did not
          work for binary (I want to say uuencoded) files ***/
/*    while(fgets(tmpbuffer, 511, readfile))   */
/*          fprintf(writefile,tmpbuffer);      */

    while(!feof(readfile)) {
        nobjread = fread(tmpbuffer, 1, 80, readfile);
        fwrite(tmpbuffer, 1, nobjread, writefile);
    }

    fprintf(writefile,"\n");
    fclose(writefile);
    fclose(readfile);

    return 0;
}



/**************************************************
 ** this function will replace the shellscripts  **
 ** Rnmail. It will use the already prepared     **
 ** header and include the signature. It will    **
 ** also ask the user for a prepared text which  **
 ** will then be included. It will use the       **
 ** UUPC-Program "rmail" to send the mail.       **
 **************************************************/

void mail_reply(void)
{   FILE *header_fp, *include_fp, *signature_fp;
    char tmpbuffer[255+1];
    char cmd;
    int  linecounter;
    bool includesig = FALSE;

    if (strlen(uupc_rc_settings.signature) > 0) {
        sprintf(tmpbuffer,"%s/%s",uupc_rc_settings.home,
                                  uupc_rc_settings.signature);
        if (signature_fp = fopen(tmpbuffer,"r"))
           includesig = TRUE;
    }
    standout();
    printf("Prepared file to include [NONE]:");
    un_standout();
    printf(" ");
    fflush(stdout);
    fgets(tmpbuffer,255, stdin);
    tmpbuffer[strlen(tmpbuffer) - 1 ] = '\0';
    if(strlen(tmpbuffer) != 0) {
        if(include_fp = fopen(tmpbuffer,"r")) {
            if ((header_fp = fopen(headname,"r+")) != NULL) {
                fseek(header_fp,0l,SEEK_END);
                while(fgets(tmpbuffer,255,include_fp)) {
                    fprintf(header_fp,"%s",tmpbuffer); }
                if (includesig) {
                   printf("\nIncluding Signature...\n");
				   fflush(stdout);
                   fprintf(header_fp,"\n\n--\n");
                   while(fgets(tmpbuffer,255,signature_fp)) {
                       fprintf(header_fp,"%s",tmpbuffer); }
                }
                fclose(header_fp);
            }
            else
               printf("\nCannot open %s\n",tmpbuffer);
               fflush(stdout);
            fclose(include_fp);
        }
        if (includesig) fclose(signature_fp);
    } else {
        if (includesig) {
            if ((header_fp = fopen(headname,"r+")) != NULL) {
                printf("\nIncluding Signature...\n");
                fflush(stdout);
                fseek(header_fp,0l,SEEK_END);
                fprintf(header_fp,"\n\n--\n");
                while(fgets(tmpbuffer,255,signature_fp))
                    fprintf(header_fp,"%s",tmpbuffer);
                fclose(header_fp);
            }
            fclose(signature_fp);
        }
        sprintf(tmpbuffer, uupc_rc_settings.editor, headname);
        printf("Invoking %s\n",tmpbuffer);
        fflush(stdout);
        termlib_reset();
        system(tmpbuffer);
        termlib_init();
        un_standout();
    }

    cmd = ' ';
    while((cmd != 's')&&(cmd != 'S')&&(cmd != 'a')&&(cmd != 'A')) {
        printf("\n");
        standout();
        printf("Send, abort, edit, or list ?");
        un_standout();
        printf(" ");
        fflush(stdout);
        cmd = _read_kbd(0,1,0);
        printf("\n");
        switch(cmd) {
            case 's': case 'S':
                sprintf(tmpbuffer,"%s -f %s -t",
                                uupc_rc_settings.rmailpath,
                                headname);
                change_sl2bsl(tmpbuffer);
                printf("\nInvoking %s\n",tmpbuffer);
		        fflush(stdout);
                system(tmpbuffer);
                if (strlen(uupc_rc_settings.mailsent) > 0) {
                    sprintf(tmpbuffer,"%s/%s",uupc_rc_settings.home,
                                              uupc_rc_settings.mailsent);
                    printf("\nSaving mail to %s\n",tmpbuffer);
			        fflush(stdout);
                    if (article_saver(TRUE,headname,tmpbuffer))
                        printf("\nCannot save letter to %s\n",tmpbuffer);
                }
		        fflush(stdout);
                break;
            case 'a': case 'A':
                strcpy(tmpbuffer,uupc_rc_settings.home);
                strcat(tmpbuffer,"/dead.let");
                printf("\nSaving letter to %s\n",tmpbuffer);
		        fflush(stdout);
                if (article_saver(TRUE,headname,tmpbuffer))
                   printf("\nCannot save letter to %s\n",tmpbuffer);
		        fflush(stdout);
                break;
            case 'e': case 'E':
                sprintf(tmpbuffer, uupc_rc_settings.editor, headname);
                printf("\nInvoking %s\n",tmpbuffer);
                termlib_reset();
		        fflush(stdout);
                system(tmpbuffer);
                termlib_init();
                break;
            case 'l': case 'L':
                printf("\n");
                if(header_fp = fopen(headname,"r")) {
                    linecounter = 0;
                    while(fgets(tmpbuffer,255,header_fp))
                    {   linecounter += 1 + (strlen(tmpbuffer) / 80);
                        printf("%s",tmpbuffer);
                        if (linecounter >= LINES - 1)
                        {   linecounter = 0;
                            standout();
                            printf("--more--");
                            un_standout();
					        fflush(stdout);
                            _read_kbd(0,1,0);
                            carriage_return();
                            erase_eol();
                        }
                    }
	            fclose(header_fp);
                }
                break;
            default :
                puts("\nType s to send the message, a to abort and append the message");
                puts("to dead.let, e to edit the message again, l to list the message.");
		        fflush(stdout);
                break;
        }
    }
}



/*************************************************
 ** This function will read the article file    **
 ** and look for the header. It will then       **
 ** generate a correct header out of the        **
 ** already existing lines in the headname-file **
 ** and some new lines, that we must figure     **
 ** out first.                                  **
 *************************************************/

int complete_header(FILE *header_fp, char *dshortname, time_t timeinseconds)
{   char tmpbuffer[255+1], linebuffer[255+1];
    char *lineptr;
    bool OKline = FALSE;
    unsigned int linecounter = 0;
    FILE *tmp_fp, *body_fp;

    if ((tmp_fp = fos2open(dshortname,"w")) != NULL) {
        fprintf(tmp_fp,"Path: %s!%s\n",uupc_rc_settings.domain,
                                       uupc_rc_settings.user);
        fprintf(tmp_fp,"From: %s@%s (%s)\n",
                            uupc_rc_settings.user,
                            uupc_rc_settings.domain,
                            uupc_rc_settings.name);

        /*** now look for the newsgroups-line ***/
        while (!OKline) {
            if (!fgets(tmpbuffer,255,header_fp)) break;
            if (!strncmp(tmpbuffer,"Newsgroups:",11)) OKline = TRUE;
        }
        if (!OKline) {
            printf("Cannot find a 'Newsgroups:'-line in your header, nothing sent...\n");
            fclose(tmp_fp);
            fclose(header_fp);
            return 0;
        }
        fflush(stdout);
        fprintf(tmp_fp,"%s",tmpbuffer);

        OKline = FALSE;
        fflush(header_fp);
        rewind(header_fp);

        /*** now look for the subject-line ***/
        while (!OKline) {
            if (!fgets(tmpbuffer,255,header_fp)) break;
            if (!strncmp(tmpbuffer,"Subject:",8)) OKline = TRUE;
        }
        if (!OKline) {
            printf("Cannot find a 'Subject:'-line in your header, using '<none>'...\n");
            fprintf(tmp_fp,"Subject: <none>\n");
        }
        else fprintf(tmp_fp,"%s",tmpbuffer);
        fflush(stdout);

        OKline = FALSE;
        fflush(header_fp);
        rewind(header_fp);

        /*** now look for the Distribution-line ***/
        while (!OKline) {
            if (!fgets(tmpbuffer,255,header_fp)) break;
            if (!strncmp(tmpbuffer,"Distribution:",13)) OKline = TRUE;
        }
        if (!OKline) {
            printf("Cannot find a 'Distribution:'-line in your header, using 'world'...\n");
            fprintf(tmp_fp,"Distribution: world\n");
        }
        else fprintf(tmp_fp,"%s",tmpbuffer);
        fflush(stdout);

        fprintf(tmp_fp,"Message-ID: <%ld%s.%s@%s>\n",
                            timeinseconds,
                            uupc_rc_settings.user,
                            uupc_rc_settings.newsadmin,
                            uupc_rc_settings.domain);
        fprintf(tmp_fp,"Sender: %s@%s\n",
                            uupc_rc_settings.newsadmin,
                            uupc_rc_settings.domain);
/*** OS2: this ctime-call produced a time-string, which was
          rejected from my news-system. So the corresponding
          article was not transferred to other systems. Now
          I'm producing a string with strftime, which is processed
          by my own newsfeed. Strange is that the posting worked
          correctly on another newsfeed, where a friend of mine
          tested TRN-postings.   ***/
/**        fprintf(tmp_fp,"Date: %s",ctime(&timeinseconds));  **/
        strftime(tmpbuffer,255,"%a, %d %b %y %H:%M:%S %Z",
                                  localtime(&timeinseconds));
        fprintf(tmp_fp,"Date: %s\n",tmpbuffer);

        OKline = FALSE;
        fflush(header_fp);
        rewind(header_fp);

        while (!OKline) {
            if (!fgets(tmpbuffer,255,header_fp)) break;
            strcpy(linebuffer,tmpbuffer);
            if ((tmpbuffer[0] == ' ') ||
                (tmpbuffer[0] == '\n') ||
                (tmpbuffer[0] == '\r')) OKline = TRUE;
            if (!OKline) {
                /*** Don't copy lines, which we already have
                     in the final article and also skip lines
                     with missing contents or missing ": "***/
                if ((!strncmp(tmpbuffer,"Path:",5)) ||
                    (!strncmp(tmpbuffer,"From:",5)) ||
                    (!strncmp(tmpbuffer,"Newsgroups:",11)) ||
                    (!strncmp(tmpbuffer,"Subject:",8)) ||
                    (!strncmp(tmpbuffer,"Distribution:",13)) ||
                    (!strncmp(tmpbuffer,"Message-ID:",11)) ||
                    (!strncmp(tmpbuffer,"Sender:",7)) ||
                    (!strncmp(tmpbuffer,"Date:",5))) continue;

                if (!strtok(tmpbuffer,":")) continue;
                if (!(lineptr = strtok(NULL," "))) continue;
                if (strlen(lineptr) < 3) continue;

                fprintf(tmp_fp,"%s",linebuffer);
            }
        }

        if (!OKline) {
            printf("Cannot find end of header, nothing sent...\n");
	        fflush(stdout);
            fclose(tmp_fp);
            fclose(header_fp);
            return 0;
        }

        /*** copy rest of article to a temp-file, while counting
             the lines. ***/

        if ((body_fp = fos2open("body.art","w")) != NULL) {
            while (fgets(tmpbuffer,255,header_fp)) {
                fprintf(body_fp,"%s",tmpbuffer);
                linecounter++;
            }
        }
        else {
            printf("Cannot open tempfile (body.art), nothing sent...\n");
	        fflush(stdout);
            fclose(tmp_fp);
            fclose(header_fp);
            return(0);
        }

        /*** complete the header ***/
        fprintf(tmp_fp,"Lines: %d\n",linecounter);
        fprintf(tmp_fp,"\n");   /* additional \n marks end of header*/

        /** hmm, rewind didn't work on body_fp, so let's
            close and reopen it ***/
        fclose(body_fp);

        /*** and finally copy rest of the message ***/
        if ((body_fp = fos2open("body.art","r")) != NULL) {
            while (fgets(tmpbuffer,255,body_fp))
                fprintf(tmp_fp,"%s",tmpbuffer);
            fclose(body_fp);
            unlink("body.art");
        }
        else {
            printf("Cannot open tempfile (body.art), nothing sent...\n");
	        fflush(stdout);
            fclose(tmp_fp);
            fclose(header_fp);
            return 0;
        }

        fclose(tmp_fp);
        fclose(header_fp);
        return 1;
    }
    else {
        printf("Cannot open temp file (%s), nothing sent...\n",dshortname);
        fflush(stdout);
        return 0;
    }
}



/**************************************************
 ** this function will replace the shellscripts  **
 ** Pnews and Pnews.header. It will use the      **
 ** header and include the signature. It will    **
 ** also ask the user for a prepared text which  **
 ** will then be included.                       **
 **************************************************/

void article_poster(void)
{   FILE *header_fp, *include_fp, *signature_fp, *tmp_fp;
    char tmpbuffer[255+1];
    char dshortname[20+1], dlongname[20+1], xshortname[12+1], xlongname[12+1];
    char cmd;
    int  linecounter;
    bool includesig = FALSE;
    time_t timeinseconds;

    if (strlen(uupc_rc_settings.signature) > 0) {
        sprintf(tmpbuffer,"%s/%s",uupc_rc_settings.home,
                                  uupc_rc_settings.signature);
        if (signature_fp = fopen(tmpbuffer,"r"))
           includesig = TRUE;
    }
    standout();
    printf("Prepared file to include [NONE]:");
    un_standout();
    printf(" ");
    fflush(stdout);
    fgets(tmpbuffer,255, stdin);
    tmpbuffer[strlen(tmpbuffer) - 1 ] = '\0';
    if(strlen(tmpbuffer) != 0) {
        if(include_fp = fopen(tmpbuffer,"r")) {
            if ((header_fp = fopen(headname,"r+")) != NULL) {
                fseek(header_fp,0l,SEEK_END);
                while(fgets(tmpbuffer,255,include_fp)) {
                    fprintf(header_fp,"%s",tmpbuffer); }
                if (includesig) {
                   printf("\nIncluding Signature...\n");
                   fflush(stdout);
                   fprintf(header_fp,"\n\n--\n");
                   while(fgets(tmpbuffer,255,signature_fp)) {
                       fprintf(header_fp,"%s",tmpbuffer); }
                }
                fclose(header_fp);
            }
            else
               printf("\nCannot open %s\n",tmpbuffer);
            fflush(stdout);
            fclose(include_fp);
        }
        if (includesig) fclose(signature_fp);
    } else {
        if (includesig) {
            if ((header_fp = fopen(headname,"r+")) != NULL) {
                printf("\nIncluding Signature...\n");
                fflush(stdout);
                fseek(header_fp,0l,SEEK_END);
                fprintf(header_fp,"\n\n--\n");
                while(fgets(tmpbuffer,255,signature_fp))
                    fprintf(header_fp,"%s",tmpbuffer);
                fclose(header_fp);
            }
            fclose(signature_fp);
        }
        sprintf(tmpbuffer, uupc_rc_settings.editor, headname);
        printf("Invoking %s\n",tmpbuffer);
        termlib_reset();
        fflush(stdout);
        system(tmpbuffer);
        termlib_init();
        un_standout();
    }

    cmd = ' ';
    while((cmd != 's')&&(cmd != 'S')&&(cmd != 'a')&&(cmd != 'A')) {
        printf("\n");
        standout();
        printf("Send, abort, edit, or list ?");
        un_standout();
        printf(" ");
        fflush(stdout);
        cmd = _read_kbd(0,1,0);
        printf("\n");
        switch(cmd) {
            case 's': case 'S':
                /** ok, now let's complete the header of the article ***/

/*** OS2: This posting stuff,....... hmmm
          I hope that we can fix that later ***/

                if ((header_fp = fopen(headname,"r")) != NULL)
                {   timeinseconds = time(NULL);
	            strncpy(dshortname,uupc_rc_settings.site,8);
		    dshortname[8] = '\0';
		    strcat(dshortname,".D");
                    sprintf(tmpbuffer,"%04x",
         (unsigned short)((short)(timeinseconds/131072)-(short)timeinseconds));
                    sprintf(dlongname,"D.%s%.4s",uupc_rc_settings.site,
                                                 tmpbuffer);
	            strncpy(xshortname,uupc_rc_settings.site,8);
		    xshortname[8] = '\0';
		    strcat(xshortname,".X");
                    sprintf(xlongname,"X.%s%.4s",uupc_rc_settings.site,
                                                 tmpbuffer);
                    if (complete_header(header_fp,dshortname,timeinseconds))
                        if ((tmp_fp = fos2open(xshortname,"w")) != NULL)
                        {   fprintf(tmp_fp, "U news %s\n",
                                          uupc_rc_settings.site);
                            fprintf(tmp_fp, "Z\n");
                            fprintf(tmp_fp, "F %s\n", dlongname);
                            fprintf(tmp_fp, "I %s\n", dlongname);
                            fprintf(tmp_fp, "C rnews\n");
                            fclose(tmp_fp);
                            sprintf(tmpbuffer,"uucp -C %s %s!%s",
                                                 xshortname,
                                                 uupc_rc_settings.mail_server,
                                                 xlongname);
                            printf("Invoking %s\n",tmpbuffer);
					        fflush(stdout);
                            system(tmpbuffer);
                            sprintf(tmpbuffer,"uucp -C %s %s!%s",
                                                 dshortname,
                                                 uupc_rc_settings.mail_server,
                                                 dlongname);
                            printf("Invoking %s\n",tmpbuffer);
					        fflush(stdout);
                            system(tmpbuffer);

                            printf("Now posting the article locally...\n");
                 /*** Our Rnews is quit  intelligent, it can
                      not only handle compressed batches, it can
                      also handle normal files...  Thanx Jan and Harald
                      But we have a litte problem, the active file is
                      already open....        ***/
                            fclose(actfp);
                            sprintf(tmpbuffer,"rnews <%s",dshortname);
                            printf("Invoking %s\n",tmpbuffer);
					        fflush(stdout);
                            system(tmpbuffer);
                            ngdata_init();  /* re-grab the active file */
                            unlink(dshortname);
                            unlink(xshortname);
                        }
                        else printf("Cannot open temp file (%s), nothing sent...\n",xshortname);
                }
                else printf("Cannot open article file, nothing sent...\n");
                sprintf(tmpbuffer,"%s/Postings",uupc_rc_settings.home);
                printf("\nSaving article to %s\n",tmpbuffer);
		        fflush(stdout);
                if (article_saver(TRUE,headname,tmpbuffer))
                    printf("\nCannot save article as letter to %s\n",tmpbuffer);
                unlink(headname);
		        fflush(stdout);
                break;
            case 'a': case 'A':
                strcpy(tmpbuffer,uupc_rc_settings.home);
                strcat(tmpbuffer,"/deadpost.let");
                printf("\nSaving to %s\n",tmpbuffer);
		        fflush(stdout);
                if (article_saver(TRUE,headname,tmpbuffer))
                   printf("\nCannot save letter to %s\n",tmpbuffer);
		        fflush(stdout);
                break;
            case 'e': case 'E':
                sprintf(tmpbuffer, uupc_rc_settings.editor, headname);
                printf("\nInvoking %s\n",tmpbuffer);
                termlib_reset();
		        fflush(stdout);
                system(tmpbuffer);
                termlib_init();
                break;
            case 'l': case 'L':
                printf("\n");
                if(header_fp = fopen(headname,"r")) {
                    linecounter = 0;
                    while(fgets(tmpbuffer,255,header_fp))
                    {   linecounter += 1 + (strlen(tmpbuffer) / 80);
                        printf("%s",tmpbuffer);
                        if (linecounter >= LINES - 1)
                        {   linecounter = 0;
                            standout();
                            printf("--more--");
                            un_standout();
					        fflush(stdout);
                            _read_kbd(0,1,0);
                            carriage_return();
                            erase_eol();
                        }
                    }
	            fclose(header_fp);
                }
                break;
            default :
                puts("\nType s to send the article, a to abort and append the article");
                puts("to deadpost.let, e to edit the article again, l to list the article.");
                fflush(stdout);
                break;
        }
    }
}




/**************************************************
 ** this function will replace the shellscript   **
 ** newsgroups. It will use the .newsrc-file     **
 ** to search for unsubscribed newsgroups. It    **
 ** will use the ! or : characters to find out   **
 ** if newsgroup is subscribed or not.           **
 **************************************************/

int unsub_group(char *pattern)
{   char tmpbuffer[255+1];
    int  counter;
    FILE *newsrcfp;

    strcpy(tmpbuffer,filexp(RCNAME));
    if ((newsrcfp = fos2open(tmpbuffer,"r")) == NULL) {
        printf("Cannot open .newsrc!\n");
        fflush(stdout);
        return 1;
    }

    printf("Completely unsubscribed Newsgroups:\n");
    while (fgets(tmpbuffer,255,newsrcfp)) {
/*** OS2: I don't know why, but strtok didn't work ***/
        for (counter = 0; (tmpbuffer[counter] != '\0') &&
                          (tmpbuffer[counter] != ':')      ; counter++)
            if (tmpbuffer[counter] == '!') {
                tmpbuffer[counter] = '\0';
                tmpbuffer[counter+1] = '\0';
                if (strlen(pattern) < 1)
                    printf("%s\n",tmpbuffer);
                else
                    if (strstr(tmpbuffer,pattern)) printf("%s\n",tmpbuffer);
            }
    }
    fflush(stdout);

    fclose(newsrcfp);
    return 0;
}

